/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v3.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.dao.UniversalUnifiedDAO;
import org.ow2.dragon.service.uddi.v3.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v3.error.FatalErrorException;
import org.ow2.dragon.service.uddi.v3.impl.UDDITransferObjectAssembler;
import org.ow2.dragon.service.uddi.v3.validator.PublicationValidator;
import org.ow2.dragon.util.FileReaderUtil;
import org.ow2.dragon.util.UDDIUseType;
import org.springframework.transaction.annotation.Transactional;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.AssertionStatusReport;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.GetAssertionStatusReport;
import org.uddi.api_v3.GetPublisherAssertions;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PublisherAssertions;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.SetPublisherAssertions;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3_porttype.DispositionReportFaultMessage;
import org.uddi.api_v3_porttype.UDDIPublicationPortType;

public class UDDIPublicationImpl
implements UDDIPublicationPortType {
    private PublicationValidator validator;
    private UniversalUnifiedDAO universalUnifiedDAO;
    private UDDITransferObjectAssembler transferObjectAssembler;
    private Logger logger = Logger.getLogger(UDDIPublicationImpl.class);
    private MetadataService metadataService;

    public UDDIPublicationImpl(UniversalUnifiedDAO universalUnifiedDAO, MetadataService metadataService) {
        this.universalUnifiedDAO = universalUnifiedDAO;
        this.transferObjectAssembler = new UDDITransferObjectAssembler(universalUnifiedDAO);
        this.validator = new PublicationValidator();
        this.metadataService = metadataService;
    }

    public void addPublisherAssertions(AddPublisherAssertions body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public void deleteBinding(DeleteBinding body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public void deleteBusiness(DeleteBusiness body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public void deletePublisherAssertions(DeletePublisherAssertions body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public void deleteService(DeleteService body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public void deleteTModel(DeleteTModel body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public AssertionStatusReport getAssertionStatusReport(GetAssertionStatusReport body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public PublisherAssertions getPublisherAssertions(GetPublisherAssertions body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public RegisteredInfo getRegisteredInfo(GetRegisteredInfo body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public BindingDetail saveBinding(SaveBinding body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public BusinessDetail saveBusiness(SaveBusiness body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public ServiceDetail saveService(SaveService body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    @Transactional(rollbackFor={DispositionReportFaultMessage.class})
    public TModelDetail saveTModel(SaveTModel body) throws DispositionReportFaultMessage {
        this.validator.validateSaveTModel(body);
        TModelDetail result = new TModelDetail();
        List<TModel> apiTModelList = body.getTModel();
        for (TModel apiTModel : apiTModelList) {
            List<KeyedReference> identifierBag;
            org.ow2.dragon.persistence.bo.common.TModel modelTModel = this.transferObjectAssembler.toDragonTModel(apiTModel);
            if (modelTModel.getId() != null && this.tModelExist(modelTModel.getId())) continue;
            this.universalUnifiedDAO.save((Object)modelTModel);
            this.logger.debug((Object)("Register TModel with id: " + modelTModel.getId()));
            CategoryBag categoryBag = this.transferObjectAssembler.toDragonCategoryBag(apiTModel.getCategoryBag());
            if (categoryBag != null) {
                modelTModel.setCategoryBag(categoryBag);
            }
            if ((identifierBag = this.transferObjectAssembler.toDragonIdentifierBag(apiTModel.getIdentifierBag())) != null && !identifierBag.isEmpty()) {
                modelTModel.setIdentifierBag(identifierBag);
            }
            this.processOverviewDocs(apiTModel, modelTModel);
            this.universalUnifiedDAO.save((Object)modelTModel);
        }
        return result;
    }

    private void processOverviewDocs(TModel apiTModel, org.ow2.dragon.persistence.bo.common.TModel modelTModel) {
        List<OverviewDoc> overviewDocs = apiTModel.getOverviewDoc();
        if (overviewDocs != null) {
            for (OverviewDoc overviewDoc : overviewDocs) {
                this.registerOverviewDoc(overviewDoc, modelTModel);
            }
        }
    }

    private void registerOverviewDoc(OverviewDoc overviewDoc, org.ow2.dragon.persistence.bo.common.TModel modelTModel) {
        List<JAXBElement<?>> content = overviewDoc.getContent();
        if (content != null) {
            for (JAXBElement<?> element : content) {
                Object elementContent = element.getValue();
                if (!(elementContent instanceof OverviewURL)) continue;
                URI uri = URI.create(((OverviewURL)elementContent).getValue().trim());
                UDDIUseType useType = UDDIUseType.fromString((String)((OverviewURL)elementContent).getUseType());
                if (!UDDIUseType.VALUE_SET.equals((Object)useType)) continue;
                try {
                    SimpleFile registeredOverviewDoc = this.metadataService.storeMetadata(null, uri, null, useType);
                    modelTModel.addOverviewDoc(registeredOverviewDoc);
                    if (!UDDIUseType.VALUE_SET.equals((Object)useType) || !(modelTModel instanceof Category)) continue;
                    this.extractCategoryTModelValues(modelTModel, registeredOverviewDoc);
                }
                catch (MetadataServiceException e) {
                    this.logger.warn((Object)("Failed to register an overview Doc ('" + uri.toString() + "') for tmodel: " + modelTModel.getId()), (Throwable)e);
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Failed to extract values from a valueSet overview Doc ('" + uri.toString() + "') for tmodel: " + modelTModel.getId()), (Throwable)e);
                }
            }
        }
    }

    private void extractCategoryTModelValues(org.ow2.dragon.persistence.bo.common.TModel modelTModel, SimpleFile registeredOverviewDoc) throws IOException, MetadataServiceException {
        List lines = FileReaderUtil.readLines((InputStream)this.metadataService.loadMetadataContentAsInputStream(registeredOverviewDoc.getId()), (String)";");
        if (lines != null) {
            for (String[] line : lines) {
                if (line.length < 2) continue;
                CategoryValue categoryValue = new CategoryValue(line[0], line[1]);
                ((Category)modelTModel).addValue(categoryValue);
            }
        }
    }

    private boolean tModelExist(String id) {
        return this.universalUnifiedDAO.get(org.ow2.dragon.persistence.bo.common.TModel.class, (Serializable)((Object)id)) != null;
    }

    public PublisherAssertions setPublisherAssertions(SetPublisherAssertions body) throws DispositionReportFaultMessage {
        throw new FatalErrorException(new ErrorMessage("errors.Unsupported"));
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }
}

