/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v3.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Link;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.DiscoveryUrl;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.PhoneNumber;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.dao.UniversalUnifiedDAO;
import org.ow2.dragon.service.uddi.v3.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v3.error.InvalidKeyPassedException;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.DragonRepoFileLocator;
import org.ow2.dragon.util.TModelType;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.Email;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.ListDescription;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ObjectFactory;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.Phone;
import org.uddi.api_v3.RelatedBusinessInfo;
import org.uddi.api_v3.RelatedBusinessInfos;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDDITransferObjectAssembler {
    private static final String ACCESSPOINT_USETYPE_EP = "endpoint";
    private Logger logger = Logger.getLogger(this.getClass());
    private HttpServletRequest request;
    private static final String CATEGORIZATION_KEY = "uddi:uddi.org:categorization:types";
    private UniversalUnifiedDAO universalUnifiedDAO;

    public UDDITransferObjectAssembler(UniversalUnifiedDAO universalUnifiedDAO) {
        this.universalUnifiedDAO = universalUnifiedDAO;
    }

    public BusinessEntity toUDDIBusiness(OrganizationUnit dragonBusiness) {
        List dragonDiscoveryUrls;
        List descriptions;
        BusinessEntity apiBusiness = new BusinessEntity();
        apiBusiness.setBusinessKey(dragonBusiness.getId());
        apiBusiness.setCategoryBag(this.toUDDICategoryBag(dragonBusiness.getCategoryBag()));
        apiBusiness.setIdentifierBag(this.toUDDIIdentifierBag(dragonBusiness.getIdentifierBag()));
        List names = dragonBusiness.getNames();
        if (names != null) {
            List<Name> apiNames = apiBusiness.getName();
            for (org.ow2.dragon.persistence.bo.common.Name name : names) {
                apiNames.add(this.toUDDIName(name));
            }
        }
        if ((descriptions = dragonBusiness.getDescriptions()) != null) {
            List<Description> apiDescriptions = apiBusiness.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
        }
        if ((dragonDiscoveryUrls = dragonBusiness.getDiscoveryUrls()) != null) {
            DiscoveryURLs apiDiscoveryURLs = new DiscoveryURLs();
            List<DiscoveryURL> apiDiscoveryURLList = apiDiscoveryURLs.getDiscoveryURL();
            for (DiscoveryUrl discoveryUrl : dragonDiscoveryUrls) {
                apiDiscoveryURLList.add(this.toUDDIDiscoveryUrl(discoveryUrl));
            }
            apiBusiness.setDiscoveryURLs(apiDiscoveryURLs);
        }
        apiBusiness.setContacts(this.retrieveOrganizationContacts(dragonBusiness));
        apiBusiness.setBusinessServices(this.retrieveLinkedBusinessServices(dragonBusiness));
        return apiBusiness;
    }

    private BusinessServices retrieveLinkedBusinessServices(OrganizationUnit dragonBusiness) {
        BusinessServices businessServices = new BusinessServices();
        Set roles = dragonBusiness.getFromLinks();
        if (roles != null) {
            List<BusinessService> apiServices = businessServices.getBusinessService();
            for (Link role : roles) {
                if (!(role.getTo() instanceof TechnicalService) || !role.getType().equalsIgnoreCase("Provider")) continue;
                TechnicalService techServ = (TechnicalService)role.getTo();
                apiServices.add(this.toUDDIService(techServ));
            }
        }
        return businessServices;
    }

    private Contacts retrieveOrganizationContacts(OrganizationUnit dragonBusiness) {
        Contacts contacts = new Contacts();
        List<Contact> apiContacts = contacts.getContact();
        Set parties = dragonBusiness.getParties();
        if (parties != null) {
            for (Party party : parties) {
                Person person;
                if (!(party instanceof Person) || !(person = (Person)party).isContact() && (person.getPost() == null || !person.getPost().isContact())) continue;
                apiContacts.add(this.toUDDIContact(person));
            }
        }
        return contacts;
    }

    private Contact toUDDIContact(Person person) {
        List orgAddresses;
        List dragonEmails;
        List dragonPhones;
        Contact contact = new Contact();
        if (person.getPost() != null) {
            contact.setUseType(person.getPost().getNature());
        }
        List names = person.getNames();
        List<PersonName> apiNames = contact.getPersonName();
        if (names != null) {
            for (org.ow2.dragon.persistence.bo.common.Name name : names) {
                apiNames.add(this.toUDDIPersonName(name));
            }
        }
        apiNames.add(this.toUDDIPersonName(person.getPost()));
        List descriptions = person.getDescriptions();
        if (descriptions != null) {
            List<Description> apiDescriptions = contact.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
            apiDescriptions.add(this.toUDDIDescription(person.getPost()));
        }
        if ((dragonPhones = person.getPhoneNumbers()) != null) {
            List<Phone> apiPhones = contact.getPhone();
            for (PhoneNumber phone : dragonPhones) {
                apiPhones.add(this.toUDDIPhone(phone));
            }
        }
        if ((dragonEmails = person.getEmailAddresses()) != null) {
            List<Email> apiEmails = contact.getEmail();
            for (org.ow2.dragon.persistence.bo.organization.Email email : dragonEmails) {
                apiEmails.add(this.toUDDIEmail(email));
            }
        }
        List dragonAddresses = person.getAddresses();
        List<org.uddi.api_v3.Address> apiAddresses = contact.getAddress();
        if (dragonAddresses != null) {
            for (Address address : dragonAddresses) {
                apiAddresses.add(this.toUDDIAddress(address));
            }
        }
        if (person.getParentOrganization() != null && (orgAddresses = person.getParentOrganization().getAddresses()) != null) {
            for (Address address : orgAddresses) {
                apiAddresses.add(this.toUDDIAddress(address));
            }
        }
        return contact;
    }

    private Description toUDDIDescription(Post post) {
        Description apiDescription = null;
        if (post != null) {
            apiDescription = new Description();
            apiDescription.setLang("EN-us");
            apiDescription.setValue(post.getDescription());
        }
        return apiDescription;
    }

    private org.uddi.api_v3.Address toUDDIAddress(Address address) {
        org.uddi.api_v3.Address apiAddress = null;
        if (address != null) {
            List dragonLines;
            apiAddress = new org.uddi.api_v3.Address();
            apiAddress.setLang(address.getLangCode());
            apiAddress.setUseType(address.getUseType());
            if (address.getTModel() != null) {
                apiAddress.setTModelKey(address.getTModel().getId());
            }
            if ((dragonLines = address.getAddressLines()) != null) {
                List<org.uddi.api_v3.AddressLine> apiLines = apiAddress.getAddressLine();
                for (AddressLine addressLine : dragonLines) {
                    apiLines.add(this.toUDDIAddressLine(addressLine));
                }
            }
        }
        return apiAddress;
    }

    private org.uddi.api_v3.AddressLine toUDDIAddressLine(AddressLine addressLine) {
        org.uddi.api_v3.AddressLine apiAddressLine = null;
        if (addressLine != null) {
            apiAddressLine = new org.uddi.api_v3.AddressLine();
            apiAddressLine.setKeyName(addressLine.getKeyName());
            apiAddressLine.setKeyValue(addressLine.getKeyValue());
            apiAddressLine.setValue(addressLine.getAddressLine());
        }
        return apiAddressLine;
    }

    private Email toUDDIEmail(org.ow2.dragon.persistence.bo.organization.Email email) {
        Email apiEmail = null;
        if (email != null) {
            apiEmail = new Email();
            apiEmail.setUseType(email.getUseType());
            apiEmail.setValue(email.getEmail());
        }
        return apiEmail;
    }

    private Phone toUDDIPhone(PhoneNumber phone) {
        Phone apiPhone = null;
        if (phone != null) {
            apiPhone = new Phone();
            apiPhone.setUseType(phone.getUseType());
            apiPhone.setValue(phone.getPhoneNumber());
        }
        return apiPhone;
    }

    private PersonName toUDDIPersonName(Post post) {
        PersonName apiName = null;
        if (post != null) {
            apiName = new PersonName();
            apiName.setValue(post.getName());
        }
        return apiName;
    }

    private DiscoveryURL toUDDIDiscoveryUrl(DiscoveryUrl discoveryUrl) {
        DiscoveryURL apiUrl = null;
        if (discoveryUrl != null) {
            apiUrl = new DiscoveryURL();
            apiUrl.setUseType(discoveryUrl.getUseType());
            apiUrl.setValue(discoveryUrl.getUrl());
        }
        return apiUrl;
    }

    private DiscoveryUrl toDragonDiscoveryUrl(DiscoveryURL discoveryUrl) {
        DiscoveryUrl dragonUrl = null;
        if (discoveryUrl != null) {
            dragonUrl = new DiscoveryUrl();
            dragonUrl.setUseType(discoveryUrl.getUseType());
            dragonUrl.setUrl(discoveryUrl.getValue());
        }
        return dragonUrl;
    }

    public List<DiscoveryUrl> toDragonDiscoveryUrls(DiscoveryURLs discoveryURLs) {
        List<DiscoveryURL> apiDiscoveryURLs;
        ArrayList<DiscoveryUrl> dragonDiscoveryUrls = new ArrayList<DiscoveryUrl>();
        if (discoveryURLs != null && (apiDiscoveryURLs = discoveryURLs.getDiscoveryURL()) != null) {
            for (DiscoveryURL discoveryUrl : apiDiscoveryURLs) {
                dragonDiscoveryUrls.add(this.toDragonDiscoveryUrl(discoveryUrl));
            }
        }
        return dragonDiscoveryUrls;
    }

    public BusinessService toUDDIService(TechnicalService dragonService) {
        List descriptions;
        BusinessService apiService = new BusinessService();
        apiService.setServiceKey(dragonService.getId());
        List names = dragonService.getNames();
        if (names != null) {
            List<Name> apiNames = apiService.getName();
            for (org.ow2.dragon.persistence.bo.common.Name name : names) {
                apiNames.add(this.toUDDIName(name));
            }
        }
        if ((descriptions = dragonService.getDescriptions()) != null) {
            List<Description> apiDescriptions = apiService.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
        }
        apiService.setCategoryBag(this.toUDDICategoryBag(dragonService.getCategoryBag()));
        apiService.setBusinessKey(this.retrieveBusinessKeyFormTechServ(dragonService));
        Set eps = dragonService.getEndpoints();
        if (eps != null) {
            BindingTemplates bindingTemplates = new BindingTemplates();
            List<BindingTemplate> apiBindings = bindingTemplates.getBindingTemplate();
            for (Endpoint ep : eps) {
                apiBindings.add(this.toUDDIBindingTemplate(ep));
            }
            apiService.setBindingTemplates(bindingTemplates);
        }
        return apiService;
    }

    private String retrieveBusinessKeyFormTechServ(TechnicalService dragonService) {
        String bKey = null;
        Set roles = dragonService.getToLinks();
        if (roles != null) {
            for (Link partyToTechService : roles) {
                if (!"Provider".equalsIgnoreCase(partyToTechService.getType())) continue;
                bKey = partyToTechService.getFrom().getId();
                break;
            }
        }
        return bKey;
    }

    public BindingTemplate toUDDIBindingTemplate(Endpoint dragonEP) {
        BindingTemplate apiBinding = new BindingTemplate();
        apiBinding.setBindingKey(dragonEP.getId());
        apiBinding.setServiceKey(dragonEP.getTechnicalService().getId());
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setUseType(ACCESSPOINT_USETYPE_EP);
        accessPoint.setValue(dragonEP.getNetworkAddress());
        apiBinding.setAccessPoint(accessPoint);
        List descriptions = dragonEP.getDescriptions();
        if (descriptions != null) {
            List<Description> apiDescriptions = apiBinding.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
        }
        apiBinding.setCategoryBag(this.toUDDICategoryBag(dragonEP.getCategoryBag()));
        TModelInstanceDetails instanceDetails = new TModelInstanceDetails();
        List<TModelInstanceInfo> instanceInfos = instanceDetails.getTModelInstanceInfo();
        Set serviceSpecs = dragonEP.getTechnicalService().getServiceSpecifications();
        if (serviceSpecs != null) {
            for (ServiceSpecification serviceSpecification : serviceSpecs) {
                TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
                instanceInfo.setTModelKey(serviceSpecification.getId());
                instanceInfos.add(instanceInfo);
            }
        }
        TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
        instanceInfo.setTModelKey(dragonEP.getBinding().getId());
        org.ow2.dragon.persistence.bo.common.Description description = new org.ow2.dragon.persistence.bo.common.Description();
        description.setLangCode("en");
        description.setDescription("The wsdl:binding that this wsdl:port (endpoint) implements.");
        instanceInfo.getDescription().add(this.toUDDIDescription(description));
        instanceInfos.add(instanceInfo);
        TModelInstanceInfo instanceInfo2 = new TModelInstanceInfo();
        instanceInfo2.setTModelKey(dragonEP.getBinding().getServiceInterface().getId());
        org.ow2.dragon.persistence.bo.common.Description description2 = new org.ow2.dragon.persistence.bo.common.Description();
        description2.setLangCode("en");
        description2.setDescription("The wsdl:portType (interface) that this wsdl:port (endpoint) implements.");
        instanceInfo2.getDescription().add(this.toUDDIDescription(description2));
        instanceInfos.add(instanceInfo2);
        return apiBinding;
    }

    public TModel toUDDITModel(org.ow2.dragon.persistence.bo.common.TModel dragonTModel) {
        ArrayList serviceSpecs;
        TModel apiTModel = new TModel();
        apiTModel.setName(this.toUDDIName(dragonTModel.getName()));
        apiTModel.setCategoryBag(this.toUDDICategoryBag(dragonTModel.getCategoryBag()));
        apiTModel.setDeleted(dragonTModel.isDeleted());
        apiTModel.setIdentifierBag(this.toUDDIIdentifierBag(dragonTModel.getIdentifierBag()));
        apiTModel.setTModelKey(dragonTModel.getId());
        List descriptions = dragonTModel.getDescriptions();
        if (descriptions != null) {
            List<Description> apiDescriptions = apiTModel.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
        }
        List simpleFiles = dragonTModel.getOverviewDocs();
        if (dragonTModel instanceof ServiceInterface) {
            serviceSpecs = new ArrayList(((ServiceInterface)dragonTModel).getServiceSpecs());
            simpleFiles.addAll(((ServiceSpecification)serviceSpecs.get(0)).getOverviewDocs());
        } else if (dragonTModel instanceof Binding) {
            serviceSpecs = new ArrayList(((Binding)dragonTModel).getServiceSpecifications());
            simpleFiles.addAll(((ServiceSpecification)serviceSpecs.get(0)).getOverviewDocs());
        }
        if (simpleFiles != null) {
            List<OverviewDoc> apiDocs = apiTModel.getOverviewDoc();
            for (SimpleFile simpleFile : simpleFiles) {
                apiDocs.add(this.toUDDIOverviewDoc(simpleFile));
            }
        }
        return apiTModel;
    }

    public org.ow2.dragon.persistence.bo.common.TModel toDragonTModel(TModel uddiTModel) throws InvalidKeyPassedException {
        org.ow2.dragon.persistence.bo.common.TModel dragonTModel = null;
        TModelType tModelType = this.getTModelType(uddiTModel);
        if (tModelType != null) {
            switch (tModelType) {
                case CATEGORY: {
                    dragonTModel = new Category();
                    break;
                }
                case IDENTIFIER: {
                    dragonTModel = new Identifier();
                    break;
                }
                case PROTOCOL: {
                    dragonTModel = new Protocol();
                    break;
                }
                case TRANSPORT: {
                    dragonTModel = new Transport();
                    break;
                }
                default: {
                    dragonTModel = new org.ow2.dragon.persistence.bo.common.TModel();
                    break;
                }
            }
        } else {
            dragonTModel = new org.ow2.dragon.persistence.bo.common.TModel();
        }
        dragonTModel.setName(this.toDragonName(uddiTModel.getName()));
        dragonTModel.setDeleted(uddiTModel.isDeleted());
        dragonTModel.setId(uddiTModel.getTModelKey());
        List<Description> descriptions = uddiTModel.getDescription();
        if (descriptions != null) {
            List dragonDescriptions = dragonTModel.getDescriptions();
            for (Description description : descriptions) {
                dragonDescriptions.add(this.toDragonDescription(description));
            }
        }
        return dragonTModel;
    }

    private TModelType getTModelType(TModel uddiTModel) {
        TModelType tModelType;
        block1: {
            org.uddi.api_v3.KeyedReference current;
            JAXBElement<?> element;
            Object elementContent;
            List<JAXBElement<?>> content;
            tModelType = null;
            if (uddiTModel.getCategoryBag() == null || (content = uddiTModel.getCategoryBag().getContent()) == null) break block1;
            Iterator<JAXBElement<?>> i$ = content.iterator();
            while (!(!i$.hasNext() || (elementContent = (element = i$.next()).getValue()) instanceof org.uddi.api_v3.KeyedReference && CATEGORIZATION_KEY.equals((current = (org.uddi.api_v3.KeyedReference)elementContent).getTModelKey()) && (tModelType = TModelType.fromString((String)current.getKeyValue())) != null)) {
            }
        }
        return tModelType;
    }

    public org.ow2.dragon.persistence.bo.common.Description toDragonDescription(Description description) {
        org.ow2.dragon.persistence.bo.common.Description dragonDescription = null;
        if (description != null) {
            dragonDescription = new org.ow2.dragon.persistence.bo.common.Description();
            dragonDescription.setLangCode(description.getLang());
            dragonDescription.setDescription(description.getValue());
        }
        return dragonDescription;
    }

    private OverviewDoc toUDDIOverviewDoc(SimpleFile simpleFile) {
        OverviewDoc overviewDoc = null;
        if (simpleFile != null) {
            overviewDoc = new OverviewDoc();
            String overviewURL = "";
            try {
                overviewURL = DragonRepoFileLocator.getRepoFileURL((ContentType)simpleFile.getFileType(), (String)simpleFile.getFileName(), (String)simpleFile.getId(), (HttpServletRequest)this.request);
            }
            catch (IOException e) {
                this.logger.warn((Object)"Can't create document overview URL", (Throwable)e);
            }
            OverviewURL apiOverviewUrl = new OverviewURL();
            apiOverviewUrl.setValue(overviewURL);
            apiOverviewUrl.setUseType(simpleFile.getFileType().toString());
            overviewDoc.getContent().add(new ObjectFactory().createOverviewURL(apiOverviewUrl));
        }
        return overviewDoc;
    }

    private Description toUDDIDescription(org.ow2.dragon.persistence.bo.common.Description description) {
        Description apiDescription = null;
        if (description != null) {
            apiDescription = new Description();
            apiDescription.setLang(description.getLangCode());
            apiDescription.setValue(description.getDescription());
        }
        return apiDescription;
    }

    private IdentifierBag toUDDIIdentifierBag(List<KeyedReference> identifierBag) {
        IdentifierBag apiBag = null;
        if (identifierBag != null) {
            apiBag = new IdentifierBag();
            for (KeyedReference keyedReference : identifierBag) {
                apiBag.getKeyedReference().add(this.toUDDIKeyedReference(keyedReference));
            }
        }
        return apiBag;
    }

    private org.uddi.api_v3.KeyedReference toUDDIKeyedReference(KeyedReference keyedReference) {
        org.uddi.api_v3.KeyedReference apiKeyedReference = null;
        if (keyedReference != null) {
            apiKeyedReference = new org.uddi.api_v3.KeyedReference();
            apiKeyedReference.setKeyName(keyedReference.getKeyName());
            apiKeyedReference.setKeyValue(keyedReference.getKeyValue());
            if (keyedReference.getTmodel() != null) {
                apiKeyedReference.setTModelKey(keyedReference.getTmodel().getId());
            }
        }
        return apiKeyedReference;
    }

    private org.uddi.api_v3.CategoryBag toUDDICategoryBag(CategoryBag categoryBag) {
        org.uddi.api_v3.CategoryBag apiBag = null;
        if (categoryBag != null) {
            apiBag = new org.uddi.api_v3.CategoryBag();
            List keyedReferences = categoryBag.getKeyedReferences();
            List keyedReferenceGroups = categoryBag.getKeyedReferenceGroups();
            List<JAXBElement<?>> apiCategoryList = apiBag.getContent();
            if (keyedReferences != null) {
                for (KeyedReference keyedReference : keyedReferences) {
                    org.uddi.api_v3.KeyedReference apiKeyedReference = this.toUDDIKeyedReference(keyedReference);
                    apiCategoryList.add(new ObjectFactory().createKeyedReference(apiKeyedReference));
                }
            }
            if (keyedReferenceGroups != null) {
                for (org.ow2.dragon.persistence.bo.common.KeyedReferenceGroup keyedReferenceGroup : keyedReferenceGroups) {
                    KeyedReferenceGroup apiKeyedReferenceGroup = this.toUDDIKeyedReferenceGroup(keyedReferenceGroup);
                    apiCategoryList.add(new ObjectFactory().createKeyedReferenceGroup(apiKeyedReferenceGroup));
                }
            }
        }
        return apiBag;
    }

    private KeyedReferenceGroup toUDDIKeyedReferenceGroup(org.ow2.dragon.persistence.bo.common.KeyedReferenceGroup keyedReferenceGroup) {
        KeyedReferenceGroup apiKeyedReferenceGroup = null;
        if (keyedReferenceGroup != null) {
            apiKeyedReferenceGroup = new KeyedReferenceGroup();
            apiKeyedReferenceGroup.setTModelKey(keyedReferenceGroup.getTmodel().getId());
            List keyedReferences = keyedReferenceGroup.getKeyedReferences();
            List<org.uddi.api_v3.KeyedReference> apiKeyedReferences = apiKeyedReferenceGroup.getKeyedReference();
            if (keyedReferences != null) {
                for (KeyedReference keyedReference : keyedReferences) {
                    apiKeyedReferences.add(this.toUDDIKeyedReference(keyedReference));
                }
            }
        }
        return apiKeyedReferenceGroup;
    }

    public Name toUDDIName(org.ow2.dragon.persistence.bo.common.Name dragonName) {
        Name apiName = null;
        if (dragonName != null) {
            apiName = new Name();
            apiName.setLang(dragonName.getLangCode());
            apiName.setValue(dragonName.getName());
        }
        return apiName;
    }

    public PersonName toUDDIPersonName(org.ow2.dragon.persistence.bo.common.Name dragonName) {
        PersonName apiName = null;
        if (dragonName != null) {
            apiName = new PersonName();
            apiName.setLang(dragonName.getLangCode());
            apiName.setValue(dragonName.getName());
        }
        return apiName;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public CategoryBag toDragonCategoryBag(org.uddi.api_v3.CategoryBag categoryBag) throws InvalidKeyPassedException {
        CategoryBag dragonBag = null;
        if (categoryBag != null) {
            dragonBag = new CategoryBag();
            List<JAXBElement<?>> content = categoryBag.getContent();
            if (content != null) {
                for (JAXBElement<?> element : content) {
                    Object elementContent = element.getValue();
                    if (elementContent instanceof org.uddi.api_v3.KeyedReference) {
                        dragonBag.addKeyedReference(this.toDragonKeyedReference((org.uddi.api_v3.KeyedReference)elementContent));
                        continue;
                    }
                    if (!(elementContent instanceof KeyedReferenceGroup)) continue;
                    dragonBag.addKeyedReferenceGroup(this.toDragonKeyedReferenceGroup((KeyedReferenceGroup)elementContent));
                }
            }
        }
        return dragonBag;
    }

    private KeyedReference toDragonKeyedReference(org.uddi.api_v3.KeyedReference apiKR) throws InvalidKeyPassedException {
        KeyedReference keyedReference = null;
        if (apiKR != null) {
            keyedReference = new KeyedReference();
            keyedReference.setKeyName(apiKR.getKeyName());
            keyedReference.setKeyValue(apiKR.getKeyValue());
            if (apiKR.getTModelKey() != null) {
                org.ow2.dragon.persistence.bo.common.TModel model = (org.ow2.dragon.persistence.bo.common.TModel)this.universalUnifiedDAO.get(org.ow2.dragon.persistence.bo.common.TModel.class, (Serializable)((Object)apiKR.getTModelKey()));
                if (model != null) {
                    keyedReference.setTmodel(model);
                } else {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", apiKR.getTModelKey()));
                }
            }
        }
        return keyedReference;
    }

    private org.ow2.dragon.persistence.bo.common.KeyedReferenceGroup toDragonKeyedReferenceGroup(KeyedReferenceGroup apiKRG) throws InvalidKeyPassedException {
        org.ow2.dragon.persistence.bo.common.KeyedReferenceGroup keyedReferenceGroup = null;
        if (apiKRG != null) {
            List<org.uddi.api_v3.KeyedReference> keyedReferences;
            keyedReferenceGroup = new org.ow2.dragon.persistence.bo.common.KeyedReferenceGroup();
            if (apiKRG.getTModelKey() != null) {
                org.ow2.dragon.persistence.bo.common.TModel model = (org.ow2.dragon.persistence.bo.common.TModel)this.universalUnifiedDAO.get(org.ow2.dragon.persistence.bo.common.TModel.class, (Serializable)((Object)apiKRG.getTModelKey()));
                if (model != null) {
                    keyedReferenceGroup.setTmodel(model);
                } else {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", apiKRG.getTModelKey()));
                }
            }
            if ((keyedReferences = apiKRG.getKeyedReference()) != null) {
                for (org.uddi.api_v3.KeyedReference keyedReference : keyedReferences) {
                    keyedReferenceGroup.addKeyedReference(this.toDragonKeyedReference(keyedReference));
                }
            }
        }
        return keyedReferenceGroup;
    }

    public List<KeyedReference> toDragonIdentifierBag(IdentifierBag identifierBag) throws InvalidKeyPassedException {
        List<org.uddi.api_v3.KeyedReference> apiKRs;
        ArrayList<KeyedReference> dragonIdentifierBag = new ArrayList<KeyedReference>();
        if (identifierBag != null && (apiKRs = identifierBag.getKeyedReference()) != null) {
            for (org.uddi.api_v3.KeyedReference keyedReference : apiKRs) {
                dragonIdentifierBag.add(this.toDragonKeyedReference(keyedReference));
            }
        }
        return dragonIdentifierBag;
    }

    public org.ow2.dragon.persistence.bo.common.Name toDragonName(Name name) {
        org.ow2.dragon.persistence.bo.common.Name dragonName = null;
        if (name != null) {
            dragonName = new org.ow2.dragon.persistence.bo.common.Name();
            dragonName.setLangCode(name.getLang());
            dragonName.setName(name.getValue());
        }
        return dragonName;
    }

    public TModelInfos toUDDITModelInfos(List<org.ow2.dragon.persistence.bo.common.TModel> tmodels) {
        TModelInfos result = null;
        if (tmodels != null && !tmodels.isEmpty()) {
            result = new TModelInfos();
            for (org.ow2.dragon.persistence.bo.common.TModel tmodel : tmodels) {
                result.getTModelInfo().add(this.toUDDITModelInfo(tmodel));
            }
        }
        return result;
    }

    public TModelInfo toUDDITModelInfo(org.ow2.dragon.persistence.bo.common.TModel tmodel) {
        TModelInfo result = null;
        if (tmodel != null) {
            result = new TModelInfo();
            result.setName(this.toUDDIName(tmodel.getName()));
            result.setTModelKey(tmodel.getId());
            List descriptions = tmodel.getDescriptions();
            if (descriptions != null) {
                List<Description> apiDescriptions = result.getDescription();
                for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                    apiDescriptions.add(this.toUDDIDescription(description));
                }
            }
        }
        return result;
    }

    public ListDescription toUDDIListDescription(int actualCount, int includeCount, int head) {
        ListDescription description = new ListDescription();
        description.setActualCount(actualCount);
        description.setIncludeCount(includeCount);
        description.setListHead(head);
        return description;
    }

    public List<org.ow2.dragon.persistence.bo.common.Name> toDragonNames(List<Name> name) {
        ArrayList<org.ow2.dragon.persistence.bo.common.Name> result = new ArrayList<org.ow2.dragon.persistence.bo.common.Name>();
        if (name != null) {
            for (Name uddiName : name) {
                result.add(this.toDragonName(uddiName));
            }
        }
        return result;
    }

    public ServiceInfos toUDDIServiceInfos(List<TechnicalService> techServices) {
        ServiceInfos result = null;
        if (techServices != null && !techServices.isEmpty()) {
            result = new ServiceInfos();
            for (TechnicalService service : techServices) {
                result.getServiceInfo().add(this.toUDDIServiceInfo(service));
            }
        }
        return result;
    }

    public ServiceInfo toUDDIServiceInfo(TechnicalService service) {
        ServiceInfo result = null;
        if (service != null) {
            result = new ServiceInfo();
            result.setBusinessKey(this.retrieveBusinessKeyFormTechServ(service));
            result.setServiceKey(service.getId());
            List names = service.getNames();
            if (names != null) {
                List<Name> apiNames = result.getName();
                for (org.ow2.dragon.persistence.bo.common.Name name : names) {
                    apiNames.add(this.toUDDIName(name));
                }
            }
        }
        return result;
    }

    public RelatedBusinessInfos toUDDIRelatedBusinessInfos(List<OrganizationUnit> relatedOrgs) {
        RelatedBusinessInfos result = null;
        if (relatedOrgs != null && !relatedOrgs.isEmpty()) {
            result = new RelatedBusinessInfos();
            for (OrganizationUnit org : relatedOrgs) {
                result.getRelatedBusinessInfo().add(this.toUDDIRelatedBusinessInfo(org));
            }
        }
        return result;
    }

    public RelatedBusinessInfo toUDDIRelatedBusinessInfo(OrganizationUnit org) {
        RelatedBusinessInfo result = null;
        if (org != null) {
            List descriptions;
            result = new RelatedBusinessInfo();
            result.setBusinessKey(org.getId());
            List names = org.getNames();
            if (names != null) {
                List<Name> apiNames = result.getName();
                for (org.ow2.dragon.persistence.bo.common.Name name : names) {
                    apiNames.add(this.toUDDIName(name));
                }
            }
            if ((descriptions = org.getDescriptions()) != null) {
                List<Description> apiDescriptions = result.getDescription();
                for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                    apiDescriptions.add(this.toUDDIDescription(description));
                }
            }
        }
        return result;
    }

    public BusinessInfos toUDDIBusinessInfos(List<OrganizationUnit> orgs) {
        BusinessInfos result = null;
        if (orgs != null && !orgs.isEmpty()) {
            result = new BusinessInfos();
            for (OrganizationUnit org : orgs) {
                result.getBusinessInfo().add(this.toUDDIBusinessInfo(org));
            }
        }
        return result;
    }

    private BusinessInfo toUDDIBusinessInfo(OrganizationUnit org) {
        BusinessInfo result = null;
        if (org != null) {
            List descriptions;
            result = new BusinessInfo();
            result.setBusinessKey(org.getId());
            List names = org.getNames();
            if (names != null) {
                List<Name> apiNames = result.getName();
                for (org.ow2.dragon.persistence.bo.common.Name name : names) {
                    apiNames.add(this.toUDDIName(name));
                }
            }
            if ((descriptions = org.getDescriptions()) != null) {
                List<Description> apiDescriptions = result.getDescription();
                for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                    apiDescriptions.add(this.toUDDIDescription(description));
                }
            }
            result.setServiceInfos(this.retrieveLinkedBusinessServiceInfos(org));
        }
        return result;
    }

    private ServiceInfos retrieveLinkedBusinessServiceInfos(OrganizationUnit dragonBusiness) {
        ServiceInfos serviceInfos = new ServiceInfos();
        Set roles = dragonBusiness.getFromLinks();
        if (roles != null) {
            List<ServiceInfo> apiServices = serviceInfos.getServiceInfo();
            for (Link role : roles) {
                if (!(role.getTo() instanceof TechnicalService) || !role.getType().equalsIgnoreCase("Provider")) continue;
                TechnicalService technicalService = (TechnicalService)role.getTo();
                apiServices.add(this.toUDDIServiceInfo(technicalService));
            }
        }
        return serviceInfos;
    }
}

