/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v3.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.ow2.dragon.api.service.dataloader.DataLoaderException;
import org.ow2.dragon.util.JAXBUtil;
import org.uddi.api_v3.ObjectFactory;
import org.uddi.api_v3.SaveTModel;

public class UDDIObjectFactory {
    private static UDDIObjectFactory instance;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private static final List<Class> defaultObjectFactories;

    private UDDIObjectFactory() throws DataLoaderException {
        try {
            JAXBContext context = JAXBUtil.createJAXBContext(defaultObjectFactories);
            unmarshaller = context.createUnmarshaller();
            marshaller = context.createMarshaller();
        }
        catch (JAXBException e) {
            throw new DataLoaderException((Throwable)e);
        }
    }

    public SaveTModel convertStreamSource2SaveTModel(Source xmlStream) throws Exception {
        JAXBElement saveTModel = unmarshaller.unmarshal(xmlStream, SaveTModel.class);
        return (SaveTModel)saveTModel.getValue();
    }

    public static UDDIObjectFactory getInstance() throws DataLoaderException {
        if (instance == null) {
            instance = new UDDIObjectFactory();
        }
        return instance;
    }

    static {
        defaultObjectFactories = new ArrayList<Class>(Arrays.asList(ObjectFactory.class));
    }
}

