/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v3.validator;

import java.util.List;
import javax.xml.bind.JAXBElement;
import org.ow2.dragon.persistence.util.UDDIIdentifierGenerator;
import org.ow2.dragon.service.uddi.v3.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v3.error.FatalErrorException;
import org.ow2.dragon.service.uddi.v3.error.InvalidKeyPassedException;
import org.ow2.dragon.service.uddi.v3.error.ValueNotAllowedException;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.ObjectFactory;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3_porttype.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicationValidator {
    public void validateSaveTModel(SaveTModel body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List<TModel> entityList = body.getTModel();
        if (entityList == null || entityList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.savetmodel.NoInput"));
        }
        for (TModel entity : entityList) {
            this.validateTModel(entity);
        }
    }

    public void validateTModel(TModel tModel) throws DispositionReportFaultMessage {
        if (tModel == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.NullInput"));
        }
        String entityKey = tModel.getTModelKey();
        if (entityKey != null) {
            entityKey = entityKey.toLowerCase();
            tModel.setTModelKey(entityKey);
            if (!UDDIIdentifierGenerator.isUddiV3ValidId((String)entityKey)) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.MalformedKey", entityKey));
            }
        }
        if (tModel.getName() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodel.NoName"));
        }
        this.validateCategoryBag(tModel.getCategoryBag());
        this.validateIdentifierBag(tModel.getIdentifierBag());
        List<OverviewDoc> overviewDocList = tModel.getOverviewDoc();
        if (overviewDocList != null) {
            for (OverviewDoc overviewDoc : overviewDocList) {
                this.validateOverviewDoc(overviewDoc);
            }
        }
    }

    public void validateCategoryBag(CategoryBag categories) throws DispositionReportFaultMessage {
        if (categories == null) {
            return;
        }
        List<JAXBElement<?>> elems = categories.getContent();
        if (elems == null || elems.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.categorybag.NoInput"));
        }
        for (JAXBElement<?> elem : elems) {
            this.validateKeyedReferenceTypes(elem);
        }
    }

    public void validateKeyedReferenceTypes(JAXBElement<?> elem) throws DispositionReportFaultMessage {
        if (elem == null || elem.getValue() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NullInput"));
        }
        if (elem.getValue() instanceof KeyedReferenceGroup) {
            KeyedReferenceGroup krg = (KeyedReferenceGroup)elem.getValue();
            if (krg.getTModelKey() == null || krg.getTModelKey().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
            }
        } else if (elem.getValue() instanceof KeyedReference) {
            KeyedReference kr = (KeyedReference)elem.getValue();
            if (kr.getTModelKey() == null || kr.getTModelKey().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
            }
            if (kr.getKeyValue() == null || kr.getKeyValue().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoKeyValue"));
            }
        }
    }

    public void validateIdentifierBag(IdentifierBag identifiers) throws DispositionReportFaultMessage {
        if (identifiers == null) {
            return;
        }
        List<KeyedReference> keyedRefList = identifiers.getKeyedReference();
        if (keyedRefList == null || keyedRefList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.identifierbag.NoInput"));
        }
        for (KeyedReference keyedRef : keyedRefList) {
            this.validateKeyedReferenceTypes(new ObjectFactory().createKeyedReference(keyedRef));
        }
    }

    public void validateOverviewDoc(OverviewDoc overviewDoc) throws DispositionReportFaultMessage {
        if (overviewDoc == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.overviewdoc.NullInput"));
        }
        List<JAXBElement<?>> elems = overviewDoc.getContent();
        if (elems == null || elems.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.overviewdoc.NoDescOrUrl"));
        }
    }
}

