/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FindRelatedBusinessesQueryHelper.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.uddi.query;

import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.util.StringHelper;

import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
public class FindRelatedBusinessesQueryHelper extends CommonQueryHelper {

    public static IMutableSearch constructFindRelatedBusinessesSearch(
            FindQualifiers findQualifiers, String businessKey, Paging paging) {
        Class<OrganizationUnit> searchedType = OrganizationUnit.class;
        Search searchQuery = createDistinctSearch(searchedType);

        // Add business key filter
        if (!StringHelper.isNullOrEmpty(businessKey)) {
            searchQuery.addFilter(Filter.or(Filter.equal("parentOrganization.id", businessKey),
                    Filter.some("parties", Filter.equal("id", businessKey))));
        }

        // Add sort options
        addSortOptions(searchedType, searchQuery, findQualifiers);

        // Add paging options
        addPagingOptions(searchQuery, paging);

        return searchQuery;
    }

}
