/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FindTModelQueryHelper.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.uddi.query;

import java.util.List;

import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.service.uddi.FindQualifiers;

import com.trg.search.IMutableSearch;
import com.trg.search.Search;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
public class FindTModelQueryHelper extends CommonQueryHelper {

    public static IMutableSearch constructFindTModelSearch(FindQualifiers findQualifiers,
            CategoryBag dragonCategoryBag, List<KeyedReference> dragonIdentifierBag, Name name,
            Paging paging) {
        Class<TModel> searchedType = TModel.class;
        Search searchQuery = createDistinctSearch(searchedType);

        // Add name filter
        if (name != null) {
            searchQuery.addFilter(createNameFilter(searchedType, findQualifiers, name));
        }

        // Add category filters
        if (dragonCategoryBag != null) {
            searchQuery.addFilter(createCategoryBagFilter(findQualifiers, dragonCategoryBag));
        }

        // Add identifier filters
        if (dragonIdentifierBag != null && !dragonIdentifierBag.isEmpty()) {
            searchQuery.addFilter(createIdentifierBagFilter(findQualifiers, dragonIdentifierBag));
        }

        // Add sort options
        addSortOptions(searchedType, searchQuery, findQualifiers);

        // Add paging options
        addPagingOptions(searchQuery, paging);

        return searchQuery;
    }

}
