/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Paging.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.uddi.query;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
public class Paging {

    private int firstResult;

    private int maxResult;

    public Paging(Integer firstResult, Integer maxResult) {
        super();
        this.firstResult = 0;
        if (firstResult != null) {
            if (firstResult.intValue() > 0) {
                this.firstResult = firstResult-1;
            }
        }
        this.maxResult = 0;
        if (maxResult != null) {
            if (maxResult.intValue() > 0) {
                this.maxResult = maxResult;
            }
        }
    }

    public int getFirstResult() {
        return firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public int getMaxResult() {
        return maxResult;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

}
