/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.query;

import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.util.List;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.organization.DiscoveryUrl;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.service.uddi.query.CommonQueryHelper;
import org.ow2.dragon.service.uddi.query.Paging;
import org.ow2.dragon.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBusinessQueryHelper
extends CommonQueryHelper {
    public static IMutableSearch constructFindBusinessSearch(FindQualifiers findQualifiers, CategoryBag dragonCategoryBag, List<KeyedReference> dragonIdentifierBag, List<DiscoveryUrl> discoveryUrls, List<String> matchingServices, List<Name> names, List<String> relatedOrgsKeys, Paging paging) {
        Class<OrganizationUnit> searchedType = OrganizationUnit.class;
        Search searchQuery = FindBusinessQueryHelper.createDistinctSearch(searchedType);
        if (discoveryUrls != null && !discoveryUrls.isEmpty()) {
            searchQuery.addFilter(FindBusinessQueryHelper.createDiscoveryURLsFilter(discoveryUrls));
        }
        if (relatedOrgsKeys != null && !relatedOrgsKeys.isEmpty()) {
            searchQuery.addFilter(FindBusinessQueryHelper.createRelatedOrgsFilter(relatedOrgsKeys));
        }
        if (dragonCategoryBag != null) {
            searchQuery.addFilter(FindBusinessQueryHelper.createCategoryBagFilter(findQualifiers, dragonCategoryBag));
        }
        if (dragonIdentifierBag != null && !dragonIdentifierBag.isEmpty()) {
            searchQuery.addFilter(FindBusinessQueryHelper.createIdentifierBagFilter(findQualifiers, dragonIdentifierBag));
        }
        if (names != null && !names.isEmpty()) {
            searchQuery.addFilter(FindBusinessQueryHelper.createNamesFilter(searchedType, findQualifiers, names));
        }
        if (matchingServices != null && !matchingServices.isEmpty()) {
            searchQuery.addFilter(FindBusinessQueryHelper.createServiceKeysFilter(matchingServices));
        }
        FindBusinessQueryHelper.addSortOptions(searchedType, searchQuery, findQualifiers);
        FindBusinessQueryHelper.addPagingOptions(searchQuery, paging);
        return searchQuery;
    }

    private static Filter createDiscoveryURLsFilter(List<DiscoveryUrl> discoveryUrls) {
        Filter result = Filter.or((Filter[])new Filter[0]);
        for (DiscoveryUrl discoveryURL : discoveryUrls) {
            if (!StringHelper.isNullOrEmpty((String)discoveryURL.getUseType())) {
                result.add(Filter.some((String)"discoveryUrls", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"url", (Object)discoveryURL.getUrl()), Filter.equal((String)"useType", (Object)discoveryURL.getUseType())})));
                continue;
            }
            result.add(Filter.some((String)"discoveryUrls", (Filter)Filter.equal((String)"url", (Object)discoveryURL.getUrl())));
        }
        return result;
    }

    private static Filter createRelatedOrgsFilter(List<String> relatedOrgsKeys) {
        return Filter.in((String)"id", relatedOrgsKeys);
    }

    private static Filter createServiceKeysFilter(List<String> serviceKeys) {
        Filter or = Filter.or((Filter[])new Filter[0]);
        for (String string : serviceKeys) {
            or.add(Filter.some((String)"fromLinks", (Filter)Filter.equal((String)"to.id", (Object)string)));
        }
        return or;
    }
}

