/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.query;

import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.util.List;
import java.util.Set;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.service.uddi.query.CommonQueryHelper;
import org.ow2.dragon.service.uddi.query.Paging;
import org.ow2.dragon.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindServiceQueryHelper
extends CommonQueryHelper {
    public static final String PROVIDER = "Provider";

    public static IMutableSearch constructFindServiceSearch(FindQualifiers findQualifiers, CategoryBag dragonCategoryBag, Set<String> modelKeys, String businessKey, List<Name> names, Paging paging) {
        Class<TechnicalService> searchedType = TechnicalService.class;
        Search searchQuery = FindServiceQueryHelper.createDistinctSearch(searchedType);
        if (!StringHelper.isNullOrEmpty((String)businessKey)) {
            searchQuery.addFilter(FindServiceQueryHelper.createBusinessKeyFilter(businessKey));
        }
        if (dragonCategoryBag != null) {
            searchQuery.addFilter(FindServiceQueryHelper.createCategoryBagFilter(findQualifiers, dragonCategoryBag));
        }
        if (names != null && !names.isEmpty()) {
            searchQuery.addFilter(FindServiceQueryHelper.createNamesFilter(searchedType, findQualifiers, names));
        }
        if (modelKeys != null && !modelKeys.isEmpty()) {
            searchQuery.addFilter(Filter.some((String)"endpoints", (Filter)FindServiceQueryHelper.createTModelKeysFilter(findQualifiers, modelKeys, new String[]{"binding", "binding.serviceInterface"}, new String[]{"binding.serviceSpecifications", "binding.protocols", "binding.transports"})));
        }
        FindServiceQueryHelper.addSortOptions(searchedType, searchQuery, findQualifiers);
        FindServiceQueryHelper.addPagingOptions(searchQuery, paging);
        return searchQuery;
    }

    private static Filter createBusinessKeyFilter(String businessKey) {
        return Filter.some((String)"toLinks", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"from.id", (Object)businessKey), Filter.equal((String)"type", (Object)PROVIDER)}));
    }
}

