/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v2.impl;

import com.trg.search.IMutableSearch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.organization.DiscoveryUrl;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.dao.UniversalUnifiedDAO;
import org.ow2.dragon.persistence.util.UDDIIdentifierGenerator;
import org.ow2.dragon.service.uddi.query.FindBindingQueryHelper;
import org.ow2.dragon.service.uddi.query.FindBusinessQueryHelper;
import org.ow2.dragon.service.uddi.query.FindRelatedBusinessesQueryHelper;
import org.ow2.dragon.service.uddi.query.FindServiceQueryHelper;
import org.ow2.dragon.service.uddi.query.FindTModelQueryHelper;
import org.ow2.dragon.service.uddi.query.Paging;
import org.ow2.dragon.service.uddi.v2.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v2.error.InvalidKeyPassedException;
import org.ow2.dragon.service.uddi.v2.error.UnsupportedException;
import org.ow2.dragon.service.uddi.v2.impl.FindQualifiersV2;
import org.ow2.dragon.service.uddi.v2.impl.UDDITransferObjectAssembler;
import org.ow2.dragon.util.StringHelper;
import org.uddi.api_v2.BindingDetail;
import org.uddi.api_v2.BindingTemplate;
import org.uddi.api_v2.BusinessDetail;
import org.uddi.api_v2.BusinessDetailExt;
import org.uddi.api_v2.BusinessEntity;
import org.uddi.api_v2.BusinessList;
import org.uddi.api_v2.BusinessService;
import org.uddi.api_v2.FindBinding;
import org.uddi.api_v2.FindBusiness;
import org.uddi.api_v2.FindQualifiers;
import org.uddi.api_v2.FindRelatedBusinesses;
import org.uddi.api_v2.FindService;
import org.uddi.api_v2.FindTModel;
import org.uddi.api_v2.GetBindingDetail;
import org.uddi.api_v2.GetBusinessDetail;
import org.uddi.api_v2.GetBusinessDetailExt;
import org.uddi.api_v2.GetServiceDetail;
import org.uddi.api_v2.GetTModelDetail;
import org.uddi.api_v2.RelatedBusinessesList;
import org.uddi.api_v2.ServiceDetail;
import org.uddi.api_v2.ServiceInfo;
import org.uddi.api_v2.ServiceInfos;
import org.uddi.api_v2.ServiceList;
import org.uddi.api_v2.TModel;
import org.uddi.api_v2.TModelBag;
import org.uddi.api_v2.TModelDetail;
import org.uddi.api_v2.TModelList;
import org.uddi.api_v2.Truncated;
import org.uddi.inquiry_v2.DispositionReport;
import org.uddi.inquiry_v2.Inquire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InquireImpl
implements Inquire {
    private WebServiceContextImpl webServiceContext;
    private UniversalUnifiedDAO universalUnifiedDAO;
    private UDDITransferObjectAssembler transferObjectAssembler;

    public InquireImpl(UniversalUnifiedDAO universalUnifiedDAO, WebServiceContextImpl webServiceContext) {
        this.universalUnifiedDAO = universalUnifiedDAO;
        this.webServiceContext = webServiceContext;
        this.transferObjectAssembler = new UDDITransferObjectAssembler(universalUnifiedDAO);
    }

    @Override
    public BindingDetail findBinding(FindBinding body) throws DispositionReport {
        BindingDetail result = new BindingDetail();
        List<BindingTemplate> bindingTemplates = result.getBindingTemplate();
        FindQualifiersV2 findQualifiers = new FindQualifiersV2(body.getFindQualifiers());
        Paging paging = new Paging(1, body.getMaxRows());
        String v3ServiceKey = UDDIIdentifierGenerator.toUddiV3Id((String)body.getServiceKey());
        if (!StringHelper.isNullOrEmpty((String)v3ServiceKey) && this.universalUnifiedDAO.get(TechnicalService.class, (Serializable)((Object)v3ServiceKey)) == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", body.getServiceKey()));
        }
        Set<String> tModelKeys = this.retrieveTModelKeys(body.getTModelBag());
        IMutableSearch searchQuery = FindBindingQueryHelper.constructFindBindingSearch(findQualifiers, null, tModelKeys, v3ServiceKey, paging);
        List bindings = this.universalUnifiedDAO.search(Endpoint.class, searchQuery);
        if (bindings != null && !bindings.isEmpty()) {
            if (this.universalUnifiedDAO.count(Endpoint.class, searchQuery) > bindings.size()) {
                result.setTruncated(Truncated.TRUE);
            }
            for (Endpoint binding : bindings) {
                bindingTemplates.add(this.transferObjectAssembler.toUDDIBindingTemplate(binding));
            }
        }
        return result;
    }

    private Set<String> retrieveTModelKeys(TModelBag modelBag) throws DispositionReport {
        HashSet<String> keys = new HashSet<String>();
        if (modelBag != null && modelBag.getTModelKey() != null) {
            for (String modelKey : modelBag.getTModelKey()) {
                String uddiV3Key = UDDIIdentifierGenerator.toUddiV3Id((String)modelKey);
                if (this.universalUnifiedDAO.get(org.ow2.dragon.persistence.bo.common.TModel.class, (Serializable)((Object)uddiV3Key)) != null) {
                    keys.add(uddiV3Key);
                    continue;
                }
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", modelKey));
            }
        }
        return keys;
    }

    private List<String> retrieveMatchingServices(TModelBag modelBag, FindQualifiers findQualifiers) throws DispositionReport {
        List<ServiceInfo> services;
        ServiceInfos serviceInfos;
        ArrayList<String> servicesKeys = new ArrayList<String>();
        FindService includedRequest = new FindService();
        includedRequest.setTModelBag(modelBag);
        includedRequest.setFindQualifiers(findQualifiers);
        ServiceList serviceList = this.findService(includedRequest);
        if (serviceList != null && (serviceInfos = serviceList.getServiceInfos()) != null && (services = serviceInfos.getServiceInfo()) != null) {
            for (ServiceInfo serviceInfo : services) {
                servicesKeys.add(UDDIIdentifierGenerator.toUddiV3Id((String)serviceInfo.getServiceKey()));
            }
        }
        return servicesKeys;
    }

    @Override
    public BusinessList findBusiness(FindBusiness body) throws DispositionReport {
        IMutableSearch searchQuery;
        List orgs;
        BusinessList result = new BusinessList();
        FindQualifiersV2 findQualifiers = new FindQualifiersV2(body.getFindQualifiers());
        Paging paging = new Paging(1, body.getMaxRows());
        CategoryBag dragonCategoryBag = this.transferObjectAssembler.toDragonCategoryBag(body.getCategoryBag());
        List<Name> names = this.transferObjectAssembler.toDragonNames(body.getName());
        List<KeyedReference> dragonIdentifierBag = this.transferObjectAssembler.toDragonIdentifierBag(body.getIdentifierBag());
        List<DiscoveryUrl> discoveryUrls = this.transferObjectAssembler.toDragonDiscoveryUrls(body.getDiscoveryURLs());
        List<String> serviceKeys = null;
        if (body.getTModelBag() != null) {
            serviceKeys = this.retrieveMatchingServices(body.getTModelBag(), body.getFindQualifiers());
        }
        if ((orgs = this.universalUnifiedDAO.search(OrganizationUnit.class, searchQuery = FindBusinessQueryHelper.constructFindBusinessSearch(findQualifiers, dragonCategoryBag, dragonIdentifierBag, discoveryUrls, serviceKeys, names, null, paging))) != null && !orgs.isEmpty()) {
            if (this.universalUnifiedDAO.count(OrganizationUnit.class, searchQuery) > orgs.size()) {
                result.setTruncated(Truncated.TRUE);
            }
            result.setBusinessInfos(this.transferObjectAssembler.toUDDIBusinessInfos(orgs));
        }
        return result;
    }

    @Override
    public RelatedBusinessesList findRelatedBusinesses(FindRelatedBusinesses body) throws DispositionReport {
        OrganizationUnit orgSource;
        RelatedBusinessesList result = new RelatedBusinessesList();
        FindQualifiersV2 findQualifiers = new FindQualifiersV2(body.getFindQualifiers());
        Paging paging = new Paging(1, body.getMaxRows());
        String v3BusinessKey = UDDIIdentifierGenerator.toUddiV3Id((String)body.getBusinessKey());
        if (v3BusinessKey != null && (orgSource = (OrganizationUnit)this.universalUnifiedDAO.get(OrganizationUnit.class, (Serializable)((Object)v3BusinessKey))) == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", body.getBusinessKey()));
        }
        IMutableSearch searchQuery = FindRelatedBusinessesQueryHelper.constructFindRelatedBusinessesSearch(findQualifiers, v3BusinessKey, paging);
        List relatedOrgs = this.universalUnifiedDAO.search(OrganizationUnit.class, searchQuery);
        if (relatedOrgs != null && !relatedOrgs.isEmpty()) {
            if (this.universalUnifiedDAO.count(OrganizationUnit.class, searchQuery) > relatedOrgs.size()) {
                result.setTruncated(Truncated.TRUE);
            }
            result.setRelatedBusinessInfos(this.transferObjectAssembler.toUDDIRelatedBusinessInfos(relatedOrgs));
        }
        result.setBusinessKey(body.getBusinessKey());
        return result;
    }

    @Override
    public ServiceList findService(FindService body) throws DispositionReport {
        ServiceList result = new ServiceList();
        FindQualifiersV2 findQualifiers = new FindQualifiersV2(body.getFindQualifiers());
        Paging paging = new Paging(1, body.getMaxRows());
        CategoryBag dragonCategoryBag = this.transferObjectAssembler.toDragonCategoryBag(body.getCategoryBag());
        String v3BusinessKey = UDDIIdentifierGenerator.toUddiV3Id((String)body.getBusinessKey());
        if (!StringHelper.isNullOrEmpty((String)v3BusinessKey) && this.universalUnifiedDAO.get(OrganizationUnit.class, (Serializable)((Object)v3BusinessKey)) == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", body.getBusinessKey()));
        }
        List<Name> names = this.transferObjectAssembler.toDragonNames(body.getName());
        Set<String> tModelKeys = this.retrieveTModelKeys(body.getTModelBag());
        IMutableSearch searchQuery = FindServiceQueryHelper.constructFindServiceSearch(findQualifiers, dragonCategoryBag, tModelKeys, v3BusinessKey, names, paging);
        List techServices = this.universalUnifiedDAO.search(TechnicalService.class, searchQuery);
        if (techServices != null && !techServices.isEmpty()) {
            if (this.universalUnifiedDAO.count(TechnicalService.class, searchQuery) > techServices.size()) {
                result.setTruncated(Truncated.TRUE);
            }
            result.setServiceInfos(this.transferObjectAssembler.toUDDIServiceInfos(techServices));
        }
        return result;
    }

    @Override
    public TModelList findTModel(FindTModel body) throws DispositionReport {
        Name name;
        List<KeyedReference> dragonIdentifierBag;
        TModelList result = new TModelList();
        FindQualifiersV2 findQualifiers = new FindQualifiersV2(body.getFindQualifiers());
        Paging paging = new Paging(1, body.getMaxRows());
        CategoryBag dragonCategoryBag = this.transferObjectAssembler.toDragonCategoryBag(body.getCategoryBag());
        IMutableSearch searchQuery = FindTModelQueryHelper.constructFindTModelSearch(findQualifiers, dragonCategoryBag, dragonIdentifierBag = this.transferObjectAssembler.toDragonIdentifierBag(body.getIdentifierBag()), name = this.transferObjectAssembler.toDragonName(body.getName()), paging);
        List tmodels = this.universalUnifiedDAO.search(org.ow2.dragon.persistence.bo.common.TModel.class, searchQuery);
        if (tmodels != null && !tmodels.isEmpty()) {
            if (this.universalUnifiedDAO.count(org.ow2.dragon.persistence.bo.common.TModel.class, searchQuery) > tmodels.size()) {
                result.setTruncated(Truncated.TRUE);
            }
            result.setTModelInfos(this.transferObjectAssembler.toUDDITModelInfos(tmodels));
        }
        return result;
    }

    @Override
    public BindingDetail getBindingDetail(GetBindingDetail body) throws DispositionReport {
        BindingDetail result = new BindingDetail();
        List<String> keys = body.getBindingKey();
        for (String key : keys) {
            Endpoint dragonEp = (Endpoint)this.universalUnifiedDAO.get(Endpoint.class, (Serializable)((Object)UDDIIdentifierGenerator.toUddiV3Id((String)key)));
            if (dragonEp == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BindingTemplatelNotFound", key));
            }
            this.setRequestOnTOA();
            BindingTemplate apiBindingTemplate = this.transferObjectAssembler.toUDDIBindingTemplate(dragonEp);
            result.getBindingTemplate().add(apiBindingTemplate);
        }
        return result;
    }

    @Override
    public BusinessDetail getBusinessDetail(GetBusinessDetail body) throws DispositionReport {
        BusinessDetail result = new BusinessDetail();
        List<String> keys = body.getBusinessKey();
        for (String key : keys) {
            OrganizationUnit dragonBusiness = (OrganizationUnit)this.universalUnifiedDAO.get(OrganizationUnit.class, (Serializable)((Object)UDDIIdentifierGenerator.toUddiV3Id((String)key)));
            if (dragonBusiness == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", key));
            }
            this.setRequestOnTOA();
            BusinessEntity apiBusiness = this.transferObjectAssembler.toUDDIBusiness(dragonBusiness);
            result.getBusinessEntity().add(apiBusiness);
        }
        return result;
    }

    @Override
    public BusinessDetailExt getBusinessDetailExt(GetBusinessDetailExt body) throws DispositionReport {
        throw new UnsupportedException(new ErrorMessage("errors.Unsupported", "getBusinessDetailExt"));
    }

    @Override
    public ServiceDetail getServiceDetail(GetServiceDetail body) throws DispositionReport {
        ServiceDetail result = new ServiceDetail();
        List<String> keys = body.getServiceKey();
        for (String key : keys) {
            TechnicalService dragonService = (TechnicalService)this.universalUnifiedDAO.get(TechnicalService.class, (Serializable)((Object)UDDIIdentifierGenerator.toUddiV3Id((String)key)));
            if (dragonService == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", key));
            }
            this.setRequestOnTOA();
            BusinessService apiService = this.transferObjectAssembler.toUDDIService(dragonService);
            result.getBusinessService().add(apiService);
        }
        return result;
    }

    @Override
    public TModelDetail getTModelDetail(GetTModelDetail body) throws DispositionReport {
        TModelDetail result = new TModelDetail();
        List<String> keys = body.getTModelKey();
        for (String key : keys) {
            org.ow2.dragon.persistence.bo.common.TModel dragonTModel = (org.ow2.dragon.persistence.bo.common.TModel)this.universalUnifiedDAO.get(org.ow2.dragon.persistence.bo.common.TModel.class, (Serializable)((Object)UDDIIdentifierGenerator.toUddiV3Id((String)key)));
            if (dragonTModel == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", key));
            }
            this.setRequestOnTOA();
            TModel apiTModel = this.transferObjectAssembler.toUDDITModel(dragonTModel);
            result.getTModel().add(apiTModel);
        }
        return result;
    }

    private void setRequestOnTOA() {
        HttpServletRequest request = (HttpServletRequest)this.webServiceContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        this.transferObjectAssembler.setRequest(request);
    }
}

