/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v3.impl;

import java.util.List;
import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.service.uddi.v3.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v3.error.UnsupportedException;

public class FindQualifiersV3
extends FindQualifiers {
    public static final String AND_ALL_KEYS = "andAllKeys";
    public static final String AND_ALL_KEYS_TMODEL = "uddi-org:andAllKeys";
    public static final String APPROXIMATE_MATCH = "approximateMatch";
    public static final String APPROXIMATE_MATCH_TMODEL = "uddi-org:approximateMatch:SQL99";
    public static final String BINARY_SORT = "binarySort";
    public static final String BINARY_SORT_TMODEL = "uddi-org:binarySort)";
    public static final String BINDING_SUBSET = "bindingSubset";
    public static final String BINDING_SUBSET_TMODEL = "uddi-org:bindingSubset";
    public static final String CASE_INSENSITIVE_SORT = "caseInsensitiveSort";
    public static final String CASE_INSENSITIVE_SORT_TMODEL = "uddi-org:caseInsensitiveSort";
    public static final String CASE_INSENSITIVE_MATCH = "caseInsensitiveMatch";
    public static final String CASE_INSENSITIVE_MATCH_TMODEL = "uddi-org:caseInsensitiveMatch";
    public static final String CASE_SENSITIVE_SORT = "caseSensitiveSort";
    public static final String CASE_SENSITIVE_SORT_TMODEL = "uddi-org:caseSensitiveSort";
    public static final String CASE_SENSITIVE_MATCH = "caseSensitiveMatch";
    public static final String CASE_SENSITIVE_MATCH_TMODEL = "uddi-org:caseSensitiveMatch";
    public static final String COMBINE_CATEGORY_BAGS = "combineCategoryBags";
    public static final String COMBINE_CATEGORY_BAGS_TMODEL = "uddi-org:combineCategoryBags)";
    public static final String DIACRITIC_INSENSITIVE_MATCH = "diacriticInsensitiveMatch";
    public static final String DIACRITIC_INSENSITIVE_MATCH_TMODEL = "uddi-org:diacriticInsensitiveMatch";
    public static final String DIACRITIC_SENSITIVE_MATCH = "diacriticSensitiveMatch";
    public static final String DIACRITIC_SENSITIVE_MATCH_TMODEL = "uddi-org:diacriticSensitiveMatch";
    public static final String EXACT_MATCH = "exactMatch";
    public static final String EXACT_MATCH_TMODEL = "uddi-org:exactMatch";
    public static final String SIGNATURE_PRESENT = "signaturePresent";
    public static final String SIGNATURE_PRESENT_TMODEL = "uddi-org:signaturePresent";
    public static final String OR_ALL_KEYS = "orAllKeys";
    public static final String OR_ALL_KEYS_TMODEL = "uddi-org:orAllKeys";
    public static final String OR_LIKE_KEYS = "orLikeKeys";
    public static final String OR_LIKE_KEYS_TMODEL = "uddi-org:orLikeKeys";
    public static final String SERVICE_SUBSET = "serviceSubset";
    public static final String SERVICE_SUBSET_TMODEL = "uddi-org:serviceSubset";
    public static final String SORT_BY_NAME_ASC = "sortByNameAsc";
    public static final String SORT_BY_NAME_ASC_TMODEL = "uddi-org:sortByNameAsc";
    public static final String SORT_BY_NAME_DESC = "sortByNameDesc";
    public static final String SORT_BY_NAME_DESC_TMODEL = "uddi-org:sortByNameDesc";
    public static final String SORT_BY_DATE_ASC = "sortByDateAsc";
    public static final String SORT_BY_DATE_ASC_TMODEL = "uddi-org:sortByDateAsc";
    public static final String SORT_BY_DATE_DESC = "sortByDateDesc";
    public static final String SORT_BY_DATE_DESC_TMODEL = "uddi-org:sortByDateDesc";
    public static final String SUPPRESS_PROJECTED_SERVICES = "suppressProjectedServices";
    public static final String SUPPRESS_PROJECTED_SERVICES_TMODEL = "uddi-org:suppressProjectedServices";
    public static final String UTS_10 = "UTS-10";
    public static final String UTS_10_TMODEL = "uddi-org:UTS-10";
    private boolean binarySort = false;
    private boolean caseInsensitiveSort = false;
    private boolean caseSensitiveSort = false;
    private boolean signaturePresent = false;
    private boolean suppressProjectedServices = false;
    private boolean uts10 = false;

    public FindQualifiersV3(org.uddi.api_v3.FindQualifiers findQualifiers) throws UnsupportedException {
        this.setDefaults();
        this.mapRequestedFindQualifiers(findQualifiers);
    }

    private void mapRequestedFindQualifiers(org.uddi.api_v3.FindQualifiers findQualifiers) throws UnsupportedException {
        List<String> fqList;
        if (findQualifiers != null && (fqList = findQualifiers.getFindQualifier()) != null) {
            for (String fq : fqList) {
                if (fq.equalsIgnoreCase(AND_ALL_KEYS) || fq.equalsIgnoreCase(AND_ALL_KEYS_TMODEL)) {
                    this.setAndAllKeys(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(APPROXIMATE_MATCH) || fq.equalsIgnoreCase(APPROXIMATE_MATCH_TMODEL)) {
                    this.setApproximateMatch(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(BINARY_SORT) || fq.equalsIgnoreCase(BINARY_SORT_TMODEL)) {
                    this.setBinarySort(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(BINDING_SUBSET) || fq.equalsIgnoreCase(BINDING_SUBSET_TMODEL)) {
                    this.setBindingSubset(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(CASE_INSENSITIVE_SORT) || fq.equalsIgnoreCase(CASE_INSENSITIVE_SORT_TMODEL)) {
                    this.setCaseInsensitiveSort(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(CASE_INSENSITIVE_MATCH) || fq.equalsIgnoreCase(CASE_INSENSITIVE_MATCH_TMODEL)) {
                    this.setCaseInsensitiveMatch(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(CASE_SENSITIVE_SORT) || fq.equalsIgnoreCase(CASE_SENSITIVE_SORT_TMODEL)) {
                    this.setCaseSensitiveSort(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(CASE_SENSITIVE_MATCH) || fq.equalsIgnoreCase(CASE_SENSITIVE_MATCH_TMODEL)) {
                    this.setCaseSensitiveMatch(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(COMBINE_CATEGORY_BAGS) || fq.equalsIgnoreCase(COMBINE_CATEGORY_BAGS_TMODEL)) {
                    this.setCombineCategoryBags(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(DIACRITIC_INSENSITIVE_MATCH) || fq.equalsIgnoreCase(DIACRITIC_INSENSITIVE_MATCH_TMODEL)) {
                    this.setDiacriticInsensitiveMatch(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(DIACRITIC_SENSITIVE_MATCH) || fq.equalsIgnoreCase(DIACRITIC_SENSITIVE_MATCH_TMODEL)) {
                    this.setDiacriticSensitiveMatch(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(EXACT_MATCH) || fq.equalsIgnoreCase(EXACT_MATCH_TMODEL)) {
                    this.setExactMatch(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SIGNATURE_PRESENT) || fq.equalsIgnoreCase(SIGNATURE_PRESENT_TMODEL)) {
                    this.setSignaturePresent(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(OR_ALL_KEYS) || fq.equalsIgnoreCase(OR_ALL_KEYS_TMODEL)) {
                    this.setOrAllKeys(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(OR_LIKE_KEYS) || fq.equalsIgnoreCase(OR_LIKE_KEYS_TMODEL)) {
                    this.setOrLikeKeys(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SERVICE_SUBSET) || fq.equalsIgnoreCase(SERVICE_SUBSET_TMODEL)) {
                    this.setServiceSubset(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SORT_BY_NAME_ASC) || fq.equalsIgnoreCase(SORT_BY_NAME_ASC_TMODEL)) {
                    this.setSortByNameAsc(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SORT_BY_NAME_DESC) || fq.equalsIgnoreCase(SORT_BY_NAME_DESC_TMODEL)) {
                    this.setSortByNameDesc(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SORT_BY_DATE_ASC) || fq.equalsIgnoreCase(SORT_BY_DATE_ASC_TMODEL)) {
                    this.setSortByDateAsc(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SORT_BY_DATE_DESC) || fq.equalsIgnoreCase(SORT_BY_DATE_DESC_TMODEL)) {
                    this.setSortByDateDesc(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(SUPPRESS_PROJECTED_SERVICES) || fq.equalsIgnoreCase(SUPPRESS_PROJECTED_SERVICES_TMODEL)) {
                    this.setSuppressProjectedServices(true);
                    continue;
                }
                if (fq.equalsIgnoreCase(UTS_10) || fq.equalsIgnoreCase(UTS_10_TMODEL)) {
                    this.setUts10(true);
                    continue;
                }
                throw new UnsupportedException(new ErrorMessage("errors.findqualifiers.Unsupported", fq));
            }
        }
    }

    private void setDefaults() {
        this.setExactMatch(true);
        this.setCaseSensitiveMatch(true);
        this.setCaseSensitiveSort(true);
        this.setDiacriticSensitiveMatch(true);
    }

    public boolean isBinarySort() {
        return this.binarySort;
    }

    public void setBinarySort(boolean binarySort) {
        this.binarySort = binarySort;
        this.uts10 = !binarySort;
    }

    public boolean isCaseInsensitiveSort() {
        return this.caseInsensitiveSort;
    }

    public void setCaseInsensitiveSort(boolean caseInsensitiveSort) {
        this.caseInsensitiveSort = caseInsensitiveSort;
        this.caseSensitiveSort = !caseInsensitiveSort;
    }

    public boolean isCaseSensitiveSort() {
        return this.caseSensitiveSort;
    }

    public void setCaseSensitiveSort(boolean caseSensitiveSort) {
        this.caseSensitiveSort = caseSensitiveSort;
        this.caseInsensitiveSort = !caseSensitiveSort;
    }

    public boolean isSignaturePresent() {
        return this.signaturePresent;
    }

    public void setSignaturePresent(boolean signaturePresent) {
        this.signaturePresent = signaturePresent;
    }

    public boolean isSuppressProjectedServices() {
        return this.suppressProjectedServices;
    }

    public void setSuppressProjectedServices(boolean suppressProjectedServices) {
        this.suppressProjectedServices = suppressProjectedServices;
    }

    public boolean isUts10() {
        return this.uts10;
    }

    public void setUts10(boolean uts10) {
        this.uts10 = uts10;
        this.binarySort = !uts10;
    }
}

