/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FindServiceQueryHelper.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.uddi.query;

import java.util.List;
import java.util.Set;

import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.util.StringHelper;

import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
public class FindServiceQueryHelper extends CommonQueryHelper {

    public static final String PROVIDER = "Provider";

    public static IMutableSearch constructFindServiceSearch(FindQualifiers findQualifiers,
            CategoryBag dragonCategoryBag, Set<String> modelKeys, String businessKey,
            List<Name> names, Paging paging) {
        Class<TechnicalService> searchedType = TechnicalService.class;
        Search searchQuery = createDistinctSearch(searchedType);

        // Add business key filter
        if (!StringHelper.isNullOrEmpty(businessKey)) {
            searchQuery.addFilter(createBusinessKeyFilter(businessKey));
        }

        // Add category filters
        if (dragonCategoryBag != null) {
            searchQuery.addFilter(createCategoryBagFilter(findQualifiers, dragonCategoryBag));
        }

        // Add names filter
        if (names != null && !names.isEmpty()) {
            searchQuery.addFilter(createNamesFilter(searchedType, findQualifiers, names));
        }

        // Add tmodel keys filters
        if (modelKeys != null && !modelKeys.isEmpty()) {
            searchQuery.addFilter(Filter.some("endpoints", createTModelKeysFilter(findQualifiers,
                    modelKeys, new String[] { "binding", "binding.serviceInterface" },
                    new String[] { "binding.serviceSpecifications", "binding.protocols",
                            "binding.transports" })));
        }

        // Add sort options
        addSortOptions(searchedType, searchQuery, findQualifiers);

        // Add paging options
        addPagingOptions(searchQuery, paging);

        return searchQuery;
    }

    private static Filter createBusinessKeyFilter(String businessKey) {
        return Filter.some("toLinks", Filter.and(Filter.equal("from.id", businessKey), Filter
                .equal("type", PROVIDER)));
    }

}
