/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.query;

import com.trg.search.Filter;
import com.trg.search.Search;
import com.trg.search.Sort;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.KeyedReferenceGroup;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.service.uddi.query.Paging;
import org.ow2.dragon.service.uddi.v3.impl.FindQualifiersV3;
import org.ow2.dragon.util.StringHelper;

public class CommonQueryHelper {
    protected static Search createDistinctSearch(Class<?> searchedType) {
        Search searchQuery = new Search();
        searchQuery.setSearchClass(searchedType);
        searchQuery.setDistinct(true);
        return searchQuery;
    }

    protected static void addPagingOptions(Search searchQuery, Paging paging) {
        searchQuery.setFirstResult(paging.getFirstResult());
        searchQuery.setMaxResults(paging.getMaxResult());
    }

    protected static void addSortOptions(Class<?> searchedType, Search searchQuery, FindQualifiers findQualifiers) {
        Sort sortName = null;
        Sort sortDate = new Sort("lastUpdated");
        if (searchedType.equals(TModel.class)) {
            sortName = new Sort("name.name");
            searchQuery.addFetch("name");
        } else if (searchedType.equals(OrganizationUnit.class) || searchedType.equals(TechnicalService.class)) {
            sortName = new Sort("names.name");
            searchQuery.addFetch("names");
        }
        if (sortName != null) {
            if (findQualifiers instanceof FindQualifiersV3) {
                FindQualifiersV3 findQualifiersV3 = (FindQualifiersV3)findQualifiers;
                if (findQualifiersV3.isCaseInsensitiveSort()) {
                    sortName.setIgnoreCase(true);
                } else if (findQualifiersV3.isCaseSensitiveSort()) {
                    sortName.setIgnoreCase(false);
                }
            }
            if (findQualifiers.isSortByNameAsc()) {
                if (findQualifiers.isSortByDateAsc()) {
                    sortDate.setDesc(false);
                    sortName.setDesc(false);
                    searchQuery.addSort(sortName);
                    searchQuery.addSort(sortDate);
                } else if (findQualifiers.isSortByDateDesc()) {
                    sortDate.setDesc(true);
                    sortName.setDesc(false);
                    searchQuery.addSort(sortName);
                    searchQuery.addSort(sortDate);
                } else {
                    sortDate.setDesc(false);
                    sortName.setDesc(false);
                    searchQuery.addSort(sortName);
                    searchQuery.addSort(sortDate);
                }
            } else if (findQualifiers.isSortByNameDesc()) {
                if (findQualifiers.isSortByDateAsc()) {
                    sortDate.setDesc(false);
                    sortName.setDesc(true);
                    searchQuery.addSort(sortName);
                    searchQuery.addSort(sortDate);
                } else if (findQualifiers.isSortByDateDesc()) {
                    sortDate.setDesc(true);
                    sortName.setDesc(true);
                    searchQuery.addSort(sortName);
                    searchQuery.addSort(sortDate);
                } else {
                    sortDate.setDesc(false);
                    sortName.setDesc(true);
                    searchQuery.addSort(sortName);
                    searchQuery.addSort(sortDate);
                }
            } else if (findQualifiers.isSortByDateAsc()) {
                sortDate.setDesc(false);
                sortName.setDesc(false);
                searchQuery.addSort(sortDate);
                searchQuery.addSort(sortName);
            } else if (findQualifiers.isSortByDateDesc()) {
                sortDate.setDesc(true);
                sortName.setDesc(false);
                searchQuery.addSort(sortDate);
                searchQuery.addSort(sortName);
            } else {
                sortDate.setDesc(false);
                sortName.setDesc(false);
                searchQuery.addSort(sortName);
                searchQuery.addSort(sortDate);
            }
        } else {
            if (findQualifiers.isSortByDateAsc()) {
                sortDate.setDesc(false);
            } else if (findQualifiers.isSortByDateDesc()) {
                sortDate.setDesc(true);
            } else {
                sortDate.setDesc(false);
            }
            searchQuery.addSort(sortDate);
        }
    }

    protected static Filter createNamesFilter(Class<?> searchedType, FindQualifiers findQualifiers, List<Name> names) {
        Filter result = null;
        if (names != null && !names.isEmpty()) {
            result = Filter.or((Filter[])new Filter[0]);
            for (Name name : names) {
                result.add(Filter.some((String)"names", (Filter)CommonQueryHelper.createNameFilter(searchedType, findQualifiers, name)));
            }
        }
        return result;
    }

    protected static Filter createNameFilter(Class<?> searchedType, FindQualifiers findQualifiers, Name name) {
        Filter result = null;
        String langCodePropertyKey = null;
        String namePropertyKey = null;
        if (searchedType.equals(TModel.class)) {
            langCodePropertyKey = "name.langCode";
            namePropertyKey = "name.name";
        } else if (searchedType.equals(TechnicalService.class) || searchedType.equals(OrganizationUnit.class)) {
            langCodePropertyKey = "langCode";
            namePropertyKey = "name";
        }
        if (name != null) {
            result = findQualifiers.isExactMatch() ? (findQualifiers.isCaseSensitiveMatch() ? (!StringHelper.isNullOrEmpty((String)name.getLangCode()) ? Filter.and((Filter[])new Filter[]{Filter.iequal((String)langCodePropertyKey, (Object)name.getLangCode()), Filter.equal((String)namePropertyKey, (Object)name.getName())}) : Filter.equal((String)namePropertyKey, (Object)name.getName())) : (!StringHelper.isNullOrEmpty((String)name.getLangCode()) ? Filter.and((Filter[])new Filter[]{Filter.iequal((String)langCodePropertyKey, (Object)name.getLangCode()), Filter.iequal((String)namePropertyKey, (Object)name.getName())}) : Filter.iequal((String)namePropertyKey, (Object)name.getName()))) : (findQualifiers.isCaseSensitiveMatch() ? (!StringHelper.isNullOrEmpty((String)name.getLangCode()) ? Filter.and((Filter[])new Filter[]{Filter.iequal((String)langCodePropertyKey, (Object)name.getLangCode()), Filter.like((String)namePropertyKey, (String)name.getName())}) : Filter.like((String)namePropertyKey, (String)name.getName())) : (!StringHelper.isNullOrEmpty((String)name.getLangCode()) ? Filter.and((Filter[])new Filter[]{Filter.iequal((String)langCodePropertyKey, (Object)name.getLangCode()), Filter.ilike((String)namePropertyKey, (String)name.getName())}) : Filter.ilike((String)namePropertyKey, (String)name.getName())));
        }
        return result;
    }

    protected static Filter createIdentifierBagFilter(FindQualifiers findQualifiers, List<KeyedReference> dragonIdentifierBag) {
        Filter identifierBagFilter = null;
        identifierBagFilter = findQualifiers.isAndAllKeys() || findQualifiers.isOrLikeKeys() ? Filter.and((Filter[])new Filter[0]) : Filter.or((Filter[])new Filter[0]);
        CommonQueryHelper.createKeyedReferencesFilter(findQualifiers, dragonIdentifierBag, identifierBagFilter, "identifierBag");
        return identifierBagFilter;
    }

    private static void createKeyedReferencesFilter(FindQualifiers findQualifiers, List<KeyedReference> krs, Filter parentFilter, String krsPropertyKey) {
        block5: {
            if (krs == null) break block5;
            if (findQualifiers.isOrLikeKeys()) {
                Collections.sort(krs, new Comparator<KeyedReference>(){

                    @Override
                    public int compare(KeyedReference o1, KeyedReference o2) {
                        return o1.getTmodel().getId().compareTo(o2.getTmodel().getId());
                    }
                });
                String currentKRTModelKey = null;
                Filter sameNamespaceFilter = null;
                for (KeyedReference keyedReference : krs) {
                    if (!keyedReference.getTmodel().getId().equals(currentKRTModelKey)) {
                        sameNamespaceFilter = Filter.or((Filter[])new Filter[0]);
                        parentFilter.add(sameNamespaceFilter);
                        currentKRTModelKey = keyedReference.getTmodel().getId();
                    }
                    sameNamespaceFilter.add(Filter.some((String)krsPropertyKey, (Filter)CommonQueryHelper.createKeyedReferenceFilter(findQualifiers, keyedReference)));
                }
            } else {
                for (KeyedReference keyedReference : krs) {
                    parentFilter.add(Filter.some((String)krsPropertyKey, (Filter)CommonQueryHelper.createKeyedReferenceFilter(findQualifiers, keyedReference)));
                }
            }
        }
    }

    private static Filter createKeyedReferenceFilter(FindQualifiers findQualifiers, KeyedReference keyedReference) {
        Filter result = null;
        String tModelProperty = "tmodel.id";
        String keyValueProperty = "keyValue";
        String keyNameProperty = "keyName";
        if (findQualifiers.isExactMatch()) {
            if (findQualifiers.isCaseSensitiveMatch()) {
                result = Filter.and((Filter[])new Filter[]{Filter.equal((String)tModelProperty, (Object)keyedReference.getTmodel().getId()), Filter.equal((String)keyValueProperty, (Object)keyedReference.getKeyValue())});
                if (!StringHelper.isNullOrEmpty((String)keyedReference.getKeyName())) {
                    result.add(Filter.equal((String)keyNameProperty, (Object)keyedReference.getKeyName()));
                }
            } else {
                result = Filter.and((Filter[])new Filter[]{Filter.equal((String)tModelProperty, (Object)keyedReference.getTmodel().getId()), Filter.iequal((String)keyValueProperty, (Object)keyedReference.getKeyValue())});
                if (!StringHelper.isNullOrEmpty((String)keyedReference.getKeyName())) {
                    result.add(Filter.iequal((String)keyNameProperty, (Object)keyedReference.getKeyName()));
                }
            }
        } else if (findQualifiers.isCaseSensitiveMatch()) {
            result = Filter.and((Filter[])new Filter[]{Filter.equal((String)tModelProperty, (Object)keyedReference.getTmodel().getId()), Filter.like((String)keyValueProperty, (String)keyedReference.getKeyValue())});
            if (!StringHelper.isNullOrEmpty((String)keyedReference.getKeyName())) {
                result.add(Filter.like((String)keyNameProperty, (String)keyedReference.getKeyName()));
            }
        } else {
            result = Filter.and((Filter[])new Filter[]{Filter.equal((String)tModelProperty, (Object)keyedReference.getTmodel().getId()), Filter.ilike((String)keyValueProperty, (String)keyedReference.getKeyValue())});
            if (!StringHelper.isNullOrEmpty((String)keyedReference.getKeyName())) {
                result.add(Filter.ilike((String)keyNameProperty, (String)keyedReference.getKeyName()));
            }
        }
        return result;
    }

    protected static Filter createCategoryBagFilter(FindQualifiers findQualifiers, CategoryBag dragonCategoryBag) {
        Filter filterCategoryBag = null;
        filterCategoryBag = findQualifiers.isOrAllKeys() ? Filter.or((Filter[])new Filter[0]) : Filter.and((Filter[])new Filter[0]);
        if (dragonCategoryBag != null) {
            CommonQueryHelper.createKeyedReferencesFilter(findQualifiers, dragonCategoryBag.getKeyedReferences(), filterCategoryBag, "categoryBag.keyedReferences");
            CommonQueryHelper.createKeyedReferenceGroupsFilter(findQualifiers, dragonCategoryBag, filterCategoryBag);
        }
        return filterCategoryBag;
    }

    private static void createKeyedReferenceGroupsFilter(FindQualifiers findQualifiers, CategoryBag dragonCategoryBag, Filter filterCategoryBag) {
        block5: {
            List keyedReferenceGroups = dragonCategoryBag.getKeyedReferenceGroups();
            if (keyedReferenceGroups == null) break block5;
            String catBagKeyedRefGroupsProperty = "categoryBag.keyedReferenceGroups";
            if (findQualifiers.isOrLikeKeys()) {
                Collections.sort(keyedReferenceGroups, new Comparator<KeyedReferenceGroup>(){

                    @Override
                    public int compare(KeyedReferenceGroup o1, KeyedReferenceGroup o2) {
                        return o1.getTmodel().getId().compareTo(o2.getTmodel().getId());
                    }
                });
                String currentKRGTModelKey = null;
                Filter sameNamespaceFilter = null;
                for (KeyedReferenceGroup keyedReferenceGroup : keyedReferenceGroups) {
                    if (!keyedReferenceGroup.getTmodel().getId().equals(currentKRGTModelKey)) {
                        sameNamespaceFilter = Filter.or((Filter[])new Filter[0]);
                        filterCategoryBag.add(sameNamespaceFilter);
                        currentKRGTModelKey = keyedReferenceGroup.getTmodel().getId();
                    }
                    sameNamespaceFilter.add(Filter.some((String)catBagKeyedRefGroupsProperty, (Filter)CommonQueryHelper.createKeyedReferenceGroupFilter(findQualifiers, keyedReferenceGroup)));
                }
            } else {
                for (KeyedReferenceGroup keyedReferenceGroup : keyedReferenceGroups) {
                    filterCategoryBag.add(Filter.some((String)catBagKeyedRefGroupsProperty, (Filter)CommonQueryHelper.createKeyedReferenceGroupFilter(findQualifiers, keyedReferenceGroup)));
                }
            }
        }
    }

    private static Filter createKeyedReferenceGroupFilter(FindQualifiers findQualifiers, KeyedReferenceGroup keyedReferenceGroup) {
        Filter keyedReferenceGroupFilter = Filter.and((Filter[])new Filter[]{Filter.equal((String)"tmodel.id", (Object)keyedReferenceGroup.getTmodel().getId())});
        List keyedReferences = keyedReferenceGroup.getKeyedReferences();
        if (keyedReferences != null) {
            Filter keyedRefInGroupFilter = null;
            keyedRefInGroupFilter = findQualifiers.isOrAllKeys() ? Filter.or((Filter[])new Filter[0]) : Filter.and((Filter[])new Filter[0]);
            CommonQueryHelper.createKeyedReferencesFilter(findQualifiers, keyedReferences, keyedRefInGroupFilter, "keyedReferences");
            keyedReferenceGroupFilter.add(keyedRefInGroupFilter);
        }
        return keyedReferenceGroupFilter;
    }

    protected static Filter createTModelKeysFilter(FindQualifiers findQualifiers, Set<String> modelKeys, String[] tModelBagSingleProperties, String[] tModelBagMultipleProperties) {
        Filter filterTModelKeys = null;
        filterTModelKeys = findQualifiers.isOrAllKeys() ? Filter.or((Filter[])new Filter[0]) : Filter.and((Filter[])new Filter[0]);
        if (modelKeys != null) {
            for (String modelKey : modelKeys) {
                Filter keyFilter = Filter.or((Filter[])new Filter[0]);
                filterTModelKeys.add(keyFilter);
                if (tModelBagSingleProperties != null) {
                    for (String tModelBagSingleProperty : tModelBagSingleProperties) {
                        keyFilter.add(Filter.equal((String)(tModelBagSingleProperty + ".id"), (Object)modelKey));
                    }
                }
                if (tModelBagMultipleProperties == null) continue;
                for (String tModelBagMultipleProperty : tModelBagMultipleProperties) {
                    keyFilter.add(Filter.some((String)tModelBagMultipleProperty, (Filter)Filter.equal((String)"id", (Object)modelKey)));
                }
            }
        }
        return filterTModelKeys;
    }
}

