/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.query;

import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.util.Set;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.service.uddi.FindQualifiers;
import org.ow2.dragon.service.uddi.query.CommonQueryHelper;
import org.ow2.dragon.service.uddi.query.Paging;
import org.ow2.dragon.util.StringHelper;

public class FindBindingQueryHelper
extends CommonQueryHelper {
    public static IMutableSearch constructFindBindingSearch(FindQualifiers findQualifiers, CategoryBag dragonCategoryBag, Set<String> tModelKeys, String serviceKey, Paging paging) {
        Class<Endpoint> searchedType = Endpoint.class;
        Search searchQuery = FindBindingQueryHelper.createDistinctSearch(searchedType);
        if (!StringHelper.isNullOrEmpty((String)serviceKey)) {
            searchQuery.addFilter(FindBindingQueryHelper.createServiceKeyFilter(serviceKey));
        }
        if (dragonCategoryBag != null) {
            searchQuery.addFilter(FindBindingQueryHelper.createCategoryBagFilter(findQualifiers, dragonCategoryBag));
        }
        if (tModelKeys != null) {
            searchQuery.addFilter(FindBindingQueryHelper.createTModelKeysFilter(findQualifiers, tModelKeys, null, new String[]{"binding.serviceSpecifications", "binding.protocols", "binding.transports"}));
        }
        FindBindingQueryHelper.addSortOptions(searchedType, searchQuery, findQualifiers);
        FindBindingQueryHelper.addPagingOptions(searchQuery, paging);
        return searchQuery;
    }

    private static Filter createServiceKeyFilter(String serviceKey) {
        return Filter.equal((String)"technicalService.id", (Object)serviceKey);
    }
}

