/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v2.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Link;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.organization.DiscoveryUrl;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.PhoneNumber;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.dao.UniversalUnifiedDAO;
import org.ow2.dragon.persistence.util.UDDIIdentifierGenerator;
import org.ow2.dragon.service.uddi.v2.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v2.error.InvalidKeyPassedException;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.DragonRepoFileLocator;
import org.uddi.api_v2.AccessPoint;
import org.uddi.api_v2.Address;
import org.uddi.api_v2.AddressLine;
import org.uddi.api_v2.BindingTemplate;
import org.uddi.api_v2.BindingTemplates;
import org.uddi.api_v2.BusinessEntity;
import org.uddi.api_v2.BusinessInfo;
import org.uddi.api_v2.BusinessInfos;
import org.uddi.api_v2.BusinessService;
import org.uddi.api_v2.BusinessServices;
import org.uddi.api_v2.Contact;
import org.uddi.api_v2.Contacts;
import org.uddi.api_v2.Description;
import org.uddi.api_v2.DiscoveryURL;
import org.uddi.api_v2.DiscoveryURLs;
import org.uddi.api_v2.IdentifierBag;
import org.uddi.api_v2.InstanceDetails;
import org.uddi.api_v2.OverviewDoc;
import org.uddi.api_v2.Phone;
import org.uddi.api_v2.RelatedBusinessInfo;
import org.uddi.api_v2.RelatedBusinessInfos;
import org.uddi.api_v2.ServiceInfo;
import org.uddi.api_v2.ServiceInfos;
import org.uddi.api_v2.TModel;
import org.uddi.api_v2.TModelInfo;
import org.uddi.api_v2.TModelInfos;
import org.uddi.api_v2.TModelInstanceDetails;
import org.uddi.api_v2.TModelInstanceInfo;
import org.uddi.api_v2.URLType;

public class UDDITransferObjectAssembler {
    private Logger logger = Logger.getLogger(this.getClass());
    private HttpServletRequest request;
    private UniversalUnifiedDAO universalUnifiedDAO;

    public UDDITransferObjectAssembler(UniversalUnifiedDAO universalUnifiedDAO) {
        this.universalUnifiedDAO = universalUnifiedDAO;
    }

    public BusinessEntity toUDDIBusiness(OrganizationUnit dragonBusiness) {
        List dragonDiscoveryUrls;
        List descriptions;
        BusinessEntity apiBusiness = new BusinessEntity();
        apiBusiness.setBusinessKey(UDDIIdentifierGenerator.toUddiV2Id((String)dragonBusiness.getId()));
        apiBusiness.setCategoryBag(this.toUDDICategoryBag(dragonBusiness.getCategoryBag()));
        apiBusiness.setIdentifierBag(this.toUDDIIdentifierBag(dragonBusiness.getIdentifierBag()));
        List names = dragonBusiness.getNames();
        if (names != null) {
            List<org.uddi.api_v2.Name> apiNames = apiBusiness.getName();
            for (Name name : names) {
                apiNames.add(this.toUDDIName(name));
            }
        }
        if ((descriptions = dragonBusiness.getDescriptions()) != null) {
            List<Description> apiDescriptions = apiBusiness.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
        }
        if ((dragonDiscoveryUrls = dragonBusiness.getDiscoveryUrls()) != null) {
            DiscoveryURLs apiDiscoveryURLs = new DiscoveryURLs();
            List<DiscoveryURL> apiDiscoveryURLList = apiDiscoveryURLs.getDiscoveryURL();
            for (DiscoveryUrl discoveryUrl : dragonDiscoveryUrls) {
                apiDiscoveryURLList.add(this.toUDDIDiscoveryUrl(discoveryUrl));
            }
            apiBusiness.setDiscoveryURLs(apiDiscoveryURLs);
        }
        apiBusiness.setContacts(this.retrieveOrganizationContacts(dragonBusiness));
        apiBusiness.setBusinessServices(this.retrieveLinkedBusinessServices(dragonBusiness));
        return apiBusiness;
    }

    private BusinessServices retrieveLinkedBusinessServices(OrganizationUnit dragonBusiness) {
        BusinessServices businessServices = new BusinessServices();
        Set roles = dragonBusiness.getFromLinks();
        if (roles != null) {
            List<BusinessService> apiServices = businessServices.getBusinessService();
            for (Link role : roles) {
                if (!(role.getTo() instanceof TechnicalService) || !role.getType().equalsIgnoreCase("Provider")) continue;
                TechnicalService techServ = (TechnicalService)role.getTo();
                apiServices.add(this.toUDDIService(techServ));
            }
        }
        return businessServices;
    }

    private Contacts retrieveOrganizationContacts(OrganizationUnit dragonBusiness) {
        Contacts contacts = new Contacts();
        List<Contact> apiContacts = contacts.getContact();
        Set parties = dragonBusiness.getParties();
        if (parties != null) {
            for (Party party : parties) {
                Person person;
                if (!(party instanceof Person) || !(person = (Person)party).isContact() && (person.getPost() == null || !person.getPost().isContact())) continue;
                apiContacts.add(this.toUDDIContact(person));
            }
        }
        return contacts;
    }

    private Contact toUDDIContact(Person person) {
        List orgAddresses;
        List dragonEmails;
        List dragonPhones;
        List descriptions;
        List names;
        Contact contact = new Contact();
        if (person.getPost() != null) {
            contact.setUseType(person.getPost().getNature());
        }
        if ((names = person.getNames()) != null && !names.isEmpty()) {
            contact.setPersonName(((Name)names.get(0)).getName());
        }
        if ((descriptions = person.getDescriptions()) != null) {
            List<Description> apiDescriptions = contact.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
            apiDescriptions.add(this.toUDDIDescription(person.getPost()));
        }
        if ((dragonPhones = person.getPhoneNumbers()) != null) {
            List<Phone> apiPhones = contact.getPhone();
            for (PhoneNumber phone : dragonPhones) {
                apiPhones.add(this.toUDDIPhone(phone));
            }
        }
        if ((dragonEmails = person.getEmailAddresses()) != null) {
            List<org.uddi.api_v2.Email> apiEmails = contact.getEmail();
            for (Email email : dragonEmails) {
                apiEmails.add(this.toUDDIEmail(email));
            }
        }
        List dragonAddresses = person.getAddresses();
        List<Address> apiAddresses = contact.getAddress();
        if (dragonAddresses != null) {
            for (org.ow2.dragon.persistence.bo.organization.Address address : dragonAddresses) {
                apiAddresses.add(this.toUDDIAddress(address));
            }
        }
        if (person.getParentOrganization() != null && (orgAddresses = person.getParentOrganization().getAddresses()) != null) {
            for (org.ow2.dragon.persistence.bo.organization.Address address : orgAddresses) {
                apiAddresses.add(this.toUDDIAddress(address));
            }
        }
        return contact;
    }

    private Description toUDDIDescription(Post post) {
        Description apiDescription = null;
        if (post != null) {
            apiDescription = new Description();
            apiDescription.setLang("en");
            apiDescription.setValue(post.getDescription());
        }
        return apiDescription;
    }

    private Address toUDDIAddress(org.ow2.dragon.persistence.bo.organization.Address address) {
        Address apiAddress = null;
        if (address != null) {
            List dragonLines;
            apiAddress = new Address();
            apiAddress.setUseType(address.getUseType());
            if (address.getTModel() != null) {
                apiAddress.setTModelKey(UDDIIdentifierGenerator.toUddiV2Id((String)address.getTModel().getId()));
            }
            if ((dragonLines = address.getAddressLines()) != null) {
                List<AddressLine> apiLines = apiAddress.getAddressLine();
                for (org.ow2.dragon.persistence.bo.organization.AddressLine addressLine : dragonLines) {
                    apiLines.add(this.toUDDIAddressLine(addressLine));
                }
            }
        }
        return apiAddress;
    }

    private AddressLine toUDDIAddressLine(org.ow2.dragon.persistence.bo.organization.AddressLine addressLine) {
        AddressLine apiAddressLine = null;
        if (addressLine != null) {
            apiAddressLine = new AddressLine();
            apiAddressLine.setKeyName(addressLine.getKeyName());
            apiAddressLine.setKeyValue(addressLine.getKeyValue());
            apiAddressLine.setValue(addressLine.getAddressLine());
        }
        return apiAddressLine;
    }

    private org.uddi.api_v2.Email toUDDIEmail(Email email) {
        org.uddi.api_v2.Email apiEmail = null;
        if (email != null) {
            apiEmail = new org.uddi.api_v2.Email();
            apiEmail.setUseType(email.getUseType());
            apiEmail.setValue(email.getEmail());
        }
        return apiEmail;
    }

    private Phone toUDDIPhone(PhoneNumber phone) {
        Phone apiPhone = null;
        if (phone != null) {
            apiPhone = new Phone();
            apiPhone.setUseType(phone.getUseType());
            apiPhone.setValue(phone.getPhoneNumber());
        }
        return apiPhone;
    }

    private DiscoveryURL toUDDIDiscoveryUrl(DiscoveryUrl discoveryUrl) {
        DiscoveryURL apiUrl = null;
        if (discoveryUrl != null) {
            apiUrl = new DiscoveryURL();
            apiUrl.setUseType(discoveryUrl.getUseType());
            apiUrl.setValue(discoveryUrl.getUrl());
        }
        return apiUrl;
    }

    private DiscoveryUrl toDragonDiscoveryUrl(DiscoveryURL discoveryUrl) {
        DiscoveryUrl dragonUrl = null;
        if (discoveryUrl != null) {
            dragonUrl = new DiscoveryUrl();
            dragonUrl.setUseType(discoveryUrl.getUseType());
            dragonUrl.setUrl(discoveryUrl.getValue());
        }
        return dragonUrl;
    }

    public List<DiscoveryUrl> toDragonDiscoveryUrls(DiscoveryURLs discoveryURLs) {
        List<DiscoveryURL> apiDiscoveryURLs;
        ArrayList<DiscoveryUrl> dragonDiscoveryUrls = new ArrayList<DiscoveryUrl>();
        if (discoveryURLs != null && (apiDiscoveryURLs = discoveryURLs.getDiscoveryURL()) != null) {
            for (DiscoveryURL discoveryUrl : apiDiscoveryURLs) {
                dragonDiscoveryUrls.add(this.toDragonDiscoveryUrl(discoveryUrl));
            }
        }
        return dragonDiscoveryUrls;
    }

    public BusinessService toUDDIService(TechnicalService dragonService) {
        List descriptions;
        BusinessService apiService = new BusinessService();
        apiService.setServiceKey(UDDIIdentifierGenerator.toUddiV2Id((String)dragonService.getId()));
        List names = dragonService.getNames();
        if (names != null) {
            List<org.uddi.api_v2.Name> apiNames = apiService.getName();
            for (Name name : names) {
                apiNames.add(this.toUDDIName(name));
            }
        }
        if ((descriptions = dragonService.getDescriptions()) != null) {
            List<Description> apiDescriptions = apiService.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
        }
        apiService.setCategoryBag(this.toUDDICategoryBag(dragonService.getCategoryBag()));
        apiService.setBusinessKey(UDDIIdentifierGenerator.toUddiV2Id((String)this.retrieveBusinessKeyFormTechServ(dragonService)));
        Set eps = dragonService.getEndpoints();
        if (eps != null) {
            BindingTemplates bindingTemplates = new BindingTemplates();
            List<BindingTemplate> apiBindings = bindingTemplates.getBindingTemplate();
            for (Endpoint ep : eps) {
                apiBindings.add(this.toUDDIBindingTemplate(ep));
            }
            apiService.setBindingTemplates(bindingTemplates);
        }
        return apiService;
    }

    private String retrieveBusinessKeyFormTechServ(TechnicalService dragonService) {
        String bKey = null;
        Set roles = dragonService.getToLinks();
        if (roles != null) {
            for (Link partyToTechService : roles) {
                if (!"Provider".equalsIgnoreCase(partyToTechService.getType())) continue;
                bKey = partyToTechService.getFrom().getId();
                break;
            }
        }
        return bKey;
    }

    public BindingTemplate toUDDIBindingTemplate(Endpoint dragonEP) {
        BindingTemplate apiBinding = new BindingTemplate();
        apiBinding.setBindingKey(UDDIIdentifierGenerator.toUddiV2Id((String)dragonEP.getId()));
        apiBinding.setServiceKey(UDDIIdentifierGenerator.toUddiV2Id((String)dragonEP.getTechnicalService().getId()));
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setURLType(URLType.HTTP);
        accessPoint.setValue(dragonEP.getNetworkAddress());
        apiBinding.setAccessPoint(accessPoint);
        List descriptions = dragonEP.getDescriptions();
        if (descriptions != null) {
            List<Description> apiDescriptions = apiBinding.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
        }
        TModelInstanceDetails instanceDetails = new TModelInstanceDetails();
        apiBinding.setTModelInstanceDetails(instanceDetails);
        List<TModelInstanceInfo> instanceInfos = instanceDetails.getTModelInstanceInfo();
        TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
        instanceInfo.setTModelKey(UDDIIdentifierGenerator.toUddiV2Id((String)dragonEP.getBinding().getId()));
        org.ow2.dragon.persistence.bo.common.Description description = new org.ow2.dragon.persistence.bo.common.Description();
        description.setLangCode("en");
        description.setDescription("The wsdl:binding that this wsdl:port (endpoint) implements. The instanceParms specifies the port (endpoint) local name.");
        instanceInfo.getDescription().add(this.toUDDIDescription(description));
        InstanceDetails instanceDetails2 = new InstanceDetails();
        instanceDetails2.setInstanceParms(dragonEP.getName());
        instanceInfo.setInstanceDetails(instanceDetails2);
        instanceInfos.add(instanceInfo);
        return apiBinding;
    }

    public TModel toUDDITModel(org.ow2.dragon.persistence.bo.common.TModel dragonTModel) {
        TModel apiTModel = new TModel();
        apiTModel.setName(this.toUDDIName(dragonTModel.getName()));
        apiTModel.setCategoryBag(this.toUDDICategoryBag(dragonTModel.getCategoryBag()));
        apiTModel.setIdentifierBag(this.toUDDIIdentifierBag(dragonTModel.getIdentifierBag()));
        apiTModel.setTModelKey(UDDIIdentifierGenerator.toUddiV2Id((String)dragonTModel.getId()));
        List descriptions = dragonTModel.getDescriptions();
        if (descriptions != null) {
            List<Description> apiDescriptions = apiTModel.getDescription();
            for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                apiDescriptions.add(this.toUDDIDescription(description));
            }
        }
        List simpleFiles = null;
        simpleFiles = dragonTModel instanceof ServiceInterface ? ((ServiceSpecification)((ServiceInterface)dragonTModel).getServiceSpecs().iterator().next()).getOverviewDocs() : (dragonTModel instanceof Binding ? ((ServiceSpecification)((Binding)dragonTModel).getServiceSpecifications().iterator().next()).getOverviewDocs() : dragonTModel.getOverviewDocs());
        if (simpleFiles != null && !simpleFiles.isEmpty()) {
            apiTModel.setOverviewDoc(this.toUDDIOverviewDoc((SimpleFile)simpleFiles.get(0)));
        }
        return apiTModel;
    }

    private OverviewDoc toUDDIOverviewDoc(SimpleFile simpleFile) {
        OverviewDoc overviewDoc = null;
        if (simpleFile != null) {
            overviewDoc = new OverviewDoc();
            String overviewURL = "";
            try {
                overviewURL = DragonRepoFileLocator.getRepoFileURL((ContentType)simpleFile.getFileType(), (String)simpleFile.getFileName(), (String)simpleFile.getId(), (HttpServletRequest)this.request);
            }
            catch (IOException e) {
                this.logger.warn((Object)"Can't create document overview URL", (Throwable)e);
            }
            overviewDoc.setOverviewURL(overviewURL);
        }
        return overviewDoc;
    }

    private Description toUDDIDescription(org.ow2.dragon.persistence.bo.common.Description description) {
        Description apiDescription = null;
        if (description != null) {
            apiDescription = new Description();
            apiDescription.setLang(description.getLangCode());
            apiDescription.setValue(description.getDescription());
        }
        return apiDescription;
    }

    private IdentifierBag toUDDIIdentifierBag(List<KeyedReference> identifierBag) {
        IdentifierBag apiBag = null;
        if (identifierBag != null) {
            apiBag = new IdentifierBag();
            for (KeyedReference keyedReference : identifierBag) {
                apiBag.getKeyedReference().add(this.toUDDIKeyedReference(keyedReference));
            }
        }
        return apiBag;
    }

    private org.uddi.api_v2.KeyedReference toUDDIKeyedReference(KeyedReference keyedReference) {
        org.uddi.api_v2.KeyedReference apiKeyedReference = null;
        if (keyedReference != null) {
            apiKeyedReference = new org.uddi.api_v2.KeyedReference();
            apiKeyedReference.setKeyName(keyedReference.getKeyName());
            apiKeyedReference.setKeyValue(keyedReference.getKeyValue());
            if (keyedReference.getTmodel() != null) {
                apiKeyedReference.setTModelKey(UDDIIdentifierGenerator.toUddiV2Id((String)keyedReference.getTmodel().getId()));
            }
        }
        return apiKeyedReference;
    }

    private org.uddi.api_v2.CategoryBag toUDDICategoryBag(CategoryBag categoryBag) {
        org.uddi.api_v2.CategoryBag apiBag = null;
        if (categoryBag != null) {
            apiBag = new org.uddi.api_v2.CategoryBag();
            List keyedReferences = categoryBag.getKeyedReferences();
            if (keyedReferences != null) {
                for (KeyedReference keyedReference : keyedReferences) {
                    org.uddi.api_v2.KeyedReference apiKeyedReference = this.toUDDIKeyedReference(keyedReference);
                    apiBag.getKeyedReference().add(apiKeyedReference);
                }
            }
        }
        return apiBag;
    }

    public org.uddi.api_v2.Name toUDDIName(Name dragonName) {
        org.uddi.api_v2.Name apiName = null;
        if (dragonName != null) {
            apiName = new org.uddi.api_v2.Name();
            apiName.setLang(dragonName.getLangCode());
            apiName.setValue(dragonName.getName());
        }
        return apiName;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public CategoryBag toDragonCategoryBag(org.uddi.api_v2.CategoryBag categoryBag) throws InvalidKeyPassedException {
        CategoryBag dragonBag = null;
        if (categoryBag != null) {
            dragonBag = new CategoryBag();
            List<org.uddi.api_v2.KeyedReference> content = categoryBag.getKeyedReference();
            if (content != null) {
                for (org.uddi.api_v2.KeyedReference element : content) {
                    dragonBag.addKeyedReference(this.toDragonKeyedReference(element));
                }
            }
        }
        return dragonBag;
    }

    private KeyedReference toDragonKeyedReference(org.uddi.api_v2.KeyedReference apiKR) throws InvalidKeyPassedException {
        KeyedReference keyedReference = null;
        if (apiKR != null) {
            keyedReference = new KeyedReference();
            keyedReference.setKeyName(apiKR.getKeyName());
            keyedReference.setKeyValue(apiKR.getKeyValue());
            if (apiKR.getTModelKey() != null) {
                org.ow2.dragon.persistence.bo.common.TModel model = (org.ow2.dragon.persistence.bo.common.TModel)this.universalUnifiedDAO.get(org.ow2.dragon.persistence.bo.common.TModel.class, (Serializable)((Object)UDDIIdentifierGenerator.toUddiV3Id((String)apiKR.getTModelKey())));
                if (model != null) {
                    keyedReference.setTmodel(model);
                } else {
                    throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", apiKR.getTModelKey()));
                }
            }
        }
        return keyedReference;
    }

    public List<KeyedReference> toDragonIdentifierBag(IdentifierBag identifierBag) throws InvalidKeyPassedException {
        List<org.uddi.api_v2.KeyedReference> apiKRs;
        ArrayList<KeyedReference> dragonIdentifierBag = new ArrayList<KeyedReference>();
        if (identifierBag != null && (apiKRs = identifierBag.getKeyedReference()) != null) {
            for (org.uddi.api_v2.KeyedReference keyedReference : apiKRs) {
                dragonIdentifierBag.add(this.toDragonKeyedReference(keyedReference));
            }
        }
        return dragonIdentifierBag;
    }

    public Name toDragonName(org.uddi.api_v2.Name name) {
        Name dragonName = null;
        if (name != null) {
            dragonName = new Name();
            dragonName.setLangCode(name.getLang());
            dragonName.setName(name.getValue());
        }
        return dragonName;
    }

    public TModelInfos toUDDITModelInfos(List<org.ow2.dragon.persistence.bo.common.TModel> tmodels) {
        TModelInfos result = null;
        if (tmodels != null && !tmodels.isEmpty()) {
            result = new TModelInfos();
            for (org.ow2.dragon.persistence.bo.common.TModel tmodel : tmodels) {
                result.getTModelInfo().add(this.toUDDITModelInfo(tmodel));
            }
        }
        return result;
    }

    public TModelInfo toUDDITModelInfo(org.ow2.dragon.persistence.bo.common.TModel tmodel) {
        TModelInfo result = null;
        if (tmodel != null) {
            result = new TModelInfo();
            result.setName(this.toUDDIName(tmodel.getName()));
            result.setTModelKey(UDDIIdentifierGenerator.toUddiV2Id((String)tmodel.getId()));
        }
        return result;
    }

    public List<Name> toDragonNames(List<org.uddi.api_v2.Name> name) {
        ArrayList<Name> result = new ArrayList<Name>();
        if (name != null) {
            for (org.uddi.api_v2.Name uddiName : name) {
                result.add(this.toDragonName(uddiName));
            }
        }
        return result;
    }

    public ServiceInfos toUDDIServiceInfos(List<TechnicalService> techServices) {
        ServiceInfos result = null;
        if (techServices != null && !techServices.isEmpty()) {
            result = new ServiceInfos();
            for (TechnicalService service : techServices) {
                result.getServiceInfo().add(this.toUDDIServiceInfo(service));
            }
        }
        return result;
    }

    public ServiceInfo toUDDIServiceInfo(TechnicalService service) {
        ServiceInfo result = null;
        if (service != null) {
            result = new ServiceInfo();
            result.setBusinessKey(UDDIIdentifierGenerator.toUddiV2Id((String)this.retrieveBusinessKeyFormTechServ(service)));
            result.setServiceKey(UDDIIdentifierGenerator.toUddiV2Id((String)service.getId()));
            List names = service.getNames();
            if (names != null) {
                List<org.uddi.api_v2.Name> apiNames = result.getName();
                for (Name name : names) {
                    apiNames.add(this.toUDDIName(name));
                }
            }
        }
        return result;
    }

    public RelatedBusinessInfos toUDDIRelatedBusinessInfos(List<OrganizationUnit> relatedOrgs) {
        RelatedBusinessInfos result = null;
        if (relatedOrgs != null && !relatedOrgs.isEmpty()) {
            result = new RelatedBusinessInfos();
            for (OrganizationUnit org : relatedOrgs) {
                result.getRelatedBusinessInfo().add(this.toUDDIRelatedBusinessInfo(org));
            }
        }
        return result;
    }

    public RelatedBusinessInfo toUDDIRelatedBusinessInfo(OrganizationUnit org) {
        RelatedBusinessInfo result = null;
        if (org != null) {
            List descriptions;
            result = new RelatedBusinessInfo();
            result.setBusinessKey(UDDIIdentifierGenerator.toUddiV2Id((String)org.getId()));
            List names = org.getNames();
            if (names != null) {
                List<org.uddi.api_v2.Name> apiNames = result.getName();
                for (Name name : names) {
                    apiNames.add(this.toUDDIName(name));
                }
            }
            if ((descriptions = org.getDescriptions()) != null) {
                List<Description> apiDescriptions = result.getDescription();
                for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                    apiDescriptions.add(this.toUDDIDescription(description));
                }
            }
        }
        return result;
    }

    public BusinessInfos toUDDIBusinessInfos(List<OrganizationUnit> orgs) {
        BusinessInfos result = null;
        if (orgs != null && !orgs.isEmpty()) {
            result = new BusinessInfos();
            for (OrganizationUnit org : orgs) {
                result.getBusinessInfo().add(this.toUDDIBusinessInfo(org));
            }
        }
        return result;
    }

    private BusinessInfo toUDDIBusinessInfo(OrganizationUnit org) {
        BusinessInfo result = null;
        if (org != null) {
            List descriptions;
            result = new BusinessInfo();
            result.setBusinessKey(UDDIIdentifierGenerator.toUddiV2Id((String)org.getId()));
            List names = org.getNames();
            if (names != null) {
                List<org.uddi.api_v2.Name> apiNames = result.getName();
                for (Name name : names) {
                    apiNames.add(this.toUDDIName(name));
                }
            }
            if ((descriptions = org.getDescriptions()) != null) {
                List<Description> apiDescriptions = result.getDescription();
                for (org.ow2.dragon.persistence.bo.common.Description description : descriptions) {
                    apiDescriptions.add(this.toUDDIDescription(description));
                }
            }
            result.setServiceInfos(this.retrieveLinkedBusinessServiceInfos(org));
        }
        return result;
    }

    private ServiceInfos retrieveLinkedBusinessServiceInfos(OrganizationUnit dragonBusiness) {
        ServiceInfos serviceInfos = new ServiceInfos();
        Set roles = dragonBusiness.getFromLinks();
        if (roles != null) {
            List<ServiceInfo> apiServices = serviceInfos.getServiceInfo();
            for (Link role : roles) {
                if (!(role.getTo() instanceof TechnicalService) || !role.getType().equalsIgnoreCase("Provider")) continue;
                TechnicalService technicalService = (TechnicalService)role.getTo();
                apiServices.add(this.toUDDIServiceInfo(technicalService));
            }
        }
        return serviceInfos;
    }
}

