/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v3.impl;

import com.trg.search.IMutableSearch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.organization.DiscoveryUrl;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.dao.UniversalUnifiedDAO;
import org.ow2.dragon.service.uddi.query.FindBindingQueryHelper;
import org.ow2.dragon.service.uddi.query.FindBusinessQueryHelper;
import org.ow2.dragon.service.uddi.query.FindRelatedBusinessesQueryHelper;
import org.ow2.dragon.service.uddi.query.FindServiceQueryHelper;
import org.ow2.dragon.service.uddi.query.FindTModelQueryHelper;
import org.ow2.dragon.service.uddi.query.Paging;
import org.ow2.dragon.service.uddi.v3.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v3.error.InvalidKeyPassedException;
import org.ow2.dragon.service.uddi.v3.impl.FindQualifiersV3;
import org.ow2.dragon.service.uddi.v3.impl.UDDITransferObjectAssembler;
import org.ow2.dragon.service.uddi.v3.validator.InquiryValidator;
import org.ow2.dragon.util.StringHelper;
import org.springframework.transaction.annotation.Transactional;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.OperationalInfos;
import org.uddi.api_v3.RelatedBusinessInfo;
import org.uddi.api_v3.RelatedBusinessInfos;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelBag;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.api_v3.TModelList;
import org.uddi.api_v3_porttype.DispositionReportFaultMessage;
import org.uddi.api_v3_porttype.UDDIInquiryPortType;

@WebService(serviceName="UDDIInquiryService", endpointInterface="org.uddi.api_v3_porttype.UDDIInquiryPortType", targetNamespace="urn:uddi-org:api_v3")
@Transactional(readOnly=true)
public class UDDIInquiryImpl
implements UDDIInquiryPortType {
    private WebServiceContextImpl webServiceContext;
    private UniversalUnifiedDAO universalUnifiedDAO;
    private UDDITransferObjectAssembler transferObjectAssembler;
    private InquiryValidator inquiryValidator;

    public UDDIInquiryImpl(UniversalUnifiedDAO universalUnifiedDAO, WebServiceContextImpl webServiceContext) {
        this.universalUnifiedDAO = universalUnifiedDAO;
        this.webServiceContext = webServiceContext;
        this.transferObjectAssembler = new UDDITransferObjectAssembler(universalUnifiedDAO);
        this.inquiryValidator = new InquiryValidator();
    }

    @Override
    public BindingDetail findBinding(FindBinding body) throws DispositionReportFaultMessage {
        this.inquiryValidator.validateFindBinding(body);
        BindingDetail result = new BindingDetail();
        List<BindingTemplate> bindingTemplates = result.getBindingTemplate();
        FindQualifiersV3 findQualifiers = new FindQualifiersV3(body.getFindQualifiers());
        Paging paging = new Paging(body.getListHead(), body.getMaxRows());
        CategoryBag dragonCategoryBag = this.transferObjectAssembler.toDragonCategoryBag(body.getCategoryBag());
        if (!StringHelper.isNullOrEmpty((String)body.getServiceKey()) && this.universalUnifiedDAO.get(TechnicalService.class, (Serializable)((Object)body.getServiceKey())) == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", body.getServiceKey()));
        }
        Set<String> tModelKeys = this.retrieveTModelKeys(body.getFindTModel(), body.getTModelBag());
        IMutableSearch searchQuery = FindBindingQueryHelper.constructFindBindingSearch(findQualifiers, dragonCategoryBag, tModelKeys, body.getServiceKey(), paging);
        List bindings = this.universalUnifiedDAO.search(Endpoint.class, searchQuery);
        if (bindings != null && !bindings.isEmpty()) {
            result.setListDescription(this.transferObjectAssembler.toUDDIListDescription(this.universalUnifiedDAO.count(Endpoint.class, searchQuery), bindings.size(), paging.getFirstResult() + 1));
            for (Endpoint binding : bindings) {
                bindingTemplates.add(this.transferObjectAssembler.toUDDIBindingTemplate(binding));
            }
        }
        return result;
    }

    private Set<String> retrieveTModelKeys(FindTModel findTModel, TModelBag modelBag) throws DispositionReportFaultMessage {
        List<TModelInfo> infos;
        TModelInfos modelInfos;
        TModelList modelList;
        HashSet<String> keys = new HashSet<String>();
        if (modelBag != null && modelBag.getTModelKey() != null) {
            for (String modelKey : modelBag.getTModelKey()) {
                if (this.universalUnifiedDAO.get(org.ow2.dragon.persistence.bo.common.TModel.class, (Serializable)((Object)modelKey)) != null) {
                    keys.add(modelKey);
                    continue;
                }
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", modelKey));
            }
        }
        if (findTModel != null && (modelList = this.findTModel(findTModel)) != null && (modelInfos = modelList.getTModelInfos()) != null && (infos = modelInfos.getTModelInfo()) != null) {
            for (TModelInfo modelInfo : infos) {
                keys.add(modelInfo.getTModelKey());
            }
        }
        return keys;
    }

    @Override
    public BusinessList findBusiness(FindBusiness body) throws DispositionReportFaultMessage {
        IMutableSearch searchQuery;
        List orgs;
        this.inquiryValidator.validateFindBusiness(body);
        BusinessList result = new BusinessList();
        FindQualifiersV3 findQualifiers = new FindQualifiersV3(body.getFindQualifiers());
        Paging paging = new Paging(body.getListHead(), body.getMaxRows());
        CategoryBag dragonCategoryBag = this.transferObjectAssembler.toDragonCategoryBag(body.getCategoryBag());
        List<Name> names = this.transferObjectAssembler.toDragonNames(body.getName());
        List<KeyedReference> dragonIdentifierBag = this.transferObjectAssembler.toDragonIdentifierBag(body.getIdentifierBag());
        List<DiscoveryUrl> discoveryUrls = this.transferObjectAssembler.toDragonDiscoveryUrls(body.getDiscoveryURLs());
        List<String> relatedOrgsKeys = this.retrieveRelatedOrgsKey(body.getFindRelatedBusinesses());
        List<String> serviceKeys = null;
        if (body.getFindTModel() != null || body.getTModelBag() != null) {
            serviceKeys = this.retrieveMatchingServices(body.getFindTModel(), body.getTModelBag(), body.getFindQualifiers());
        }
        if ((orgs = this.universalUnifiedDAO.search(OrganizationUnit.class, searchQuery = FindBusinessQueryHelper.constructFindBusinessSearch(findQualifiers, dragonCategoryBag, dragonIdentifierBag, discoveryUrls, serviceKeys, names, relatedOrgsKeys, paging))) != null && !orgs.isEmpty()) {
            result.setListDescription(this.transferObjectAssembler.toUDDIListDescription(this.universalUnifiedDAO.count(OrganizationUnit.class, searchQuery), orgs.size(), paging.getFirstResult() + 1));
            result.setBusinessInfos(this.transferObjectAssembler.toUDDIBusinessInfos(orgs));
        }
        return result;
    }

    private List<String> retrieveRelatedOrgsKey(FindRelatedBusinesses findRelatedBusinesses) throws DispositionReportFaultMessage {
        RelatedBusinessesList businessesList;
        ArrayList<String> relatedOrgs = new ArrayList<String>();
        if (findRelatedBusinesses != null && (businessesList = this.findRelatedBusinesses(findRelatedBusinesses)) != null) {
            List<RelatedBusinessInfo> businesses;
            RelatedBusinessInfos businessInfos = businessesList.getRelatedBusinessInfos();
            if (businessInfos != null && (businesses = businessInfos.getRelatedBusinessInfo()) != null) {
                for (RelatedBusinessInfo relatedBusinessInfo : businesses) {
                    relatedOrgs.add(relatedBusinessInfo.getBusinessKey());
                }
            }
            relatedOrgs.add(businessesList.getBusinessKey());
        }
        return relatedOrgs;
    }

    private List<String> retrieveMatchingServices(FindTModel findTModel, TModelBag modelBag, FindQualifiers findQualifiers) throws DispositionReportFaultMessage {
        List<ServiceInfo> services;
        ServiceInfos serviceInfos;
        ArrayList<String> servicesKeys = new ArrayList<String>();
        FindService includedRequest = new FindService();
        includedRequest.setTModelBag(modelBag);
        includedRequest.setFindTModel(findTModel);
        includedRequest.setFindQualifiers(findQualifiers);
        ServiceList serviceList = this.findService(includedRequest);
        if (serviceList != null && (serviceInfos = serviceList.getServiceInfos()) != null && (services = serviceInfos.getServiceInfo()) != null) {
            for (ServiceInfo serviceInfo : services) {
                servicesKeys.add(serviceInfo.getServiceKey());
            }
        }
        return servicesKeys;
    }

    @Override
    public RelatedBusinessesList findRelatedBusinesses(FindRelatedBusinesses body) throws DispositionReportFaultMessage {
        OrganizationUnit orgSource;
        this.inquiryValidator.validateFindRelatedBusinesses(body, false);
        RelatedBusinessesList result = new RelatedBusinessesList();
        FindQualifiersV3 findQualifiers = new FindQualifiersV3(body.getFindQualifiers());
        Paging paging = new Paging(body.getListHead(), body.getMaxRows());
        if (body.getBusinessKey() != null && (orgSource = (OrganizationUnit)this.universalUnifiedDAO.get(OrganizationUnit.class, (Serializable)((Object)body.getBusinessKey()))) == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", body.getBusinessKey()));
        }
        IMutableSearch searchQuery = FindRelatedBusinessesQueryHelper.constructFindRelatedBusinessesSearch(findQualifiers, body.getBusinessKey(), paging);
        List relatedOrgs = this.universalUnifiedDAO.search(OrganizationUnit.class, searchQuery);
        if (relatedOrgs != null && !relatedOrgs.isEmpty()) {
            result.setListDescription(this.transferObjectAssembler.toUDDIListDescription(this.universalUnifiedDAO.count(OrganizationUnit.class, searchQuery), relatedOrgs.size(), paging.getFirstResult() + 1));
            result.setRelatedBusinessInfos(this.transferObjectAssembler.toUDDIRelatedBusinessInfos(relatedOrgs));
        }
        result.setBusinessKey(body.getBusinessKey());
        return result;
    }

    @Override
    public ServiceList findService(FindService body) throws DispositionReportFaultMessage {
        this.inquiryValidator.validateFindService(body);
        ServiceList result = new ServiceList();
        FindQualifiersV3 findQualifiers = new FindQualifiersV3(body.getFindQualifiers());
        Paging paging = new Paging(body.getListHead(), body.getMaxRows());
        CategoryBag dragonCategoryBag = this.transferObjectAssembler.toDragonCategoryBag(body.getCategoryBag());
        if (!StringHelper.isNullOrEmpty((String)body.getBusinessKey()) && this.universalUnifiedDAO.get(OrganizationUnit.class, (Serializable)((Object)body.getBusinessKey())) == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", body.getBusinessKey()));
        }
        List<Name> names = this.transferObjectAssembler.toDragonNames(body.getName());
        Set<String> tModelKeys = this.retrieveTModelKeys(body.getFindTModel(), body.getTModelBag());
        IMutableSearch searchQuery = FindServiceQueryHelper.constructFindServiceSearch(findQualifiers, dragonCategoryBag, tModelKeys, body.getBusinessKey(), names, paging);
        List techServices = this.universalUnifiedDAO.search(TechnicalService.class, searchQuery);
        if (techServices != null && !techServices.isEmpty()) {
            result.setListDescription(this.transferObjectAssembler.toUDDIListDescription(this.universalUnifiedDAO.count(TechnicalService.class, searchQuery), techServices.size(), paging.getFirstResult() + 1));
            result.setServiceInfos(this.transferObjectAssembler.toUDDIServiceInfos(techServices));
        }
        return result;
    }

    @Override
    public TModelList findTModel(FindTModel body) throws DispositionReportFaultMessage {
        this.inquiryValidator.validateFindTModel(body, false);
        TModelList result = new TModelList();
        FindQualifiersV3 findQualifiers = new FindQualifiersV3(body.getFindQualifiers());
        Paging paging = new Paging(body.getListHead(), body.getMaxRows());
        CategoryBag dragonCategoryBag = this.transferObjectAssembler.toDragonCategoryBag(body.getCategoryBag());
        List<KeyedReference> dragonIdentifierBag = this.transferObjectAssembler.toDragonIdentifierBag(body.getIdentifierBag());
        Name name = this.transferObjectAssembler.toDragonName(body.getName());
        IMutableSearch searchQuery = FindTModelQueryHelper.constructFindTModelSearch(findQualifiers, dragonCategoryBag, dragonIdentifierBag, name, paging);
        List tmodels = this.universalUnifiedDAO.search(org.ow2.dragon.persistence.bo.common.TModel.class, searchQuery);
        if (tmodels != null && !tmodels.isEmpty()) {
            result.setListDescription(this.transferObjectAssembler.toUDDIListDescription(this.universalUnifiedDAO.count(org.ow2.dragon.persistence.bo.common.TModel.class, searchQuery), tmodels.size(), paging.getFirstResult() + 1));
            result.setTModelInfos(this.transferObjectAssembler.toUDDITModelInfos(tmodels));
        }
        return result;
    }

    @Override
    public BindingDetail getBindingDetail(GetBindingDetail body) throws DispositionReportFaultMessage {
        BindingDetail result = new BindingDetail();
        List<String> keys = body.getBindingKey();
        for (String key : keys) {
            Endpoint dragonEp = (Endpoint)this.universalUnifiedDAO.get(Endpoint.class, (Serializable)((Object)key));
            if (dragonEp == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BindingTemplatelNotFound", key));
            }
            this.setRequestOnTOA();
            BindingTemplate apiBindingTemplate = this.transferObjectAssembler.toUDDIBindingTemplate(dragonEp);
            result.getBindingTemplate().add(apiBindingTemplate);
        }
        return result;
    }

    @Override
    public BusinessDetail getBusinessDetail(GetBusinessDetail body) throws DispositionReportFaultMessage {
        BusinessDetail result = new BusinessDetail();
        List<String> keys = body.getBusinessKey();
        for (String key : keys) {
            OrganizationUnit dragonBusiness = (OrganizationUnit)this.universalUnifiedDAO.get(OrganizationUnit.class, (Serializable)((Object)key));
            if (dragonBusiness == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", key));
            }
            this.setRequestOnTOA();
            BusinessEntity apiBusiness = this.transferObjectAssembler.toUDDIBusiness(dragonBusiness);
            result.getBusinessEntity().add(apiBusiness);
        }
        return result;
    }

    @Override
    public OperationalInfos getOperationalInfo(GetOperationalInfo body) throws DispositionReportFaultMessage {
        return null;
    }

    @Override
    public ServiceDetail getServiceDetail(GetServiceDetail body) throws DispositionReportFaultMessage {
        ServiceDetail result = new ServiceDetail();
        List<String> keys = body.getServiceKey();
        for (String key : keys) {
            TechnicalService dragonService = (TechnicalService)this.universalUnifiedDAO.get(TechnicalService.class, (Serializable)((Object)key));
            if (dragonService == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.ServiceNotFound", key));
            }
            this.setRequestOnTOA();
            BusinessService apiService = this.transferObjectAssembler.toUDDIService(dragonService);
            result.getBusinessService().add(apiService);
        }
        return result;
    }

    private void setRequestOnTOA() {
        HttpServletRequest request = (HttpServletRequest)this.webServiceContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        this.transferObjectAssembler.setRequest(request);
    }

    @Override
    public TModelDetail getTModelDetail(GetTModelDetail body) throws DispositionReportFaultMessage {
        TModelDetail result = new TModelDetail();
        List<String> keys = body.getTModelKey();
        for (String key : keys) {
            org.ow2.dragon.persistence.bo.common.TModel dragonTModel = (org.ow2.dragon.persistence.bo.common.TModel)this.universalUnifiedDAO.get(org.ow2.dragon.persistence.bo.common.TModel.class, (Serializable)((Object)key));
            if (dragonTModel == null) {
                throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.TModelNotFound", key));
            }
            this.setRequestOnTOA();
            TModel apiTModel = this.transferObjectAssembler.toUDDITModel(dragonTModel);
            result.getTModel().add(apiTModel);
        }
        return result;
    }
}

