/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.uddi.v3.validator;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.ow2.dragon.service.uddi.v3.error.ErrorMessage;
import org.ow2.dragon.service.uddi.v3.error.FatalErrorException;
import org.ow2.dragon.service.uddi.v3.error.InvalidCombinationException;
import org.ow2.dragon.service.uddi.v3.error.InvalidKeyPassedException;
import org.ow2.dragon.service.uddi.v3.error.ValueNotAllowedException;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.ObjectFactory;
import org.uddi.api_v3.TModelBag;
import org.uddi.api_v3_porttype.DispositionReportFaultMessage;

public class InquiryValidator {
    public void validateGetBusinessDetail(GetBusinessDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List<String> entityKeyList = body.getBusinessKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (inserted) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
        }
    }

    public void validateGetServiceDetail(GetServiceDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List<String> entityKeyList = body.getServiceKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (inserted) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
        }
    }

    public void validateGetBindingDetail(GetBindingDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List<String> entityKeyList = body.getBindingKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (inserted) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
        }
    }

    public void validateGetTModelDetail(GetTModelDetail body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        List<String> entityKeyList = body.getTModelKey();
        if (entityKeyList == null || entityKeyList.size() == 0) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.NoKeys"));
        }
        HashSet<String> dupCheck = new HashSet<String>();
        for (String entityKey : entityKeyList) {
            boolean inserted = dupCheck.add(entityKey);
            if (inserted) continue;
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.DuplicateKey", entityKey));
        }
    }

    public void validateFindBusiness(FindBusiness body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getFindTModel() == null && body.getTModelBag() == null && (body.getName() == null || body.getName().isEmpty()) && body.getIdentifierBag() == null && body.getDiscoveryURLs() == null && body.getFindRelatedBusinesses() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findbusiness.NoInput"));
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateFindRelatedBusinesses(body.getFindRelatedBusinesses(), true);
        this.validateDiscoveryUrls(body.getDiscoveryURLs());
        this.validateIdentifierBag(body.getIdentifierBag());
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindService(FindService body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getFindTModel() == null && body.getTModelBag() == null && (body.getName() == null || body.getName().isEmpty())) {
            throw new FatalErrorException(new ErrorMessage("errors.findservice.NoInput"));
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindBinding(FindBinding body) throws DispositionReportFaultMessage {
        if (body == null) {
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getFindTModel() == null && body.getTModelBag() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findbinding.NoInput"));
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateTModelBag(body.getTModelBag());
        this.validateFindTModel(body.getFindTModel(), true);
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindTModel(FindTModel body, boolean nullAllowed) throws DispositionReportFaultMessage {
        if (body == null) {
            if (nullAllowed) {
                return;
            }
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (body.getCategoryBag() == null && body.getIdentifierBag() == null && body.getName() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.findtmodel.NoInput"));
        }
        this.validateFindQualifiers(body.getFindQualifiers());
        this.validateIdentifierBag(body.getIdentifierBag());
        this.validateCategoryBag(body.getCategoryBag());
    }

    public void validateFindRelatedBusinesses(FindRelatedBusinesses body, boolean nullAllowed) throws DispositionReportFaultMessage {
        if (body == null) {
            if (nullAllowed) {
                return;
            }
            throw new FatalErrorException(new ErrorMessage("errors.NullInput"));
        }
        if (!(body.getBusinessKey() != null && body.getBusinessKey().length() != 0 || body.getFromKey() != null && body.getFromKey().length() != 0 || body.getToKey() != null && body.getToKey().length() != 0)) {
            throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.NoInput"));
        }
        boolean businessKeyExists = false;
        boolean fromKeyExists = false;
        if (body.getBusinessKey() != null && body.getBusinessKey().length() > 0) {
            businessKeyExists = true;
        }
        if (body.getFromKey() != null && body.getFromKey().length() > 0) {
            fromKeyExists = true;
            if (businessKeyExists) {
                throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.MultipleInput"));
            }
        }
        if (body.getToKey() != null && body.getToKey().length() > 0 && (businessKeyExists || fromKeyExists)) {
            throw new FatalErrorException(new ErrorMessage("errors.findrelatedbusiness.MultipleInput"));
        }
        KeyedReference keyedRef = body.getKeyedReference();
        if (keyedRef != null && (keyedRef.getTModelKey() == null || keyedRef.getTModelKey().length() == 0 || keyedRef.getKeyName() == null || keyedRef.getKeyName().length() == 0 || keyedRef.getKeyValue() == null || keyedRef.getKeyValue().length() == 0)) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.findrelatedbusiness.BlankKeyedRef"));
        }
    }

    public void validateTModelBag(TModelBag tmodelBag) throws DispositionReportFaultMessage {
        if (tmodelBag == null) {
            return;
        }
        if (tmodelBag.getTModelKey() == null || tmodelBag.getTModelKey().size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.tmodelbag.NoInput"));
        }
    }

    public void validateDiscoveryUrls(DiscoveryURLs discUrls) throws DispositionReportFaultMessage {
        if (discUrls == null) {
            return;
        }
        List<DiscoveryURL> discUrlList = discUrls.getDiscoveryURL();
        if (discUrlList == null || discUrlList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.discurls.NoInput"));
        }
    }

    public void validateCategoryBag(CategoryBag categories) throws DispositionReportFaultMessage {
        if (categories == null) {
            return;
        }
        List<JAXBElement<?>> elems = categories.getContent();
        if (elems == null || elems.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.categorybag.NoInput"));
        }
        for (JAXBElement<?> elem : elems) {
            this.validateKeyedReferenceTypes(elem);
        }
    }

    public void validateIdentifierBag(IdentifierBag identifiers) throws DispositionReportFaultMessage {
        if (identifiers == null) {
            return;
        }
        List<KeyedReference> keyedRefList = identifiers.getKeyedReference();
        if (keyedRefList == null || keyedRefList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.identifierbag.NoInput"));
        }
        for (KeyedReference keyedRef : keyedRefList) {
            this.validateKeyedReferenceTypes(new ObjectFactory().createKeyedReference(keyedRef));
        }
    }

    public void validateKeyedReferenceTypes(JAXBElement<?> elem) throws DispositionReportFaultMessage {
        if (elem == null || elem.getValue() == null) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NullInput"));
        }
        if (elem.getValue() instanceof KeyedReferenceGroup) {
            KeyedReferenceGroup krg = (KeyedReferenceGroup)elem.getValue();
            if (krg.getTModelKey() == null || krg.getTModelKey().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
            }
        } else if (elem.getValue() instanceof KeyedReference) {
            KeyedReference kr = (KeyedReference)elem.getValue();
            if (kr.getTModelKey() == null || kr.getTModelKey().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoTModelKey"));
            }
            if (kr.getKeyValue() == null || kr.getKeyValue().length() == 0) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.keyedreference.NoKeyValue"));
            }
        }
    }

    private void validateFindQualifiers(FindQualifiers findQualifiers) throws DispositionReportFaultMessage {
        if (findQualifiers == null) {
            return;
        }
        List<String> fqList = findQualifiers.getFindQualifier();
        if (fqList == null || fqList.size() == 0) {
            throw new ValueNotAllowedException(new ErrorMessage("errors.findqualifiers.NoInput"));
        }
        Hashtable<String, String> fqTable = new Hashtable<String, String>();
        for (String fq : fqList) {
            String result = fqTable.put(fq.toUpperCase(), fq.toUpperCase());
            if (result != null) {
                throw new ValueNotAllowedException(new ErrorMessage("errors.findqualifiers.DuplicateValue", result));
            }
            if (fq.equalsIgnoreCase("andAllKeys") || fq.equalsIgnoreCase("uddi-org:andAllKeys")) {
                if (fqTable.get("orAllKeys".toUpperCase()) != null || fqTable.get("uddi-org:orAllKeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orAllKeys"));
                }
                if (fqTable.get("orLikeKeys".toUpperCase()) != null || fqTable.get("uddi-org:orLikeKeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orLikeKeys"));
                }
            } else if (fq.equalsIgnoreCase("orAllKeys") || fq.equalsIgnoreCase("uddi-org:orAllKeys")) {
                if (fqTable.get("andAllKeys".toUpperCase()) != null || fqTable.get("uddi-org:andAllKeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "andAllKeys"));
                }
                if (fqTable.get("orLikeKeys".toUpperCase()) != null || fqTable.get("uddi-org:orLikeKeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orLikeKeys"));
                }
            } else if (fq.equalsIgnoreCase("orLikeKeys") || fq.equalsIgnoreCase("uddi-org:orLikeKeys")) {
                if (fqTable.get("andAllKeys".toUpperCase()) != null || fqTable.get("uddi-org:andAllKeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "andAllKeys"));
                }
                if (fqTable.get("orAllKeys".toUpperCase()) != null || fqTable.get("uddi-org:orAllKeys".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "orAllKeys"));
                }
            }
            if (fq.equalsIgnoreCase("sortByNameAsc") || fq.equalsIgnoreCase("uddi-org:sortByNameAsc")) {
                if (fqTable.get("sortByNameDesc".toUpperCase()) != null || fqTable.get("uddi-org:sortByNameDesc".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByNameDesc"));
                }
            } else if ((fq.equalsIgnoreCase("sortByNameDesc") || fq.equalsIgnoreCase("uddi-org:sortByNameDesc")) && (fqTable.get("sortByNameAsc".toUpperCase()) != null || fqTable.get("uddi-org:sortByNameAsc".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByNameAsc"));
            }
            if (fq.equalsIgnoreCase("sortByDateAsc") || fq.equalsIgnoreCase("uddi-org:sortByDateAsc")) {
                if (fqTable.get("sortByDateDesc".toUpperCase()) != null || fqTable.get("uddi-org:sortByDateDesc".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByDateDesc"));
                }
            } else if ((fq.equalsIgnoreCase("sortByDateDesc") || fq.equalsIgnoreCase("uddi-org:sortByDateDesc")) && (fqTable.get("sortByDateAsc".toUpperCase()) != null || fqTable.get("uddi-org:sortByDateAsc".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "sortByDateAsc"));
            }
            if (fq.equalsIgnoreCase("combineCategoryBags") || fq.equalsIgnoreCase("uddi-org:combineCategoryBags)")) {
                if (fqTable.get("serviceSubset".toUpperCase()) != null || fqTable.get("uddi-org:serviceSubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "serviceSubset"));
                }
                if (fqTable.get("bindingSubset".toUpperCase()) != null || fqTable.get("uddi-org:bindingSubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "bindingSubset"));
                }
            } else if (fq.equalsIgnoreCase("serviceSubset") || fq.equalsIgnoreCase("uddi-org:serviceSubset")) {
                if (fqTable.get("combineCategoryBags".toUpperCase()) != null || fqTable.get("uddi-org:combineCategoryBags)".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "combineCategoryBags"));
                }
                if (fqTable.get("bindingSubset".toUpperCase()) != null || fqTable.get("uddi-org:bindingSubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "bindingSubset"));
                }
            } else if (fq.equalsIgnoreCase("bindingSubset") || fq.equalsIgnoreCase("uddi-org:bindingSubset")) {
                if (fqTable.get("serviceSubset".toUpperCase()) != null || fqTable.get("uddi-org:serviceSubset".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "serviceSubset"));
                }
                if (fqTable.get("combineCategoryBags".toUpperCase()) != null || fqTable.get("uddi-org:combineCategoryBags)".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "combineCategoryBags"));
                }
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi-org:exactMatch")) {
                if (fqTable.get("approximateMatch".toUpperCase()) != null || fqTable.get("uddi-org:approximateMatch:SQL99".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "approximateMatch"));
                }
            } else if ((fq.equalsIgnoreCase("approximateMatch") || fq.equalsIgnoreCase("uddi-org:approximateMatch:SQL99")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi-org:exactMatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi-org:exactMatch")) {
                if (fqTable.get("caseInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi-org:caseInsensitiveMatch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("caseInsensitiveMatch") || fq.equalsIgnoreCase("uddi-org:caseInsensitiveMatch")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi-org:exactMatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("binarySort") || fq.equalsIgnoreCase("uddi-org:binarySort)")) {
                if (fqTable.get("UTS-10".toUpperCase()) != null || fqTable.get("uddi-org:UTS-10".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "UTS-10"));
                }
            } else if ((fq.equalsIgnoreCase("UTS-10") || fq.equalsIgnoreCase("uddi-org:UTS-10")) && (fqTable.get("binarySort".toUpperCase()) != null || fqTable.get("uddi-org:binarySort)".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "binarySort"));
            }
            if (fq.equalsIgnoreCase("diacriticSensitiveMatch") || fq.equalsIgnoreCase("uddi-org:diacriticSensitiveMatch")) {
                if (fqTable.get("diacriticInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi-org:diacriticInsensitiveMatch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("diacriticInsensitiveMatch") || fq.equalsIgnoreCase("uddi-org:diacriticInsensitiveMatch")) && (fqTable.get("diacriticSensitiveMatch".toUpperCase()) != null || fqTable.get("uddi-org:diacriticSensitiveMatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticSensitiveMatch"));
            }
            if (fq.equalsIgnoreCase("exactMatch") || fq.equalsIgnoreCase("uddi-org:exactMatch")) {
                if (fqTable.get("diacriticInsensitiveMatch".toUpperCase()) != null || fqTable.get("uddi-org:diacriticInsensitiveMatch".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "diacriticInsensitiveMatch"));
                }
            } else if ((fq.equalsIgnoreCase("diacriticInsensitiveMatch") || fq.equalsIgnoreCase("uddi-org:diacriticInsensitiveMatch")) && (fqTable.get("exactMatch".toUpperCase()) != null || fqTable.get("uddi-org:exactMatch".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "exactMatch"));
            }
            if (fq.equalsIgnoreCase("caseSensitiveSort") || fq.equalsIgnoreCase("uddi-org:caseSensitiveSort")) {
                if (fqTable.get("caseInsensitiveSort".toUpperCase()) != null || fqTable.get("uddi-org:caseInsensitiveSort".toUpperCase()) != null) {
                    throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveSort"));
                }
            } else if ((fq.equalsIgnoreCase("caseInsensitiveSort") || fq.equalsIgnoreCase("uddi-org:caseInsensitiveSort")) && (fqTable.get("caseSensitiveSort".toUpperCase()) != null || fqTable.get("uddi-org:caseSensitiveSort".toUpperCase()) != null)) {
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseSensitiveSort"));
            }
            if (fq.equalsIgnoreCase("caseSensitiveMatch") || fq.equalsIgnoreCase("uddi-org:caseSensitiveMatch")) {
                if (fqTable.get("caseInsensitiveMatch".toUpperCase()) == null && fqTable.get("uddi-org:caseInsensitiveMatch".toUpperCase()) == null) continue;
                throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseInsensitiveMatch"));
            }
            if (!fq.equalsIgnoreCase("caseInsensitiveMatch") && !fq.equalsIgnoreCase("uddi-org:caseInsensitiveMatch") || fqTable.get("caseSensitiveMatch".toUpperCase()) == null && fqTable.get("uddi-org:caseSensitiveMatch".toUpperCase()) == null) continue;
            throw new InvalidCombinationException(new ErrorMessage("errors.findqualifiers.InvalidCombo", fq + " & " + "caseSensitiveMatch"));
        }
    }
}

