/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PostManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.organization;

import java.util.List;

import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PostManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.springframework.context.ApplicationContext;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class PostManagerImpl implements PostManager {

    private PostManager postManagerService;

    public PostManagerImpl(ApplicationContext context) {
        super();
        this.postManagerService = (PostManager) context.getBean("postManager");
    }

    public String createPost(PostTO arg0) throws OrganizationException {
        return postManagerService.createPost(arg0);
    }

    public List<PostTO> getAllPosts(RequestOptionsTO arg0) {
        return postManagerService.getAllPosts(arg0);
    }

    public List<PostTO> getPostsNotLinkedToOrganization(String arg0, RequestOptionsTO arg1)
            throws OrganizationException {
        return postManagerService.getPostsNotLinkedToOrganization(arg0, arg1);
    }

    public PostTO getPost(String arg0) throws OrganizationException {
        return postManagerService.getPost(arg0);
    }

    public void removePost(String arg0) {
        postManagerService.removePost(arg0);
    }

    public String updatePost(PostTO arg0) throws OrganizationException {
        return postManagerService.updatePost(arg0);
    }

}
