/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TechnologyManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.technology;

import java.util.List;

import org.ow2.dragon.api.service.technology.TechnologyException;
import org.ow2.dragon.api.service.technology.TechnologyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecEnvManagerSearchProperties;
import org.ow2.dragon.api.to.technology.ExecEnvSearchProperties;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.FederationSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.springframework.context.ApplicationContext;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class TechnologyManagerImpl implements TechnologyManager {

    private TechnologyManager technologyManager;

    public TechnologyManagerImpl(ApplicationContext context) {
        this.technologyManager = (TechnologyManager) context.getBean("technologyManager");
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.technology.TechnologyManager#addRuntimeManager
     * (java.lang.String)
     */
    public String addRuntimeManager(String arg0) throws TechnologyException {
        return technologyManager.addRuntimeManager(arg0);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.technology.TechnologyManager#getManagedExecEnv
     * (java.lang.String, org.ow2.dragon.api.to.RequestOptionsTO)
     */
    public List<ExecutionEnvironmentTO> getManagedExecEnv(String arg0, RequestOptionsTO arg1) {

        return technologyManager.getManagedExecEnv(arg0, arg1);
    }

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.api.service.technology.TechnologyManager#
     * synchronizeManagedExecEnv(java.lang.String)
     */
    public void synchronizeManagedExecEnv(String arg0) throws TechnologyException {
        technologyManager.synchronizeManagedExecEnv(arg0);

    }

    public ExecutionEnvironmentManagerTO getRuntimeManager(String arg0) {
        return technologyManager.getRuntimeManager(arg0);
    }

    public ExecutionEnvironmentTO getExecutionEnvironment(String execEnvId) {
        return technologyManager.getExecutionEnvironment(execEnvId);
    }

    public List<ExecutionEnvironmentManagerTO> getAllExecutionEnvironmentManagers(
            RequestOptionsTO arg0) {
        return technologyManager.getAllExecutionEnvironmentManagers(arg0);
    }

    public List<ExecutionEnvironmentManagerTO> searchExecutionEnvironmentManagers(String arg0,
            List<ExecEnvManagerSearchProperties> arg1, RequestOptionsTO arg2)
            throws TechnologyException {
        return technologyManager.searchExecutionEnvironmentManagers(arg0, arg1, arg2);
    }

    public List<ExecutionEnvironmentTO> getAllExecutionEnvironments(RequestOptionsTO arg0) {
        return technologyManager.getAllExecutionEnvironments(arg0);
    }

    public List<ExecutionEnvironmentTO> searchExecutionEnvironments(String arg0,
            List<ExecEnvSearchProperties> arg1, RequestOptionsTO arg2) throws TechnologyException {
        return technologyManager.searchExecutionEnvironments(arg0, arg1, arg2);
    }

    public List<EndpointTO> getEpsHostedOnExecEnv(String execEnvId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getEpsHostedOnExecEnv(execEnvId, requestOptionsTO);
    }

    public List<EndpointTO> getEpsHostedOnProcessor(String processorId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getEpsHostedOnProcessor(processorId, requestOptionsTO);
    }

    public List<ExecutionEnvironmentTO> getExecEnvsHostedOnProcessor(String processorId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getExecEnvsHostedOnProcessor(processorId, requestOptionsTO);
    }

    public ProcessorTO getProcessor(String processorId) {
        return technologyManager.getProcessor(processorId);
    }

    public List<ProcessorTO> getAllProcessors(RequestOptionsTO requestOptionsTO) {
        return technologyManager.getAllProcessors(requestOptionsTO);
    }

    public List<ProcessorTO> searchProcessors(String searchCriteria,
            List<ProcessorSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO)
            throws TechnologyException {
        return technologyManager.searchProcessors(searchCriteria, searchedProperties,
                requestOptionsTO);
    }

    public void removeExecutionEnvironment(String execEnvId) {
        technologyManager.removeExecutionEnvironment(execEnvId);
    }

    public void removeProcessor(String processorId) {
        technologyManager.removeProcessor(processorId);
    }

    public void removeRuntimeManager(String runtimeManagerId) {
        technologyManager.removeRuntimeManager(runtimeManagerId);
    }

    public EnvironmentFederationTO getEnvironmentFederation(String envFedId) {
        return technologyManager.getEnvironmentFederation(envFedId);
    }

    public List<ExecutionEnvironmentTO> getExecEnvsInFederation(String envFedId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getExecEnvsInFederation(envFedId, requestOptionsTO);
    }

    public void removeEnvironmentFederation(String envFedId) {
        technologyManager.removeEnvironmentFederation(envFedId);
    }

    public List<EnvironmentFederationTO> getAllEnvironmentFederations(
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getAllEnvironmentFederations(requestOptionsTO);
    }

    public List<EnvironmentFederationTO> searchEnvironmentFederations(String searchCriteria,
            List<FederationSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO)
            throws TechnologyException {
        return technologyManager.searchEnvironmentFederations(searchCriteria, searchedProperties,
                requestOptionsTO);
    }

}
