/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UDDIPublicationImpl.java
 * -------------------------------------------------------------------------
 */
package org.ow2.dragon.ui.businessdelegate.spring.uddi;

import org.springframework.context.ApplicationContext;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.AssertionStatusReport;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.GetAssertionStatusReport;
import org.uddi.api_v3.GetPublisherAssertions;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.PublisherAssertions;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.SetPublisherAssertions;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3_porttype.DispositionReportFaultMessage;
import org.uddi.api_v3_porttype.UDDIPublicationPortType;

/**
 * @author ofabre
 *
 */
public class UDDIPublicationImpl implements UDDIPublicationPortType {

    public UDDIPublicationPortType uddiPublication;
    
    public UDDIPublicationImpl(ApplicationContext context) {
        this.uddiPublication = (UDDIPublicationPortType) context.getBean("uddiPublicationServiceV3");
    }

    public void addPublisherAssertions(AddPublisherAssertions body)
            throws DispositionReportFaultMessage {
        uddiPublication.addPublisherAssertions(body);
    }

    public void deleteBinding(DeleteBinding body) throws DispositionReportFaultMessage {
        uddiPublication.deleteBinding(body);
    }

    public void deleteBusiness(DeleteBusiness body) throws DispositionReportFaultMessage {
        uddiPublication.deleteBusiness(body);
    }

    public void deletePublisherAssertions(DeletePublisherAssertions body)
            throws DispositionReportFaultMessage {
        uddiPublication.deletePublisherAssertions(body);
    }

    public void deleteService(DeleteService body) throws DispositionReportFaultMessage {
        uddiPublication.deleteService(body);
    }

    public void deleteTModel(DeleteTModel body) throws DispositionReportFaultMessage {
        uddiPublication.deleteTModel(body);
    }

    public AssertionStatusReport getAssertionStatusReport(GetAssertionStatusReport body)
            throws DispositionReportFaultMessage {
        return uddiPublication.getAssertionStatusReport(body);
    }

    public PublisherAssertions getPublisherAssertions(GetPublisherAssertions body)
            throws DispositionReportFaultMessage {
        return uddiPublication.getPublisherAssertions(body);
    }

    public RegisteredInfo getRegisteredInfo(GetRegisteredInfo body)
            throws DispositionReportFaultMessage {
        return uddiPublication.getRegisteredInfo(body);
    }

    public BindingDetail saveBinding(SaveBinding body) throws DispositionReportFaultMessage {
        return uddiPublication.saveBinding(body);
    }

    public BusinessDetail saveBusiness(SaveBusiness body) throws DispositionReportFaultMessage {
        return uddiPublication.saveBusiness(body);
    }

    public ServiceDetail saveService(SaveService body) throws DispositionReportFaultMessage {
        return uddiPublication.saveService(body);
    }

    public TModelDetail saveTModel(SaveTModel body) throws DispositionReportFaultMessage {
        return uddiPublication.saveTModel(body);
    }

    public PublisherAssertions setPublisherAssertions(SetPublisherAssertions body)
            throws DispositionReportFaultMessage {
        return uddiPublication.setPublisherAssertions(body);
    }
    
 

}
