/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ListOfCountriesBean2.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.organization;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;

/**
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class ListOfCountriesBean2 {

    private String[][] codeAndName;

    public void load(Locale userLocale) {

        // --- 1: retrieve list
        String[] codes = Locale.getISOCountries();
        codeAndName = new String[codes.length][2];
        for (int i = 0; i < codes.length; i++) {
            codeAndName[i][0] = codes[i];
            Locale l = new Locale("en", codes[i]);
            codeAndName[i][1] = l.getDisplayCountry(userLocale);
        }

        // --- 2: sort
        Arrays.sort(codeAndName, new Comparator<String[]>() {
            public int compare(String[] o1, String[] o2) {
                return o1[1].compareTo(o2[1]);
            }
        });
    }

    public String[][] getCountries() {
        return codeAndName;
    }
}
