/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ListOfAgreementsBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.deployment.EndpointBean;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.AgreementTemplate;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle.State;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class AgreementProviderBoardBean {

	private Logger logger = Logger.getLogger(this.getClass());

	// ==========================================================
	// === Attributes
	// ==========================================================
	private List<ManagedAgreementBean> agreementTemplates = new ArrayList<ManagedAgreementBean>();

	private List<ManagedAgreementBean> submittedAgreements = new ArrayList<ManagedAgreementBean>();
	
	private List<ManagedAgreementBean> observedAgreements = new ArrayList<ManagedAgreementBean>();
	
	private List<ManagedAgreementBean> terminatedAgreements = new ArrayList<ManagedAgreementBean>();


	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads all organizations from the database
	 */
	public void load(HttpServletRequest iRequest) throws LocalizedError {
		try {
			agreementTemplates = new ArrayList<ManagedAgreementBean>();
			submittedAgreements = new ArrayList<ManagedAgreementBean>();
			observedAgreements = new ArrayList<ManagedAgreementBean>();
			terminatedAgreements = new ArrayList<ManagedAgreementBean>();

			EndpointBean ep = new EndpointBean();
			ep.load(iRequest);

			for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager()
					.getAllManagedAgreements(null)) {
				if((agTO.getAgreement().getContext().getResponder().getAddress().equals(ep.getName()))&&
						(agTO.getAgreement() instanceof AgreementTemplate)){
					agreementTemplates.add(new ManagedAgreementBean(agTO));
				}
				
				if((agTO.getAgreement().getContext().getResponder().getAddress().equals(ep.getName()))&&
						(agTO.getAgreement() instanceof AgreementLifeCycle)){
					if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.PENDING)) {
						submittedAgreements.add(new ManagedAgreementBean(agTO));
					} else if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.OBSERVE)) {
						observedAgreements.add(new ManagedAgreementBean(agTO));
					} else if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.REJECTE)) {
						terminatedAgreements.add(new ManagedAgreementBean(agTO));
					} else if(((AgreementLifeCycle)agTO.getAgreement()).getState().equals(State.TERMINATE)) {
						terminatedAgreements.add(new ManagedAgreementBean(agTO));
					} 
				}

			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
		}
	}

	public List<ManagedAgreementBean> getAllAgreementsTemplateOfEndpoint(EndpointBean ep) throws LocalizedError {
		List<ManagedAgreementBean> res = new ArrayList<ManagedAgreementBean>();
		try {
			// TODO: create the corresponding search methods
			for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager()
					.getAllManagedAgreements(null)) {
				if((agTO.getAgreement().getContext().getResponder().getAddress().equals(ep.getName()))&&
						(agTO.getAgreement() instanceof AgreementTemplate)) {
					res.add(new ManagedAgreementBean(agTO));
				}

			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
		}
		return res;
	}


	public ManagedAgreementBean getAgreementTemplateByName(EndpointBean ep, String name) throws LocalizedError {
		ManagedAgreementBean res = null;
		try {
			// TODO: create the corresponding search methods
			for (ManagedAgreementTO agTO : DragonServiceFactory.getInstance().getSLAManager()
					.getAllManagedAgreements(null)) {
				if((agTO.getAgreement().getContext().getResponder().getAddress().equals(ep.getName()))&&
						(agTO.getAgreement() instanceof AgreementTemplate)&&
						(agTO.getAgreement().getName().equals(name))) {
					res = new ManagedAgreementBean(agTO);
					break;
				}

			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
		}
		return res;
	}

	public void reset() {

	}

	public List<ManagedAgreementBean> getAgreementTemplates() {
		return agreementTemplates;
	}

	public void setAgreementTemplates(List<ManagedAgreementBean> agreementTemplates) {
		this.agreementTemplates = agreementTemplates;
	}

	public List<ManagedAgreementBean> getSubmittedAgreements() {
		return submittedAgreements;
	}

	public void setSubmittedAgreements(
			List<ManagedAgreementBean> submittedAgreements) {
		this.submittedAgreements = submittedAgreements;
	}

	public List<ManagedAgreementBean> getObservedAgreements() {
		return observedAgreements;
	}

	public void setObservedAgreements(List<ManagedAgreementBean> observedAgreements) {
		this.observedAgreements = observedAgreements;
	}

	public List<ManagedAgreementBean> getTerminatedAgreements() {
		return terminatedAgreements;
	}

	public void setTerminatedAgreements(
			List<ManagedAgreementBean> terminatedAgreements) {
		this.terminatedAgreements = terminatedAgreements;
	}

}
