/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * BusinessValueBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.BusinessValueList;
import com.ebmwebsourcing.agreement.definition.api.Compensation;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class BusinessValueBean {

	private Logger logger = Logger.getLogger(this.getClass());

	// ==========================================================
	// === Attributes
	// ==========================================================
	private BusinessValueList bvTO;

	private ManagedAgreementBean mab;

	private GuaranteeBean gb;

	private int importance;

	private List<CompensationBean> penalties = new ArrayList<CompensationBean>();

	private List<CompensationBean> rewards = new ArrayList<CompensationBean>();


	/**
	 * Constructor
	 */
	public BusinessValueBean() {
	}



	private List<CompensationBean> initCompensationBean(List<Compensation> compsTO, String compensationType) throws LocalizedError {
		List<CompensationBean> res = new ArrayList<CompensationBean>();
		int i = 0;
		for (Compensation compTO : compsTO) {
			res.add(new CompensationBean(i, compTO, this, this.mab, compensationType));
			i++;
		}
		return res;
	}

	// ==========================================================
	// === Control Methods
	// ==========================================================


	public String save() throws LocalizedError {
		try {
			bvTO.setImportance(importance);
			for (CompensationBean bean : penalties) {
				bean.save();
			}
			for (CompensationBean bean : rewards) {
				bean.save();
			}

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
		}

		return "success";
	}

	/**
	 * Resets changes made to the current endpoint attributes.
	 * @throws LocalizedError 
	 */
	public void reset() throws LocalizedError {
		if (bvTO != null) {
			if(bvTO.getImportance() != null) {
				this.importance = bvTO.getImportance();
			} else {
				this.importance = 0;
			}
			
			if(this.bvTO != null) {
				penalties = initCompensationBean((List)this.bvTO.getPenalties(), "penalty");
				rewards = initCompensationBean((List)this.bvTO.getRewards(), "reward");
			}
		} else {
			this.importance = 0;
			this.penalties.clear();
			this.rewards.clear();
		}
	}

	/**
	 * @return the importance
	 */
	public int getImportance() {
		return importance;
	}

	/**
	 * @param importance
	 *            the importance to set
	 */
	public void setImportance(int importance) {
		this.importance = importance;
	}

	/**
	 * @return the penalties
	 */
	public List<CompensationBean> getPenalties() {
		return penalties;
	}

	/**
	 * @param penalties
	 *            the penalties to set
	 */
	public void setPenalties(List<CompensationBean> penalties) {
		this.penalties = penalties;
	}

	/**
	 * @return the rewards
	 */
	public List<CompensationBean> getRewards() {
		return rewards;
	}

	/**
	 * @param rewards
	 *            the rewards to set
	 */
	public void setRewards(List<CompensationBean> rewards) {
		this.rewards = rewards;
	}

	/**
	 * @return the bvTO
	 */
	public BusinessValueList getBvTO() {
		return bvTO;
	}

	/**
	 * @param bvTO
	 *            the bvTO to set
	 */
	public void setBvTO(BusinessValueList bvTO) {
		this.bvTO = bvTO;
	}

	public ManagedAgreementBean getMab() {
		return mab;
	}

	public void setMab(ManagedAgreementBean mab) {
		this.mab = mab;
	}

	public GuaranteeBean getGb() {
		return gb;
	}

	public void setGb(GuaranteeBean gb) {
		this.gb = gb;
	}

}
