/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * QualifyingConditionBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.QualifyingCondition;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class QualifyingConditionBean {

	private Logger logger = Logger.getLogger(this.getClass());
	
	// ==========================================================
	// === Attributes
	// ==========================================================
	private QualifyingCondition qcTO;

	private ManagedAgreementBean mab;

	private GuaranteeBean gb;

	private String expression;

	private String language;


	/**
	 * @return the expression
	 */
	public String getExpression() {
		return expression;
	}

	/**
	 * @param expression
	 *            the expression to set
	 */
	public void setExpression(String expression) {
		this.expression = expression;
	}

	/**
	 * @return the language
	 */
	public String getLanguage() {
		return language;
	}

	/**
	 * @param language
	 *            the language to set
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	/**
	 * @return the qcTO
	 */
	public QualifyingCondition getQcTO() {
		return qcTO;
	}

	/**
	 * Default constructor
	 * 
	 */
	public QualifyingConditionBean() {
	}

	/**
	 * Constructor
	 */
	public QualifyingConditionBean(QualifyingCondition qcTO, GuaranteeBean gb, ManagedAgreementBean mab) {
		this.qcTO = qcTO;
		this.mab = mab;
		this.gb = gb;
		reset();
	}

	// ==========================================================
	// === Control Methods
	// ==========================================================


	public String save() throws LocalizedError {

		this.qcTO.getExpression().setValue(this.expression);
		this.qcTO.getExpression().setExpressionLanguage(this.language);
		
		return "success";
	}


	/**
	 * Resets changes made to the current endpoint attributes.
	 */
	public void reset() {
		if ((qcTO != null)&&(qcTO.getExpression() != null)) {
			this.expression = qcTO.getExpression().getValue();
			this.language = qcTO.getExpression().getExpressionLanguage();
		} else {
			this.expression = null;
			this.language = null;
		}
	}

	public void setQcTO(QualifyingCondition qcTO) {
		this.qcTO = qcTO;
	}

	public ManagedAgreementBean getMab() {
		return mab;
	}

	public void setMab(ManagedAgreementBean mab) {
		this.mab = mab;
	}

	public GuaranteeBean getGb() {
		return gb;
	}

	public void setGb(GuaranteeBean gb) {
		this.gb = gb;
	}


}
