/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceLevelObjectiveBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.ServiceLevelObjective;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class ServiceLevelObjectiveBean {

	private Logger logger = Logger.getLogger(this.getClass());

	// ==========================================================
	// === Attributes
	// ==========================================================
	private ServiceLevelObjective sloTO;

	private ManagedAgreementBean mab;

	private GuaranteeBean gb;

	private String kpiName;

	private int value;

	private String unit;

	private String unit_semantic_concept;

	private String type;

	private String type_semantic_concept;

	private String operator;


	/**
	 * @return the kpiName
	 */
	public String getKpiName() {
		return kpiName;
	}

	/**
	 * @param kpiName
	 *            the kpiName to set
	 */
	public void setKpiName(String kpiName) {
		this.kpiName = kpiName;
	}

	/**
	 * @return the value
	 */
	public int getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(int value) {
		this.value = value;
	}

	/**
	 * Constructor
	 */
	public ServiceLevelObjectiveBean() {
	}

	public ServiceLevelObjectiveBean(ServiceLevelObjective slo, GuaranteeBean gb, ManagedAgreementBean mab) {
		this.sloTO = slo;
		this.mab = mab;
		reset();
	}

	// ==========================================================
	// === Control Methods
	// ==========================================================


	public String save() throws LocalizedError {
		setServiceLevelObjectiveTO();

		return "success";
	}

	public void setServiceLevelObjectiveTO() {
		if (sloTO != null) {
			this.sloTO.getKPITarget().setKPIName(this.kpiName);
			if(this.sloTO.getKPITarget().getConstraint() != null) {
				this.sloTO.getKPITarget().getConstraint().setOperator(this.operator);
				if(this.sloTO.getKPITarget().getConstraint().getValue() != null) {
					this.sloTO.getKPITarget().getConstraint().getValue().setValue(Float.valueOf(this.value));
					if(this.sloTO.getKPITarget().getConstraint().getValue().getUnit() != null) {
						this.sloTO.getKPITarget().getConstraint().getValue().getUnit().setName(this.unit);
						this.sloTO.getKPITarget().getConstraint().getValue().getUnit().setSemanticConcept(this.unit_semantic_concept);
					}
					if(this.sloTO.getKPITarget().getConstraint().getValue().getType() != null) {
						this.sloTO.getKPITarget().getConstraint().getValue().getType().setName(this.type);
						this.sloTO.getKPITarget().getConstraint().getValue().getType().setSemanticConcept(this.type_semantic_concept);
					}
				}
			}
		}
	}


	/**
	 * Resets changes made to the current endpoint attributes.
	 */
	public void reset() {
		if (sloTO != null) {
			this.kpiName = sloTO.getKPITarget().getKPIName();
			if(this.sloTO.getKPITarget().getConstraint() != null) {
				this.operator = this.sloTO.getKPITarget().getConstraint().getOperator();
				if(this.sloTO.getKPITarget().getConstraint().getValue() != null) {
					if(this.sloTO.getKPITarget().getConstraint().getValue().getValue() != null) {
						this.value = this.sloTO.getKPITarget().getConstraint().getValue().getValue().intValue();
					} else {
						this.value = 0;
					}
					if(this.sloTO.getKPITarget().getConstraint().getValue().getUnit() != null) {
						this.unit = this.sloTO.getKPITarget().getConstraint().getValue().getUnit().getName();
						this.unit_semantic_concept = this.sloTO.getKPITarget().getConstraint().getValue().getUnit().getSemanticConcept();
					}
					if(this.sloTO.getKPITarget().getConstraint().getValue().getType() != null) {
						this.type = this.sloTO.getKPITarget().getConstraint().getValue().getType().getName();
						this.type_semantic_concept = this.sloTO.getKPITarget().getConstraint().getValue().getType().getSemanticConcept();
					}
				}
			}
		} else {
			this.kpiName = null;
			this.operator = null;
			this.value = 0;
			this.unit = null;
			this.unit_semantic_concept = null;
			this.type = null;
			this.type_semantic_concept = null;
		}
	}

	/**
	 * @return the sloTO
	 */
	public ServiceLevelObjective getSloTO() {
		return sloTO;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getUnit_semantic_concept() {
		return unit_semantic_concept;
	}

	public void setUnit_semantic_concept(String unit_semantic_concept) {
		this.unit_semantic_concept = unit_semantic_concept;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getType_semantic_concept() {
		return type_semantic_concept;
	}

	public void setType_semantic_concept(String type_semantic_concept) {
		this.type_semantic_concept = type_semantic_concept;
	}

	public void setSloTO(ServiceLevelObjective sloTO) {
		this.sloTO = sloTO;
	}

	public ManagedAgreementBean getMab() {
		return mab;
	}

	public void setMab(ManagedAgreementBean mab) {
		this.mab = mab;
	}

	public GuaranteeBean getGb() {
		return gb;
	}

	public void setGb(GuaranteeBean gb) {
		this.gb = gb;
	}

}
