/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServicePropertiesBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.agreement.definition.api.ServiceProperties;
import com.ebmwebsourcing.agreement.definition.api.Variable;

/**
 * 
 * @author nsaladge - eBM Websourcing
 * 
 */
public class ServicePropertiesBean {

	private Logger logger = Logger.getLogger(this.getClass());

	// ==========================================================
	// === Attributes
	// ==========================================================
	private ServiceProperties spTO;

	private ManagedAgreementBean mab;

	private String name;

	private String serviceName;

	private List<MetricBean> metrics;

	public ServicePropertiesBean() {

	}

	// ==========================================================
	// === Control Methods
	// ==========================================================
	/**
	 * Loads a technical service from the request parameter 'id'.
	 * @throws LocalizedError 
	 */
	public ServicePropertiesBean(ServiceProperties spTO, ManagedAgreementBean mab) throws LocalizedError {
		this.spTO = spTO;
		this.mab = mab;

		metrics = new ArrayList<MetricBean>();
		if (this.spTO != null) {
			for (Variable metric : this.spTO.getVariables()) {
				metrics.add(new MetricBean(metric, mab));
			}
		}
		reset();
	}

	public String save() throws LocalizedError {

		spTO.setName(this.name);
		spTO.setServiceName(this.serviceName);

		if(metrics != null) {
			for (MetricBean metric : metrics) {
				this.spTO.getVariables().add(metric.getVariable());
			}
		}

		return "success";
	}

	/**
	 * Resets changes made to the current endpoint attributes.
	 * @throws LocalizedError 
	 */
	public void reset() throws LocalizedError {
		if (spTO != null) {
			this.name = spTO.getName();
			this.serviceName = spTO.getServiceName();
			if(this.metrics != null) {
				for (MetricBean m : metrics) {
					m.reset();
				}
			}
		}
	}


	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	public List<MetricBean> getMetrics() {
		if (metrics == null) {
			metrics = new ArrayList<MetricBean>();
		}
		return metrics;
	}

	/**
	 * @return the spTO
	 */
	public ServiceProperties getSpTO() {
		return spTO;
	}

	/**
	 * @param spTO
	 *            the spTO to set
	 */
	public void setSpTO(ServiceProperties spTO) {
		this.spTO = spTO;
	}

	public ManagedAgreementBean getMab() {
		return mab;
	}

	public void setMab(ManagedAgreementBean mab) {
		this.mab = mab;
	}

}
