/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ProcessorBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class ProcessorBean {

    private Logger logger = Logger.getLogger(this.getClass());

    private ProcessorTO processorTO;

    private List<ExecutionEnvironmentTO> hostedExecEnvs;

    private List<EndpointTO> hostedEps;

    private String processorId;

    private String name;

    private String ipv4Address;

    public String load(HttpServletRequest request) throws LocalizedError {

        String id = request.getParameter("processorId");

        // Load Runtime manager
        loadProcessor(id);

        // Load processor hosted exec envs
        loadExecEnvs(id);

        // Load processor hosted eps
        loadHostedEps(id);

        reset();
        return "success";
    }

    private void loadExecEnvs(String id) throws LocalizedError {
        // sort ascendingly on name
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        try {
            hostedExecEnvs = DragonServiceFactory.getInstance().getTechnologyManager()
                    .getExecEnvsHostedOnProcessor(id, requestOptionsTO);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    private void loadHostedEps(String id) throws LocalizedError {
        // sort ascendingly on name
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.ENDPOINT_NAME);
        try {
            hostedEps = DragonServiceFactory.getInstance().getTechnologyManager()
                    .getEpsHostedOnProcessor(id, requestOptionsTO);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

    }

    private void loadProcessor(String id) throws LocalizedError {
        try {
            processorTO = DragonServiceFactory.getInstance().getTechnologyManager()
                    .getProcessor(id);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public void reset() {
        if (processorTO != null) {
            this.ipv4Address = processorTO.getIpv4Address();
            this.name = processorTO.getName();
            this.processorId = processorTO.getNodeId();
        }
    }

    public void save() {

    }

    public void validate() {

    }

    public void delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().removeProcessor(
                    processorTO.getNodeId());
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIpv4Address() {
        return ipv4Address;
    }

    public void setIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public List<EndpointTO> getHostedEps() {
        return hostedEps;
    }

    public void setHostedEps(List<EndpointTO> hostedEps) {
        this.hostedEps = hostedEps;
    }

    public ProcessorTO getProcessorTO() {
        return processorTO;
    }

    public void setProcessorTO(ProcessorTO processorTO) {
        this.processorTO = processorTO;
    }

    public List<ExecutionEnvironmentTO> getHostedExecEnvs() {
        return hostedExecEnvs;
    }

    public void setHostedExecEnvs(List<ExecutionEnvironmentTO> hostedExecEnvs) {
        this.hostedExecEnvs = hostedExecEnvs;
    }

    public String getProcessorId() {
        return processorId;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
    }

}
