/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RuntimeManagerBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.technology.TechnologyException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class RuntimeManagerBean {

    private Logger logger = Logger.getLogger(this.getClass());

    private ExecutionEnvironmentManagerTO execEnvManagerTO;

    private String runtimeManagerId;

    private String name;

    private String address;

    private List<ExecutionEnvironmentTO> execEnvs;

    public String load(HttpServletRequest request) throws LocalizedError {

        String id = request.getParameter("runtimeManagerId");

        // Load Runtime manager
        loadRuntimeManager(id);

        // Loas Runtime manager exec envs
        loadExecEnvs(id);

        reset();
        return "success";
    }

    public void loadRuntimeManager(String id) throws LocalizedError {
        try {
            execEnvManagerTO = DragonServiceFactory.getInstance().getTechnologyManager()
                    .getRuntimeManager(id);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

    }

    public void loadExecEnvs(String id) throws LocalizedError {
        // sort ascendingly on name
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        try {
            execEnvs = DragonServiceFactory.getInstance().getTechnologyManager().getManagedExecEnv(
                    id, requestOptionsTO);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

    }

    public void reset() {
        if (execEnvManagerTO != null) {
            this.address = execEnvManagerTO.getAddress();
            this.name = execEnvManagerTO.getName();
            this.runtimeManagerId = execEnvManagerTO.getExecEnvManagerId();
        }
    }

    public void save() {

    }

    public void validate() {

    }

    public void delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().removeRuntimeManager(
                    execEnvManagerTO.getExecEnvManagerId());
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public String synchronizeExecEnvs() throws LocalizedError {
        // Synchronize
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().synchronizeManagedExecEnv(
                    runtimeManagerId);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        } catch (TechnologyException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

        // Reload list of exec envs
        loadExecEnvs(runtimeManagerId);

        return "success";
    }

    public String getRuntimeManagerId() {
        return runtimeManagerId;
    }

    public void setRuntimeManagerId(String runtimeManagerId) {
        this.runtimeManagerId = runtimeManagerId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<ExecutionEnvironmentTO> getExecEnvs() {
        return execEnvs;
    }

    public void setExecEnvs(List<ExecutionEnvironmentTO> execEnvs) {
        this.execEnvs = execEnvs;
    }

}
