/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOrgIdentifierBean {
    private Logger logger = Logger.getLogger(AddOrgIdentifierBean.class);
    private String identifierId;
    private String identifierValue;
    private String identifierDesc;
    private List<IdentifierTO> identifiers = new ArrayList();

    public void loadOrganizationIdentifiers() throws LocalizedError {
        try {
            this.identifiers = DragonServiceFactory.getInstance().getTModelManager().loadOrganizationIdentifierSystems();
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String addIdentifierToOrg(String orgId) throws IError {
        try {
            DragonServiceFactory.getInstance().getOrganizationManager().addIdentifier(orgId, this.identifierId, this.identifierValue, this.identifierDesc);
        }
        catch (OrganizationException e) {
            NonLocalizedError error = new NonLocalizedError("Can't add identifier to organization.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String getIdentifierId() {
        return this.identifierId;
    }

    public void setIdentifierId(String identifierId) {
        this.identifierId = identifierId;
    }

    public String getIdentifierValue() {
        return this.identifierValue;
    }

    public void setIdentifierValue(String identifierValue) {
        this.identifierValue = identifierValue;
    }

    public String getIdentifierDesc() {
        return this.identifierDesc;
    }

    public void setIdentifierDesc(String identifierDesc) {
        this.identifierDesc = identifierDesc;
    }

    public List<IdentifierTO> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<IdentifierTO> identifiers) {
        this.identifiers = identifiers;
    }
}

