/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfPostsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<PostTO> posts;
    private List<PostTO> freePosts;
    private List<PostTO> orgPosts;
    private String searchCriteria;
    private boolean isSearchOnName;
    private boolean isSearchOnNature;
    private boolean isSearchOnDescription;

    public void loadAll() throws LocalizedError {
        try {
            this.posts = DragonServiceFactory.getInstance().getPostManager().getAllPosts(this.createSortOption(SortCriteria.POST_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadByOrganization(String orgId) throws LocalizedError {
        try {
            this.posts = DragonServiceFactory.getInstance().getOrganizationManager().getPostsByOrganization(orgId, this.createSortOption(SortCriteria.POST_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadFree(HttpServletRequest request) throws LocalizedError {
        String orgId = request.getParameter("organizationId");
        try {
            this.posts = DragonServiceFactory.getInstance().getPostManager().getPostsNotLinkedToOrganization(orgId, this.createSortOption(SortCriteria.POST_NAME, true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public List<PostTO> getPostsToAdd() {
        ArrayList<PostTO> postsToAdd = new ArrayList();
        if (this.posts != null && !this.posts.isEmpty()) {
            postsToAdd = this.posts;
        } else {
            PostTO emptyPost = new PostTO();
            emptyPost.setId("");
            emptyPost.setName("No post to add");
            postsToAdd.add(emptyPost);
        }
        return postsToAdd;
    }

    public void noOrgSelected() {
        PostTO emptyPost = new PostTO();
        emptyPost.setName("Select an org first");
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        result.add(emptyPost);
        this.posts = result;
    }

    private RequestOptionsTO createSortOption(SortCriteria sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public List<PostTO> getPosts() {
        return this.posts;
    }

    public List<PostTO> getFreePosts() {
        return this.freePosts;
    }

    public List<PostTO> getOrgPosts() {
        return this.orgPosts;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public boolean getIsSearchOnName() {
        return this.isSearchOnName;
    }

    public void setIsSearchOnName(boolean isSearchOnName) {
        this.isSearchOnName = isSearchOnName;
    }

    public boolean getIsSearchOnNature() {
        return this.isSearchOnNature;
    }

    public void setIsSearchOnNature(boolean isSearchOnNature) {
        this.isSearchOnNature = isSearchOnNature;
    }

    public boolean getIsSearchOnDescription() {
        return this.isSearchOnDescription;
    }

    public void setIsSearchOnDescription(boolean isSearchOnDescription) {
        this.isSearchOnDescription = isSearchOnDescription;
    }
}

