/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CodeSnippetField.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.bricks;

import java.io.PrintWriter;
import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.util.HtmlUtils;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.base.html.IView;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;

@XmlDoc("A code snippet area.<br/>The binding type is expected to be <code>java.lang.String</code>.")
@XmlElement
public class CodeSnippet implements IView, IInitializable {
    @XmlDoc("Must display gutter. Default: true.")
    @XmlAttribute(name = "Gutter", required = false)
    private boolean gutter = true;

    @XmlDoc("Must display controls at the top. Default: true.")
    @XmlAttribute(name = "Controls", required = false)
    private boolean controls = true;

    @XmlDoc("Will collapse the block by default. Default: false.")
    @XmlAttribute(name = "Collapse", required = false)
    private boolean collapse = false;

    @XmlDoc("Code style to display. Possible values: xml, html, xhtml, xslt, java, js, jscript, javascript, css, sql, vb, vb.net, cpp, c, c++, c#, c-sharp, csharp, rb, ruby, rails, ror, py, python. Default: xml.")
    @XmlAttribute(name = "CodeStyle", required = true)
    private String codeStyle = "xml";

    @XmlDoc("Declares the binding to get the text code to display.")
    @XmlChild(name = "TextCode", required = true)
    private Expression textCode;

    /*
     * public Class getBaseType() { return String.class; }
     */
    public void initialize(IInitializationSupport initSupport, Object additionalSupport) {
        if (initSupport.initialize(textCode)) {
            Class<?> type = String.class;

            // --- check binding type
            if (!type.isAssignableFrom(textCode.getType()))
                initSupport.addValidationMessage(this, "Bind", IInitializationSupport.ERROR,
                        "Expression " + textCode + " has invalid type (" + textCode.getType()
                                + "): String expected.");
        }
    }

    public Type getValueGenericType() {
        return getValueType();
    }

    public Class<?> getValueType() {
        return String.class;
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
    }

    private static String encodeTextarea(String text) {
        int nbChars = text.length();
        StringBuffer sb = new StringBuffer(nbChars);
        for (int i = 0; i < nbChars; i++) {
            char c = text.charAt(i);
            switch (c) {
                /*
                 * case '\n': // \n turned into <br> sb.append("<br>"); break;
                 * case '\r': // \r turned into braking whitespace
                 * sb.append(" "); break; case '\t': // TAB is turned into 4
                 * non-braking spaces sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                 * break;
                 */
                case '<':
                    sb.append("&lt;");
                    break;
                case '>':
                    sb.append("&gt;");
                    break;
                /*
                 * case '\"': sb.append("&quot;"); break;
                 */
                default:
                    sb.append(c);
                    break;
            }
        }
        return sb.toString();
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();

        // --- Only display: retrieve value from the bean
        String val = (String) textCode.invoke(iRequest);

        if (val == null)
            // --- empty initialization
            // TODO: default value ?
            val = "";

        iWriter.print("<pre");
        iWriter.print(" name='code'");
        iWriter.print(" class='");
        iWriter.print(codeStyle);
        if (!gutter){
            iWriter.print(":nogutter");
        }
        if (!controls){
            iWriter.print(":nocontrols");
        }
        if (collapse){
            iWriter.print(":collapse");
        }
        iWriter.print("'");
        iWriter.print(">");
        iWriter.print(encodeTextarea(val));
        iWriter.print("</pre>");

        /*
         * BricksUrlBuilder jsUrl = BricksUrlBuilder.createResourceUrl(iRequest,
         * "org/ow2/dragon/ui/js/shCore.js", null);
         * iWriter.println("<script language='javascript' src='");
         * iWriter.println(jsUrl.toUrl(iResponse.getCharacterEncoding(), true));
         * iWriter.println("'></script>");
         * 
         * jsUrl = BricksUrlBuilder.createResourceUrl(iRequest,
         * "org/ow2/dragon/ui/js/shBrushCSharp.js", null);
         * iWriter.println("<script language='javascript' src='");
         * iWriter.println(jsUrl.toUrl(iResponse.getCharacterEncoding(), true));
         * iWriter.println("'></script>");
         * 
         * jsUrl = BricksUrlBuilder.createResourceUrl(iRequest,
         * "org/ow2/dragon/ui/js/shBrushXml.js", null);
         * iWriter.println("<script language='javascript' src='");
         * iWriter.println(jsUrl.toUrl(iResponse.getCharacterEncoding(), true));
         * iWriter.println("'></script>");
         */

        // Include needed js
        HtmlUtils.includeJavaScript(iRequest, iResponse, "org/ow2/dragon/ui/js/shCore.js");
        HtmlUtils.includeJavaScript(iRequest, iResponse, "org/ow2/dragon/ui/js/shBrushXml.js");
        iWriter.println("<script language='javascript'>");
        iWriter.println("dp.SyntaxHighlighter.ClipboardSwf = '/flash/clipboard.swf';");
        iWriter.println("dp.SyntaxHighlighter.HighlightAll('code');");
        iWriter.println("</script>");

    }
}
