/**
 * Open SUIT - Simple User Interface Toolkit
 * 
 * Copyright (c) 2009 France Telecom, http://www.francetelecom.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ow2.dragon.ui.bricks;

import java.io.PrintWriter;
import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.expression.ExpressionUtils;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.base.html.table.BaseColumn;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext.ColumnDef;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;

/**
 * @author atiar (Abderrahmane TIAR)
 * @version 1.0
 */

@XmlDoc("A table column that displays rating in 5 stars format.")
@XmlElement
public class RatingColumn extends BaseColumn implements IInitializable
{   
    @XmlDoc("The value used to display the cell in stars format.<br>" +
            "Supported contextual beans: $row")
    @XmlChild(name="Value", required=false)
    private Expression value;
    
    @Override
    public void initialize(IInitializationSupport initSupport, Object additionalSupport)
    {
        super.initialize(initSupport, additionalSupport);
        
        if(value == null)
            initSupport.addValidationMessage(this, "Value", IInitializationSupport.ERROR, "'Value' is required.");

    }
    public Object getCellDisplayedContent(HttpServletRequest iRequest, Object iRowObject) throws Exception
    {
        if(value != null)
            return ExpressionUtils.getMessage(value, iRequest);
        return null; 
    }
    @Override
    public void renderCellContent(HttpServletRequest request, HttpServletResponse response, TableRenderingContext context, ColumnDef column, int icol, Object rowObject) throws Exception
    {
        PrintWriter writer = response.getWriter();
        String sText = ExpressionUtils.getMessage(value, request);
        
        String textHtml ;
        
        if (sText == null || sText.length() == 0) {
            textHtml = "&nbsp;" ;
            
        } else {
            int nbPixels =  (int)(17*Float.parseFloat(sText)) ; // a star is 17 pixels width.
            textHtml = "<div id=\"star\">" +
            		"<ul id=\"star0\" class=\"star_column\">" +
            		"<li id=\"starCur0\" class=\"curr\" style=\"width: "+nbPixels+"px;\"></li>" +
            		"</ul>" +
            		"</div>" ;        
        }
            // --- render cell as global rating       
            writer.print(textHtml);   
    }
    
    public Object getCellValue(HttpServletRequest iRequest, Object iRowObject) throws Exception
    {
        return ExpressionUtils.getMessage(value, iRequest);
    }
    public Class<?> getCellValueType()
    {
       return String.class ;
    }
    public Type getCellValueGenericType()
    {
        return String.class;
    }
}