/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * DragonServiceManager.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.factory;

import javax.servlet.ServletContext;

import org.ow2.dragon.api.service.common.TModelManager;
import org.ow2.dragon.api.service.dataloader.DataLoader;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.organization.OrganizationManager;
import org.ow2.dragon.api.service.organization.PartyManager;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.service.organization.PostManager;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.service.sla.SLAManager;
import org.ow2.dragon.api.service.technology.TechnologyManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.uddi.api_v3_porttype.UDDIPublicationPortType;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public interface DragonServiceManager {

    public void init(ServletContext servletContext);

    public OrganizationManager getOrganizationManager();

    public PostManager getPostManager();

    public PersonManager getPersonManager();

    public PartyManager getPartyManager();

    public RoleOfPartyManager getRoleOfPartyManager();

    public TechServiceManager getTechServiceManager();

    public EndpointManager getEndpointManager();

    public WSDLManager getWSDLImporter();

    public SLAManager getSLAManager();

    public TechnologyManager getTechnologyManager();

    public DataLoader getDataLoader();

    public MetadataService getMetadataService();

    public UDDIPublicationPortType getUDDIPublicationService();

    public TModelManager getTModelManager();

}
