/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * DragonServiceManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring;

import javax.servlet.ServletContext;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.common.TModelManager;
import org.ow2.dragon.api.service.dataloader.DataLoader;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.organization.OrganizationManager;
import org.ow2.dragon.api.service.organization.PartyManager;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.service.organization.PostManager;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.service.sla.SLAManager;
import org.ow2.dragon.api.service.technology.TechnologyManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceManager;
import org.ow2.dragon.ui.businessdelegate.spring.common.TModelManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.dataloader.DataLoaderImpl;
import org.ow2.dragon.ui.businessdelegate.spring.deployment.EndpointManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.deployment.TechServiceManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.metadata.MetadataServiceImpl;
import org.ow2.dragon.ui.businessdelegate.spring.organization.OrganizationManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.organization.PartyManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.organization.PersonManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.organization.PostManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.organization.RoleOfPartyManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.sla.SLAManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.technology.TechnologyManagerImpl;
import org.ow2.dragon.ui.businessdelegate.spring.uddi.UDDIPublicationImpl;
import org.ow2.dragon.ui.businessdelegate.spring.wsdl.WSDLManagerImpl;
import org.ow2.dragon.util.SpringUtil;
import org.springframework.context.ApplicationContext;
import org.uddi.api_v3_porttype.UDDIPublicationPortType;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class DragonServiceManagerImpl implements DragonServiceManager {

    private Logger logger = Logger.getLogger(this.getClass());

    private OrganizationManager organizationManager;

    private PersonManager personManager;

    private PartyManager partyManager;

    private PostManager postManager;

    private RoleOfPartyManager roleOfPartyManager;

    private TechServiceManager techServiceManager;

    private EndpointManager endpointManager;

    private WSDLManager wsdlImporter;

    private SLAManager slaManager;

    private TechnologyManager technologyManager;

    private DataLoader dataLoader;

    private MetadataService metadataService;

    private UDDIPublicationPortType uddiPublication;

    private TModelManager tModelManager;

    public DragonServiceManagerImpl() {
        super();
    }

    public void init(ServletContext servletContext) {
        if (servletContext != null) {
            logger.debug("Initialize Dragon Service Proxies");
            ApplicationContext applicationContext = SpringUtil
                    .getWebApplicationContext(servletContext);
            this.organizationManager = new OrganizationManagerImpl(applicationContext);
            this.personManager = new PersonManagerImpl(applicationContext);
            this.partyManager = new PartyManagerImpl(applicationContext);
            this.postManager = new PostManagerImpl(applicationContext);
            this.endpointManager = new EndpointManagerImpl(applicationContext);
            this.techServiceManager = new TechServiceManagerImpl(applicationContext);
            this.wsdlImporter = new WSDLManagerImpl(applicationContext);
            this.roleOfPartyManager = new RoleOfPartyManagerImpl(applicationContext);
            this.slaManager = new SLAManagerImpl(applicationContext);
            this.technologyManager = new TechnologyManagerImpl(applicationContext);
            this.dataLoader = new DataLoaderImpl(applicationContext);
            this.metadataService = new MetadataServiceImpl(applicationContext);
            this.uddiPublication = new UDDIPublicationImpl(applicationContext);
            this.tModelManager = new TModelManagerImpl(applicationContext);
        }
    }

    public OrganizationManager getOrganizationManager() {
        return organizationManager;
    }

    public EndpointManager getEndpointManager() {
        return endpointManager;
    }

    public RoleOfPartyManager getRoleOfPartyManager() {
        return roleOfPartyManager;
    }

    public PersonManager getPersonManager() {
        return personManager;
    }

    public PostManager getPostManager() {
        return postManager;
    }

    public TechServiceManager getTechServiceManager() {
        return techServiceManager;
    }

    public WSDLManager getWSDLImporter() {
        return wsdlImporter;
    }

    public SLAManager getSLAManager() {
        return slaManager;
    }

    /**
     * @return the partyManager
     */
    public PartyManager getPartyManager() {
        return partyManager;
    }

    /**
     * @param partyManager
     *            the partyManager to set
     */
    public void setPartyManager(PartyManager partyManager) {
        this.partyManager = partyManager;
    }

    public TechnologyManager getTechnologyManager() {
        return technologyManager;
    }

    public DataLoader getDataLoader() {
        return dataLoader;
    }

    public MetadataService getMetadataService() {
        return metadataService;
    }

    public UDDIPublicationPortType getUDDIPublicationService() {
        return uddiPublication;
    }

    public TModelManager getTModelManager() {
        return tModelManager;
    }
}
