/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TModelManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.common;

import java.util.List;

import org.ow2.dragon.api.service.common.TModelManager;
import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.springframework.context.ApplicationContext;

/**
 * @author ofabre
 * 
 */
public class TModelManagerImpl implements TModelManager {

    private TModelManager tModelManager;

    public TModelManagerImpl(ApplicationContext context) {
        super();
        this.tModelManager = (TModelManager) context.getBean("tModelManager");
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.common.TModelManager#loadCategoryValues(java
     * .lang.String)
     */
    public List<CategoryValueTO> loadCategoryValues(String categoryId) {
        return tModelManager.loadCategoryValues(categoryId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.api.service.common.TModelManager#loadServiceCategories()
     */
    public List<CategoryTO> loadServiceCategories() {
        return tModelManager.loadServiceCategories();
    }

    public List<CategoryTO> loadEndpointCategories() {
        return tModelManager.loadEndpointCategories();
    }

    public List<CategoryTO> loadOrganizationCategories() {
        return tModelManager.loadOrganizationCategories();
    }

    public List<IdentifierTO> loadOrganizationIdentifierSystems() {
        return tModelManager.loadOrganizationIdentifierSystems();
    }

}
