/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.organization;

import java.util.List;

import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.OrganizationManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.springframework.context.ApplicationContext;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class OrganizationManagerImpl implements OrganizationManager {

    private OrganizationManager organizationManagerService;

    public OrganizationManagerImpl(ApplicationContext context) {
        super();
        this.organizationManagerService = (OrganizationManager) context
                .getBean("organizationManager");
    }

    public String createOrganization(OrganizationUnitTO arg0) throws OrganizationException {
        return organizationManagerService.createOrganization(arg0);
    }

    public List<OrganizationUnitTO> getAllOrganizations(RequestOptionsTO arg0)
            throws OrganizationException {
        return organizationManagerService.getAllOrganizations(arg0);
    }

    public OrganizationUnitTO getOrganization(String arg0) throws OrganizationException {
        return organizationManagerService.getOrganization(arg0);
    }

    public void removeOrganization(String arg0) throws OrganizationException {
        organizationManagerService.removeOrganization(arg0);

    }

    public List<OrganizationUnitTO> searchOrganization(String arg0,
            List<String> searchedProperties, RequestOptionsTO arg5) throws OrganizationException {
        return organizationManagerService.searchOrganization(arg0, searchedProperties, arg5);
    }

    public String updateOrganization(OrganizationUnitTO arg0) throws OrganizationException {
        return organizationManagerService.updateOrganization(arg0);
    }

    public void addPost(String arg0, String arg1) throws OrganizationException {
        organizationManagerService.addPost(arg0, arg1);
    }

    public void removePost(String organizationId, String postId) {
        organizationManagerService.removePost(organizationId, postId);
    }

    public void addCategory(String orgId, String categoryId, String categoryValueId)
            throws OrganizationException {
        organizationManagerService.addCategory(orgId, categoryId, categoryValueId);
    }

    public void addCategory(String orgId, String categoryId, String categoryValue,
            String categoryDesc) throws OrganizationException {
        organizationManagerService.addCategory(orgId, categoryId, categoryValue, categoryDesc);
    }

    public List<KeyedRefTO> getCategoriesForOrg(String orgId) throws DeploymentException {
        return organizationManagerService.getCategoriesForOrg(orgId);
    }

    public void removeCategories(String orgId, List<String> categoryIds) {
        organizationManagerService.removeCategories(orgId, categoryIds);
    }

    public void addIdentifier(String orgId, String identifierId, String identifierValue,
            String identifierDesc) throws OrganizationException {
        organizationManagerService.addIdentifier(orgId, identifierId, identifierValue,
                identifierDesc);
    }

    public List<KeyedRefTO> getIdentifiersForOrg(String orgId) throws DeploymentException {
        return organizationManagerService.getIdentifiersForOrg(orgId);
    }

    public void removeIdentifiers(String orgId, List<String> categoryIds) {
        organizationManagerService.removeIdentifiers(orgId, categoryIds);
    }

}
