/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PartyManagerImpl.java
 * -------------------------------------------------------------------------
 */
package org.ow2.dragon.ui.businessdelegate.spring.organization;

import java.util.List;

import org.ow2.dragon.api.service.organization.PartyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PartyTO;
import org.springframework.context.ApplicationContext;

/**
 * @author ofabre - eBM WebSourcing
 *
 */
public class PartyManagerImpl implements PartyManager {

    private PartyManager partyManagerService;

    public PartyManagerImpl(ApplicationContext context) {
        super();
        this.partyManagerService = (PartyManager) context.getBean("partyManager");
    }

	public List<PartyTO> getAllParties(RequestOptionsTO requestOptionsTO) {
		return this.partyManagerService.getAllParties(requestOptionsTO);
	}

	public PartyTO getParty(String partyId) {
		return this.partyManagerService.getParty(partyId);
	}


}
