/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PersonManagerImpl.java
 * -------------------------------------------------------------------------
 */
package org.ow2.dragon.ui.businessdelegate.spring.organization;

import java.util.List;

import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.springframework.context.ApplicationContext;

/**
 * @author ofabre - eBM WebSourcing
 *
 */
public class PersonManagerImpl implements PersonManager {

    private PersonManager personManagerService;
    
    public PersonManagerImpl(ApplicationContext context) {
        super();
        this.personManagerService = (PersonManager) context
                .getBean("personManager");
    }

    public String createPerson(PersonTO arg0) throws OrganizationException {
        return personManagerService.createPerson(arg0);
    }

    public List<PersonTO> getAllPersons(RequestOptionsTO arg0) throws OrganizationException {
        return personManagerService.getAllPersons(arg0);
    }

    public PersonTO getPerson(String arg0) throws OrganizationException {
        return personManagerService.getPerson(arg0);
    }

    public List<PersonTO> getPersonsByOrganization(String arg0, RequestOptionsTO arg1)
            throws OrganizationException {
        return personManagerService.getPersonsByOrganization(arg0, arg1);
    }

    public List<PersonTO> getPersonsByPost(String arg0, RequestOptionsTO arg1)
            throws OrganizationException {
        return personManagerService.getPersonsByPost(arg0, arg1);
    }

    public void removePerson(String arg0) throws OrganizationException {
        personManagerService.removePerson(arg0);
    }

    public List<PersonTO> searchPersons(String arg0, List<String> searchedProperties,
            RequestOptionsTO arg4) throws OrganizationException {
        return personManagerService.searchPersons(arg0, searchedProperties, arg4);
    }

    public String updatePerson(PersonTO arg0) throws OrganizationException {
        return personManagerService.updatePerson(arg0);
    }

    public List<PersonTO> getPersonsByOrgAndPost(String organizationId, String postId,
            RequestOptionsTO optionsTO) {
        return personManagerService.getPersonsByOrgAndPost(organizationId, postId, optionsTO);
    }
}
