/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * WSDLManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.businessdelegate.spring.wsdl;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class WSDLManagerImpl implements WSDLManager {

    private WSDLManager importer;

    public WSDLManagerImpl(ApplicationContext context) {
        super();
        this.importer = (WSDLManager) context.getBean("wsdlManager");
    }

    public String[] importServiceDefFile(Document domDocument) throws WSDLServiceException, TimeoutException {
        return importer.importServiceDefFile(domDocument);
    }

    public String[] importServiceDefFile(Element domElement) throws WSDLServiceException {
        return importer.importServiceDefFile(domElement);
    }

    public String[] importServiceDefFile(InputSource inputSource) throws WSDLServiceException {
        return importer.importServiceDefFile(inputSource);
    }

    public String[] importServiceDefFile(String wsdlContent) throws WSDLServiceException {
        return importer.importServiceDefFile(wsdlContent);
    }

    public String[] importServiceDefFile(URI wsdlURI) throws WSDLServiceException {
        return importer.importServiceDefFile(wsdlURI);
    }

    public List<ServiceSpecificationTO> getServSpecsForEndpoint(String epId)
            throws WSDLServiceException {
        return importer.getServSpecsForEndpoint(epId);
    }

    public List<ServiceSpecificationTO> getServSpecsForTechServ(String techServiceId)
            throws WSDLServiceException {
        return importer.getServSpecsForTechServ(techServiceId);
    }

    public InputStream getWsdlDesc(String servSpecId) throws WSDLServiceException {
        return importer.getWsdlDesc(servSpecId);
    }

    public String[] importServiceDefFile(String wsdlContent, Map<String, String> imports)
            throws WSDLServiceException {
        return importer.importServiceDefFile(wsdlContent, imports);
    }

    public String getWsdlDescAsString(String servSpecId) throws WSDLServiceException {
        return this.importer.getWsdlDescAsString(servSpecId);
    }

    public String[] importServiceDefFile(Document domDocument, String wsdlFileName)
            throws WSDLServiceException, TimeoutException {
        return this.importer.importServiceDefFile(domDocument, wsdlFileName);
    }
}
