/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ClientBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.sla;

import javax.servlet.http.HttpServletRequest;

import org.ow2.dragon.ui.uibeans.organization.OrganizationBean;
import org.ow2.dragon.ui.uibeans.organization.PartyBean;
import org.ow2.dragon.ui.uibeans.organization.PersonBean;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class ClientBean {

    private PartyBean client = null;

    private String personId = "-1";
    
    private String organizationId = "-1";
    
    public ClientBean() {

    }

    // ==========================================================
    // === Control Methods
    // ==========================================================

    /**
     * Loads a technical service from the request parameter 'id'.
     */
    public void load(HttpServletRequest iRequest) throws LocalizedError {
        String personId = iRequest.getParameter("personId");
        if ((personId != null) && (!personId.equals("-1"))) {
            client = new PersonBean();
            client.load(iRequest);
            this.personId = personId;
            this.organizationId = "-1";
        }
        String organizationId = iRequest.getParameter("organizationId");
        if ((organizationId != null) && (!organizationId.equals("-1"))) {
            client = new OrganizationBean();
            client.load(iRequest);
            this.personId = "-1";
            this.organizationId = organizationId;
        }
    }

    /**
     * @return the selectedClient
     */
    public String getName() {
        return client.getGenericName();
    }

    /**
     * @return the client
     */
    public PartyBean getClient() {
        return client;
    }

    /**
     * @param client
     *            the client to set
     */
    public void setClient(PartyBean client) {
        this.client = client;
    }

	public String getPersonId() {
		return personId;
	}

	public void setPersonId(String personId) {
		this.personId = personId;
	}

	public String getOrganizationId() {
		return organizationId;
	}

	public void setOrganizationId(String organizationID) {
		this.organizationId = organizationID;
	}

}
