/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ExecutionEnvironmentBean.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.opensuit.core.error.LocalizedError;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class ExecutionEnvironmentBean {

    private Logger logger = Logger.getLogger(this.getClass());

    private ExecutionEnvironmentTO executionEnvironmentTO;

    private List<EndpointTO> hostedEps;

    private ProcessorTO hostProcessor;

    private EnvironmentFederationTO parentFederation;

    private String execEnvId;

    private String name;

    private String ipv4Address;

    private String type;

    private String envType;

    public String load(HttpServletRequest request) throws LocalizedError {

        String id = request.getParameter("execEnvId");

        // Load Runtime manager
        loadExecEnv(id);

        // Load host Processor
        loadHostProcessor();

        // Load host Federation
        loadHostFederation();

        // Loas Runtime manager exec envs
        loadHostedEps(id);

        reset();
        return "success";
    }

    private void loadHostFederation() throws LocalizedError {
        if (executionEnvironmentTO.getParentFederationId() != null) {
            try {
                parentFederation = DragonServiceFactory.getInstance().getTechnologyManager()
                        .getEnvironmentFederation(executionEnvironmentTO.getParentFederationId());
            } catch (DragonDelegateException e) {
                logger.error(e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
            }
        }
    }

    private void loadHostProcessor() throws LocalizedError {
        if (executionEnvironmentTO.getHostProcessorId() != null) {
            try {
                hostProcessor = DragonServiceFactory.getInstance().getTechnologyManager()
                        .getProcessor(executionEnvironmentTO.getHostProcessorId());
            } catch (DragonDelegateException e) {
                logger.error(e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
            }
        }
    }

    private void loadHostedEps(String id) throws LocalizedError {
        // sort ascendingly on name
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria("name");
        try {
            hostedEps = DragonServiceFactory.getInstance().getTechnologyManager()
                    .getEpsHostedOnExecEnv(id, requestOptionsTO);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }

    }

    private void loadExecEnv(String id) throws LocalizedError {
        try {
            executionEnvironmentTO = DragonServiceFactory.getInstance().getTechnologyManager()
                    .getExecutionEnvironment(id);
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public void reset() {
        if (executionEnvironmentTO != null) {
            this.ipv4Address = executionEnvironmentTO.getIpv4Address();
            this.name = executionEnvironmentTO.getName();
            this.envType = executionEnvironmentTO.getEnvType();
            this.type = executionEnvironmentTO.getType();
            this.execEnvId = executionEnvironmentTO.getNodeId();
        }
    }

    public void save() {

    }

    public void validate() {

    }

    public void delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getTechnologyManager().removeExecutionEnvironment(
                    executionEnvironmentTO.getNodeId());
        } catch (DragonDelegateException e) {
            logger.error(e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[] { e.getMessage() });
        }
    }

    public String getExecEnvId() {
        return execEnvId;
    }

    public void setExecEnvId(String execEnvId) {
        this.execEnvId = execEnvId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIpv4Address() {
        return ipv4Address;
    }

    public void setIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ExecutionEnvironmentTO getExecutionEnvironmentTO() {
        return executionEnvironmentTO;
    }

    public void setExecutionEnvironmentTO(ExecutionEnvironmentTO executionEnvironmentTO) {
        this.executionEnvironmentTO = executionEnvironmentTO;
    }

    public List<EndpointTO> getHostedEps() {
        return hostedEps;
    }

    public void setHostedEps(List<EndpointTO> hostedEps) {
        this.hostedEps = hostedEps;
    }

    public ProcessorTO getHostProcessor() {
        return hostProcessor;
    }

    public void setHostProcessor(ProcessorTO hostProcessor) {
        this.hostProcessor = hostProcessor;
    }

    public EnvironmentFederationTO getParentFederation() {
        return parentFederation;
    }

    public void setParentFederation(EnvironmentFederationTO parentFederation) {
        this.parentFederation = parentFederation;
    }

    public String getEnvType() {
        return envType;
    }

    public void setEnvType(String envType) {
        this.envType = envType;
    }

}
