/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.deployment;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.dragon.util.XMLUtil;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfTechnicalServicesBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<TechnicalServiceTO> techServices;
    private String searchCriteria;
    private List<String> searchedProperties;
    private String fileDescriptionURL;
    private String[] serviceIds;
    private String tag;

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String loadServicesByTag(HttpServletRequest request) throws LocalizedError {
        this.tag = request.getParameter("tag");
        try {
            this.techServices = DragonServiceFactory.getInstance().getTechServiceManager().getTechServicesByTag(this.tag);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String removeTagFromService(HttpServletRequest request) throws LocalizedError {
        String serviceId = request.getParameter("serviceId");
        this.tag = request.getParameter("tag");
        try {
            DragonServiceFactory.getInstance().getTechServiceManager().removeTag(this.tag, serviceId);
            this.techServices = DragonServiceFactory.getInstance().getTechServiceManager().getTechServicesByTag(this.tag);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String loadAll() throws LocalizedError {
        try {
            this.techServices = DragonServiceFactory.getInstance().getTechServiceManager().getAllTechServices(null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
    }

    public String loadNew() throws LocalizedError {
        try {
            return this.loadNew(DragonServiceFactory.getInstance().getWSDLImporter().importServiceDefFile(URI.create(this.fileDescriptionURL)));
        }
        catch (WSDLServiceException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String loadNew(String[] serviceIds) throws LocalizedError {
        try {
            this.techServices = DragonServiceFactory.getInstance().getTechServiceManager().loadServicesFromWSDL(serviceIds, null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        String result = "success";
        if (this.techServices == null || this.techServices.isEmpty()) {
            result = "no";
        }
        return result;
    }

    public void loadNew(IFileUploadPart file) throws LocalizedError {
        String fileName = this.extractShortFilename(file);
        try {
            this.serviceIds = DragonServiceFactory.getInstance().getWSDLImporter().importServiceDefFile(XMLUtil.loadDocument((InputStream)file.getFileInputStream()), fileName);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    private String extractShortFilename(IFileUploadPart file) {
        String fileName = file.getFileName();
        if (fileName != null) {
            if (fileName.contains("/")) {
                String[] parts = fileName.split("/");
                fileName = parts[parts.length - 1];
            } else if (fileName.contains("\\")) {
                String[] parts = fileName.split("\\u005C+");
                fileName = parts[parts.length - 1];
            }
        }
        return fileName;
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            try {
                this.techServices = DragonServiceFactory.getInstance().getTechServiceManager().searchTechService(searchCriteria, searchedProperties, null);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.techServices == null || this.techServices.size() == 0) {
                LocalizedError error = new LocalizedError("search_tech_serv_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    private RequestOptionsTO createSortOption(String sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public List<TechnicalServiceTO> getTechServices() {
        return this.techServices;
    }

    public void setTechServices(List<TechnicalServiceTO> techServices) {
        this.techServices = techServices;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public String getFileDescriptionURL() {
        return this.fileDescriptionURL;
    }

    public void setFileDescriptionURL(String fileDescriptionURL) {
        this.fileDescriptionURL = fileDescriptionURL;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }

    public String[] getServiceIds() {
        return this.serviceIds;
    }

    public void setServiceIds(String[] serviceIds) {
        this.serviceIds = serviceIds;
    }
}

