/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfOrganizationsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<OrganizationUnitTO> organizations;
    private String searchCriteria;
    private List<String> searchedProperties;

    public void loadAll() throws LocalizedError {
        try {
            this.organizations = DragonServiceFactory.getInstance().getOrganizationManager().getAllOrganizations(null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public boolean isOrganizationInDB() throws LocalizedError {
        List organizationsInDB = null;
        try {
            organizationsInDB = DragonServiceFactory.getInstance().getOrganizationManager().getAllOrganizations(null);
        }
        catch (OrganizationException e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        catch (DragonDelegateException e) {
            e.printStackTrace();
        }
        return organizationsInDB != null && organizationsInDB.size() != 0;
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            try {
                this.organizations = DragonServiceFactory.getInstance().getOrganizationManager().searchOrganization(searchCriteria, searchedProperties, null);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.organizations == null || this.organizations.size() == 0) {
                LocalizedError error = new LocalizedError("search_org_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    private RequestOptionsTO createSortOption(String sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public List<OrganizationUnitTO> getMotherOrganizations() {
        ArrayList<OrganizationUnitTO> result = new ArrayList<OrganizationUnitTO>();
        OrganizationUnitTO nullOrganization = new OrganizationUnitTO();
        nullOrganization.setId(null);
        nullOrganization.setName("No mother organization");
        if (this.organizations != null) {
            result.add(nullOrganization);
            result.addAll(this.organizations);
        } else {
            result.add(nullOrganization);
        }
        return result;
    }

    public List<OrganizationUnitTO> getOrganizationsForPerson() {
        ArrayList<OrganizationUnitTO> result = new ArrayList<OrganizationUnitTO>();
        OrganizationUnitTO nullOrganization = new OrganizationUnitTO();
        nullOrganization.setId("");
        nullOrganization.setName("No organization selected");
        if (this.organizations != null) {
            result.add(nullOrganization);
            result.addAll(this.organizations);
        } else {
            result.add(nullOrganization);
        }
        return result;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public List<OrganizationUnitTO> getOrganizations() {
        return this.organizations;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }
}

