/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.organization.PartyBean;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.validation.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationBean
extends PartyBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private OrganizationUnitTO organization;
    private List<PersonTO> persons;
    private List<PostTO> orgPosts;
    private String name;
    private String type;
    private boolean isLegalEntity;
    private String discoveryURL;
    private String emailAddress;
    private String motherOrganizationId;
    private String streetNumber;
    private String street;
    private String complement;
    private String zipcode;
    private String city;
    private String state;
    private String country;
    private List<KeyedRefTO> categories;
    private List<String> selectedCategories;
    private List<KeyedRefTO> identifiers;
    private List<String> selectedIdentifiers;

    public OrganizationBean() {
    }

    public OrganizationBean(OrganizationUnitTO orgTO) throws LocalizedError {
        try {
            this.organization = orgTO;
            this.persons = DragonServiceFactory.getInstance().getPersonManager().getPersonsByOrganization(this.organization.getId(), null);
            this.loadOrganizationPosts();
            this.reset();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
    }

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        String id = iRequest.getParameter("organizationId");
        try {
            this.organization = DragonServiceFactory.getInstance().getOrganizationManager().getOrganization(id);
            if (this.organization != null) {
                this.loadOrganizationPersons();
                this.loadOrganizationPosts();
            }
            this.reset();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
    }

    public void loadOrganizationPosts() throws OrganizationException, DragonDelegateException {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria("name");
        this.orgPosts = DragonServiceFactory.getInstance().getPostManager().getPostsByOrganization(this.organization.getId(), requestOptionsTO);
    }

    public void loadOrganizationPersons() throws OrganizationException, DragonDelegateException {
        this.persons = DragonServiceFactory.getInstance().getPersonManager().getPersonsByOrganization(this.organization.getId(), null);
    }

    public String save() throws LocalizedError {
        OrganizationUnitTO motherOrganization = null;
        try {
            motherOrganization = DragonServiceFactory.getInstance().getOrganizationManager().getOrganization(this.motherOrganizationId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        OrganizationUnitTO newOrganization = this.createOrganizationUnitTO(motherOrganization);
        try {
            DragonServiceFactory.getInstance().getOrganizationManager().updateOrganization(newOrganization);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.organization = newOrganization;
        return "success";
    }

    private OrganizationUnitTO createOrganizationUnitTO(OrganizationUnitTO motherOrganization) {
        OrganizationUnitTO newOrganization = new OrganizationUnitTO();
        newOrganization.setId(this.organization.getId());
        newOrganization.setDiscoveryURL(this.discoveryURL);
        newOrganization.setEmailAddress(this.emailAddress);
        newOrganization.setIsLegalEntity(this.isLegalEntity);
        newOrganization.setMotherOrganization(motherOrganization);
        newOrganization.setName(this.name);
        newOrganization.setType(this.type);
        newOrganization.setStreetNumber(this.streetNumber);
        newOrganization.setStreet(this.street);
        newOrganization.setComplement(this.complement);
        newOrganization.setZipcode(this.zipcode);
        newOrganization.setCity(this.city);
        newOrganization.setState(this.state);
        newOrganization.setCountry(this.country);
        return newOrganization;
    }

    public boolean isPostToAdd(HttpServletRequest iRequest) throws LocalizedError {
        List posts = new ArrayList();
        boolean result = false;
        String orgId = iRequest.getParameter("organizationId");
        try {
            posts = DragonServiceFactory.getInstance().getPostManager().getPostsNotLinkedToOrganization(orgId, null);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (posts != null && !posts.isEmpty()) {
            result = true;
        }
        return result;
    }

    public boolean isPostInPostList(HttpServletRequest request) {
        boolean result = false;
        if (this.orgPosts != null && !this.orgPosts.isEmpty()) {
            result = true;
        }
        return result;
    }

    public String canDeletePost(PostTO postTo) throws LocalizedError {
        List persons = new ArrayList();
        try {
            persons = DragonServiceFactory.getInstance().getPersonManager().getPersonsByOrgAndPost(this.organization.getId(), postTo.getId(), null);
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        if (persons == null || persons.isEmpty()) {
            return "yes";
        }
        return "no";
    }

    public String deletePost(String postId) throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getOrganizationManager().removePost(this.organization.getId(), postId);
            this.loadOrganizationPosts();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String deletePerson(String personId) throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getPersonManager().removePerson(personId);
            this.loadOrganizationPersons();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String create() throws LocalizedError {
        OrganizationUnitTO motherOrganization = null;
        try {
            motherOrganization = DragonServiceFactory.getInstance().getOrganizationManager().getOrganization(this.motherOrganizationId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        OrganizationUnitTO newOrganization = this.createOrganizationUnitTO(motherOrganization);
        String orgId = "";
        try {
            orgId = DragonServiceFactory.getInstance().getOrganizationManager().createOrganization(newOrganization);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        try {
            this.organization = DragonServiceFactory.getInstance().getOrganizationManager().getOrganization(orgId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getOrganizationManager().removeOrganization(this.organization.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
        this.discoveryURL = this.organization.getDiscoveryURL();
        this.isLegalEntity = this.organization.getIsLegalEntity();
        this.name = this.organization.getName();
        this.type = this.organization.getType();
        this.motherOrganizationId = this.organization.getMotherOrganization() != null ? this.organization.getMotherOrganization().getId() : "";
        this.categories = this.organization.getCategories();
        this.identifiers = this.organization.getIdentifiers();
        this.emailAddress = this.organization.getEmailAddress();
        this.streetNumber = this.organization.getStreetNumber();
        this.street = this.organization.getStreet();
        this.complement = this.organization.getComplement();
        this.zipcode = this.organization.getZipcode();
        this.city = this.organization.getCity();
        this.state = this.organization.getState();
        this.country = this.organization.getCountry();
    }

    public void clear() {
        this.organization = new OrganizationUnitTO();
        this.reset();
    }

    public void loadCategories() throws LocalizedError {
        try {
            this.categories = DragonServiceFactory.getInstance().getOrganizationManager().getCategoriesForOrg(this.organization.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadIdentifiers() throws LocalizedError {
        try {
            this.identifiers = DragonServiceFactory.getInstance().getOrganizationManager().getIdentifiersForOrg(this.organization.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String removeCategories() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getOrganizationManager().removeCategories(this.organization.getId(), this.selectedCategories);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadCategories();
        return "success";
    }

    public String removeIdentifiers() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getOrganizationManager().removeIdentifiers(this.organization.getId(), this.selectedIdentifiers);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadIdentifiers();
        return "success";
    }

    public void validate() throws ValidationErrors {
    }

    public String getId() {
        if (this.organization == null) {
            return "";
        }
        return this.organization.getId();
    }

    public List<PersonTO> getPersons() {
        return this.persons;
    }

    public List<PostTO> getOrgPosts() {
        return this.orgPosts;
    }

    public String getDiscoveryURL() {
        return this.discoveryURL;
    }

    public void setDiscoveryURL(String discoveryURL) {
        this.discoveryURL = discoveryURL;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean getIsLegalEntity() {
        return this.isLegalEntity;
    }

    public void setIsLegalEntity(boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
    }

    public String getMotherOrganizationId() {
        return this.motherOrganizationId;
    }

    public void setMotherOrganizationId(String motherOrganizationId) {
        this.motherOrganizationId = motherOrganizationId;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getGenericName() {
        return this.name;
    }

    public String toString() {
        return this.getGenericName();
    }

    public List<KeyedRefTO> getCategories() {
        return this.categories;
    }

    public void setCategories(List<KeyedRefTO> categories) {
        this.categories = categories;
    }

    public List<String> getSelectedCategories() {
        return this.selectedCategories;
    }

    public void setSelectedCategories(List<String> selectedCategories) {
        this.selectedCategories = selectedCategories;
    }

    public OrganizationUnitTO getOrganization() {
        return this.organization;
    }

    public void setOrganization(OrganizationUnitTO organization) {
        this.organization = organization;
    }

    public List<KeyedRefTO> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<KeyedRefTO> identifiers) {
        this.identifiers = identifiers;
    }

    public List<String> getSelectedIdentifiers() {
        return this.selectedIdentifiers;
    }

    public void setSelectedIdentifiers(List<String> selectedIdentifiers) {
        this.selectedIdentifiers = selectedIdentifiers;
    }
}

