/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.organization;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.organization.ListOfPostsBean;
import org.ow2.dragon.ui.uibeans.organization.OrganizationBean;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class PostBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private PostTO post;
    private String nature;
    private String description;
    private String name;
    private boolean contact;

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        String id = iRequest.getParameter("postId");
        try {
            this.post = DragonServiceFactory.getInstance().getPostManager().getPost(id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
    }

    public void load(String postId) throws LocalizedError {
        try {
            this.post = DragonServiceFactory.getInstance().getPostManager().getPost(postId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
    }

    public String save() throws LocalizedError {
        PostTO newPost = new PostTO();
        newPost.setId(this.post.getId());
        newPost.setName(this.name);
        newPost.setNature(this.nature);
        newPost.setDescription(this.description);
        newPost.setContact(this.contact);
        try {
            DragonServiceFactory.getInstance().getPostManager().updatePost(newPost);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.post = newPost;
        return "success";
    }

    public String create(HttpServletRequest iRequest, OrganizationBean orgBean, ListOfPostsBean listOfPosts) throws LocalizedError {
        PostTO newPost = new PostTO();
        newPost.setName(this.name);
        newPost.setNature(this.nature);
        newPost.setDescription(this.description);
        newPost.setContact(this.contact);
        String postId = "";
        try {
            postId = DragonServiceFactory.getInstance().getPostManager().createPost(newPost);
            DragonServiceFactory.getInstance().getOrganizationManager().addPost(orgBean.getId(), postId);
            orgBean.loadOrganizationPosts();
            listOfPosts.loadFree(iRequest);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        try {
            this.post = DragonServiceFactory.getInstance().getPostManager().getPost(postId);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getPostManager().removePost(this.post.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() {
        this.name = this.post.getName();
        this.nature = this.post.getNature();
        this.description = this.post.getDescription();
        this.contact = this.post.isContact();
    }

    public String clear() {
        this.post = new PostTO();
        this.reset();
        return "success";
    }

    public void validate() throws ValidationErrors {
    }

    public String getId() {
        if (this.post == null) {
            return "";
        }
        return this.post.getId();
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isContact() {
        return this.contact;
    }

    public void setContact(boolean contact) {
        this.contact = contact;
    }
}

