/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.WSAddressing4AgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.AgreementTemplate;
import com.ebmwebsourcing.agreement.definition.api.GuaranteeTerms;
import com.ebmwebsourcing.wsstar.agreement.service.impl.AgreementServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.deployment.BindingOperationTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.deployment.EndpointBean;
import org.ow2.dragon.ui.uibeans.deployment.TechnicalServiceBean;
import org.ow2.dragon.ui.uibeans.sla.GuaranteeBean;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.dragon.ui.uibeans.sla.ServiceDescriptionTermBean;
import org.ow2.dragon.ui.uibeans.sla.ServicePropertiesBean;
import org.ow2.dragon.ui.uibeans.sla.ServiceReferenceBean;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgreementBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private Agreement agreementTO;
    private ManagedAgreementBean mab;
    private String name;
    private String clientEndpoint;
    private String providerEndpoint;
    private Date expirationTime;
    private ServiceDescriptionTermBean serviceDescriptionBean = new ServiceDescriptionTermBean();
    private ServiceReferenceBean serviceReferenceBean = new ServiceReferenceBean();
    private ServicePropertiesBean servicePropertiesBean = new ServicePropertiesBean();
    private List<GuaranteeBean> guaranteesBean = new ArrayList();
    private String templateId;
    private String selectedProvider;
    private String selectedTemplate = null;

    public AgreementBean() {
    }

    public AgreementBean(Agreement agTO, ManagedAgreementBean mab) throws LocalizedError {
        this.agreementTO = agTO;
        this.mab = mab;
        this.serviceDescriptionBean.setSdtTO(this.agreementTO.getServiceDescription());
        this.serviceDescriptionBean.setMab(this.mab);
        this.serviceReferenceBean.setSrTO(this.agreementTO.getServiceReference());
        this.serviceReferenceBean.setMab(this.mab);
        this.servicePropertiesBean.setSpTO(this.agreementTO.getServiceProperties());
        this.servicePropertiesBean.setMab(this.mab);
        this.initGuaranteesBean();
        this.reset();
    }

    public void initGuaranteesBean() throws LocalizedError {
        this.guaranteesBean = new ArrayList();
        for (GuaranteeTerms g : this.agreementTO.getGuaranteeTerms()) {
            this.guaranteesBean.add(new GuaranteeBean(g, this.mab));
        }
    }

    public Date getExpirationTime() {
        Date res = null;
        if (this.expirationTime != null) {
            res = (Date)this.expirationTime.clone();
        }
        return res;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime != null ? (Date)expirationTime.clone() : null;
    }

    public String save() throws LocalizedError {
        try {
            this.agreementTO.setName(this.name);
            EndpointReferenceType eprClient = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
            eprClient.setAddress(this.clientEndpoint);
            this.agreementTO.getContext().setInitiator(eprClient);
            EndpointReferenceType eprProvider = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
            eprProvider.setAddress(this.providerEndpoint);
            this.agreementTO.getContext().setResponder(eprProvider);
            if (this.expirationTime != null) {
                this.agreementTO.getContext().setExpirationTime(this.expirationTime);
            }
            this.serviceDescriptionBean.save();
            this.serviceReferenceBean.save();
            this.servicePropertiesBean.save();
            for (GuaranteeBean g : this.guaranteesBean) {
                g.save();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String create(String type, ManagedAgreementBean template, String agreementName, String clientName, String providerName, String clientEndpointName, Date expirationTime, TechnicalServiceBean techServiceBean, EndpointBean endpointBean) throws LocalizedError {
        try {
            if (type.equals("template")) {
                this.agreementTO = new AgreementServiceImpl().createProviderAgreementTemplate();
            } else if (type.equals("offer") && template == null) {
                this.agreementTO = new AgreementServiceImpl().createClientAgreement();
            }
            if (template != null) {
                this.agreementTO = new AgreementServiceImpl().createClientAgreementFromProviderTemplate((AgreementTemplate)template.getAgreementBean().getAgreementTO());
            } else {
                this.agreementTO.setContext(this.agreementTO.newContext());
                this.agreementTO.setServiceDescription(this.agreementTO.newServiceDescription());
                this.agreementTO.setServiceReference(this.agreementTO.newServiceReference());
                this.agreementTO.setServiceProperties(this.agreementTO.newServiceProperties());
            }
            EndpointReferenceType eprClient = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
            this.agreementTO.getContext().setInitiator(eprClient);
            EndpointReferenceType eprProvider = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
            this.agreementTO.getContext().setResponder(eprProvider);
            this.reset();
            this.agreementTO.setName(agreementName);
            eprClient.setAddress(clientEndpointName);
            eprProvider.setAddress(endpointBean.getName());
            if (expirationTime != null) {
                this.agreementTO.getContext().setExpirationTime(expirationTime);
            }
            this.serviceDescriptionBean.setSdtTO(this.agreementTO.getServiceDescription());
            this.serviceDescriptionBean.setMab(this.mab);
            this.serviceDescriptionBean.setName(agreementName + "_ServiceDescription");
            this.serviceDescriptionBean.setProviderName(providerName);
            this.serviceDescriptionBean.setServiceName(techServiceBean.getName());
            this.serviceDescriptionBean.setWsdlURL(techServiceBean.getWsdlUrl());
            this.serviceDescriptionBean.save();
            this.serviceReferenceBean.setSrTO(this.agreementTO.getServiceReference());
            this.serviceReferenceBean.setMab(this.mab);
            this.serviceReferenceBean.setName(agreementName + "_ServiceReference");
            this.serviceReferenceBean.setServiceName(techServiceBean.getName());
            this.serviceReferenceBean.save();
            this.servicePropertiesBean.setSpTO(this.agreementTO.getServiceProperties());
            this.servicePropertiesBean.setMab(this.mab);
            this.servicePropertiesBean.setName(agreementName + "_ServiceProperties");
            this.servicePropertiesBean.setServiceName(techServiceBean.getName());
            this.servicePropertiesBean.save();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String createClientEnpoint(String clientName, String endpointName) {
        String res = null;
        res = clientName + "_" + endpointName + "_clientEndpoint";
        return res;
    }

    public String delete() throws LocalizedError {
        this.mab.delete();
        return "success";
    }

    public void reset() throws LocalizedError {
        try {
            if (this.agreementTO != null) {
                this.name = this.agreementTO.getName();
                if (this.agreementTO instanceof AgreementTemplate) {
                    this.templateId = ((AgreementTemplate)this.agreementTO).getTemplateId();
                }
                this.clientEndpoint = this.agreementTO.getContext().getInitiator().getAddress();
                this.providerEndpoint = this.agreementTO.getContext().getResponder().getAddress();
                this.expirationTime = this.agreementTO.getContext().getExpirationTime();
                this.serviceDescriptionBean.reset();
                this.serviceReferenceBean.reset();
                this.servicePropertiesBean.reset();
                for (GuaranteeBean g : this.guaranteesBean) {
                    g.reset();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClientEndpoint() {
        return this.clientEndpoint;
    }

    public void setClientEndpoint(String initiator) {
        this.clientEndpoint = initiator;
    }

    public String getProviderEndpoint() {
        return this.providerEndpoint;
    }

    public void setProviderEndpoint(String responder) {
        this.providerEndpoint = responder;
    }

    public ServiceDescriptionTermBean getServiceDescriptionBean() {
        return this.serviceDescriptionBean;
    }

    public ServiceReferenceBean getServiceReferenceBean() {
        return this.serviceReferenceBean;
    }

    public ServicePropertiesBean getServicePropertiesBean() {
        return this.servicePropertiesBean;
    }

    public List<GuaranteeBean> getGuaranteesBean() {
        return this.guaranteesBean;
    }

    public void setGuaranteesBean(List<GuaranteeBean> guaranteeBean) {
        this.guaranteesBean = guaranteeBean;
    }

    public Agreement getAgreementTO() {
        return this.agreementTO;
    }

    public String getSelectedProvider() {
        return this.selectedProvider;
    }

    public void setSelectedProvider(String selectedProvider) {
        this.selectedProvider = selectedProvider;
    }

    public List<String> getAllProviderOperations() throws LocalizedError {
        ArrayList<String> res;
        block5: {
            res = new ArrayList<String>();
            try {
                EndpointTO ep;
                if (this.serviceReferenceBean == null || (ep = DragonServiceFactory.getInstance().getTechServiceManager().getEndpoint(this.serviceReferenceBean.getServiceName(), this.agreementTO.getContext().getResponder().getAddress())) == null) break block5;
                res.add("ALL-OPERATIONS");
                List bops = ep.getBinding().getBindingOps();
                for (BindingOperationTO operationTO : bops) {
                    String operationName = null;
                    try {
                        QName opq = QName.valueOf(operationTO.getSignature());
                        operationName = opq.getLocalPart();
                    }
                    catch (IllegalArgumentException e) {
                        operationName = operationTO.getSignature();
                    }
                    res.add(operationName);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        return res;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public void setSelectedTemplate(String selectedTemplate) {
        this.selectedTemplate = selectedTemplate;
    }
}

