/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PartyTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.uibeans.deployment.EndpointBean;
import org.ow2.dragon.ui.uibeans.deployment.TechnicalServiceBean;
import org.ow2.dragon.ui.uibeans.organization.OrganizationBean;
import org.ow2.dragon.ui.uibeans.organization.PartyBean;
import org.ow2.dragon.ui.uibeans.organization.PersonBean;
import org.ow2.dragon.ui.uibeans.sla.AgreementBean;
import org.ow2.dragon.ui.uibeans.sla.AgreementClientBoardBean;
import org.ow2.dragon.ui.uibeans.sla.AgreementProviderBoardBean;
import org.ow2.dragon.ui.uibeans.sla.GuaranteeBean;
import org.ow2.dragon.ui.uibeans.sla.MetricBean;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedAgreementBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final List<String> listStates = new ArrayList<String>(Arrays.asList(AgreementLifeCycle.State.PENDING.value(), AgreementLifeCycle.State.PENDING_AND_TERMINATING.value(), AgreementLifeCycle.State.OBSERVE.value(), AgreementLifeCycle.State.OBSERVED_AND_TERMINATING.value(), AgreementLifeCycle.State.REJECTE.value(), AgreementLifeCycle.State.COMPLETE.value(), AgreementLifeCycle.State.TERMINATE.value(), AgreementLifeCycle.State.OFFER_RECEIVE.value()));
    private ManagedAgreementTO managedAgreementTO;
    private String id = "-1";
    private AgreementBean agreementBean = new AgreementBean();
    private String currentState;
    private Date signedByClient;
    private Date signedByProvider;
    private String slaDescription;
    private PartyBean clientBean;
    private PartyBean providerBean;
    private ManagedAgreementBean nill;

    public ManagedAgreementBean() {
    }

    public ManagedAgreementBean(ManagedAgreementTO magTO) throws LocalizedError {
        try {
            this.managedAgreementTO = magTO;
            this.agreementBean = new AgreementBean(this.managedAgreementTO.getAgreement(), this);
            this.loadClientAndProvider();
        }
        catch (DragonDelegateException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
        this.export();
    }

    public String load(HttpServletRequest iRequest) throws LocalizedError {
        String idAgreement = iRequest.getParameter("agreementId");
        try {
            if (idAgreement != null) {
                this.managedAgreementTO = DragonServiceFactory.getInstance().getSLAManager().getManagedAgreement(idAgreement);
                this.agreementBean = new AgreementBean(this.managedAgreementTO.getAgreement(), this);
                this.managedAgreementTO.setSlaDescription(StringHelper.prettyPrint((String)DragonServiceFactory.getInstance().getSLAManager().exportServiceDefFile(idAgreement)));
                this.loadClientAndProvider();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
        return "success";
    }

    private void loadClientAndProvider() throws DragonDelegateException, LocalizedError {
        if (this.managedAgreementTO.getIdClient() != null) {
            PartyTO clientTO = DragonServiceFactory.getInstance().getPartyManager().getParty(this.managedAgreementTO.getIdClient());
            if (clientTO instanceof OrganizationUnitTO) {
                this.clientBean = new OrganizationBean((OrganizationUnitTO)clientTO);
            } else if (clientTO instanceof PersonTO) {
                this.clientBean = new PersonBean((PersonTO)clientTO);
            }
        }
        if (this.managedAgreementTO.getIdProvider() != null) {
            PartyTO providerTO = DragonServiceFactory.getInstance().getPartyManager().getParty(this.managedAgreementTO.getIdProvider());
            if (providerTO instanceof OrganizationUnitTO) {
                this.providerBean = new OrganizationBean((OrganizationUnitTO)providerTO);
            } else if (providerTO instanceof PersonTO) {
                this.providerBean = new PersonBean((PersonTO)providerTO);
            }
        }
    }

    public String save() throws LocalizedError {
        try {
            if (this.managedAgreementTO != null) {
                this.managedAgreementTO.setAgreement(this.getAgreementBean().getAgreementTO());
                this.managedAgreementTO.setState(this.currentState);
            }
            this.agreementBean.save();
            DragonServiceFactory.getInstance().getSLAManager().updateManagedAgreement(this.managedAgreementTO);
            this.managedAgreementTO.setSlaDescription(StringHelper.prettyPrint((String)WSAgreementFactory.newInstance().newWSAgreementWriter().writeAgreement(this.managedAgreementTO.getAgreement())));
            this.slaDescription = this.managedAgreementTO.getSlaDescription();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String export() throws LocalizedError {
        try {
            this.managedAgreementTO.setSlaDescription(StringHelper.prettyPrint((String)DragonServiceFactory.getInstance().getSLAManager().exportServiceDefFile(this.id)));
            this.slaDescription = this.managedAgreementTO.getSlaDescription();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String create(String type, ManagedAgreementBean template, String agreementName, PartyBean client, String providerIdOrName, String clientEndpointName, Date expirationTime, TechnicalServiceBean techServiceBean, EndpointBean endpointBean) throws LocalizedError {
        try {
            OrganizationUnitTO clientTO = null;
            if (client instanceof OrganizationBean) {
                clientTO = DragonServiceFactory.getInstance().getOrganizationManager().getOrganization(client.getId());
            } else if (client instanceof PersonBean) {
                clientTO = DragonServiceFactory.getInstance().getPersonManager().getPerson(client.getId());
            }
            String providerName = null;
            PartyTO providerTO = null;
            if (providerIdOrName != null) {
                OrganizationBean providerBean = null;
                providerTO = DragonServiceFactory.getInstance().getPartyManager().getParty(providerIdOrName);
                if (providerTO instanceof OrganizationUnitTO) {
                    providerBean = new OrganizationBean((OrganizationUnitTO)providerTO);
                } else if (providerTO instanceof PersonTO) {
                    providerBean = new PersonBean((PersonTO)providerTO);
                }
                providerName = providerBean != null ? providerBean.getGenericName() : providerIdOrName;
            }
            if (providerName == null) {
                providerName = "anonymous_provider";
            }
            this.managedAgreementTO = new ManagedAgreementTO();
            if (clientTO != null) {
                this.managedAgreementTO.setIdClient(clientTO.getId());
            }
            if (providerTO != null) {
                this.managedAgreementTO.setIdProvider(providerTO.getId());
            }
            this.agreementBean.create(type, template, agreementName, client.getGenericName(), providerName, URLEncoder.encode(clientEndpointName, "UTF-8"), expirationTime, techServiceBean, endpointBean);
            this.managedAgreementTO.setAgreement(this.getAgreementBean().getAgreementTO());
            String id = DragonServiceFactory.getInstance().getSLAManager().createManagedAgreement(this.managedAgreementTO);
            this.managedAgreementTO.setId(id);
            this.managedAgreementTO.setSlaDescription(StringHelper.prettyPrint((String)DragonServiceFactory.getInstance().getSLAManager().exportServiceDefFile(this.managedAgreementTO.getId())));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.reset();
        return "success";
    }

    public String delete() throws LocalizedError {
        try {
            DragonServiceFactory.getInstance().getSLAManager().removeManagedAgreement(this.managedAgreementTO.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String deleteMetric(String metricName) throws LocalizedError {
        try {
            for (MetricBean m : this.agreementBean.getServicePropertiesBean().getMetrics()) {
                if (!m.getName().equals(metricName)) continue;
                this.agreementBean.getAgreementTO().getServiceProperties().removeVariable(m.getMTO());
                this.agreementBean.getServicePropertiesBean().getMetrics().remove(m);
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String deleteGuarantee(String guaranteeName) throws LocalizedError {
        try {
            for (GuaranteeBean gb : this.agreementBean.getGuaranteesBean()) {
                if (!gb.getName().equals(guaranteeName)) continue;
                this.agreementBean.getAgreementTO().removeGuarantee(gb.getGTO());
                this.agreementBean.getGuaranteesBean().remove(gb);
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public void reset() throws LocalizedError {
        if (this.managedAgreementTO != null) {
            this.id = this.managedAgreementTO.getId();
            this.setCurrentState(this.managedAgreementTO.getState());
            this.slaDescription = this.managedAgreementTO.getSlaDescription();
            this.agreementBean.reset();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AgreementBean getAgreementBean() {
        return this.agreementBean;
    }

    public void setAgreementBean(AgreementBean bean) {
        this.agreementBean = bean;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public ManagedAgreementTO getManagedAgreementTO() {
        return this.managedAgreementTO;
    }

    public void setManagedAgreementTO(ManagedAgreementTO managedAgreementTO) {
        this.managedAgreementTO = managedAgreementTO;
    }

    public Date getSignedByClient() {
        Date res = null;
        if (this.signedByClient != null) {
            res = (Date)this.signedByClient.clone();
        }
        return res;
    }

    public void setSignedByClient(Date signedByClient) {
        this.signedByClient = signedByClient != null ? (Date)signedByClient.clone() : null;
    }

    public Date getSignedByProvider() {
        Date res = null;
        if (this.signedByProvider != null) {
            res = (Date)this.signedByProvider.clone();
        }
        return res;
    }

    public void setSignedByProvider(Date signedByProvider) {
        this.signedByProvider = signedByProvider != null ? (Date)signedByProvider.clone() : null;
    }

    public String getSlaDescription() {
        return this.slaDescription;
    }

    public void setSlaDescription(String slaDescription) {
        this.slaDescription = slaDescription;
    }

    public static List<String> getListStates() {
        return listStates;
    }

    public PartyBean getClientBean() {
        return this.clientBean;
    }

    public void setClientBean(PartyBean clientBean) {
        this.clientBean = clientBean;
    }

    public PartyBean getProviderBean() {
        return this.providerBean;
    }

    public void setProviderBean(PartyBean providerBean) {
        this.providerBean = providerBean;
    }

    public String isOrganization(PartyBean pb) {
        String res = "person";
        if (pb instanceof OrganizationBean) {
            res = "organization";
        }
        return res;
    }

    public ManagedAgreementBean getNill() {
        return this.nill;
    }

    public void setNill(ManagedAgreementBean nill) {
        this.nill = nill;
    }

    public void setPending(HttpServletRequest iRequest, Object board) throws LocalizedError {
        this.load(iRequest);
        ((AgreementLifeCycle)this.getAgreementBean().getAgreementTO()).setState(AgreementLifeCycle.State.PENDING);
        this.managedAgreementTO.setState(AgreementLifeCycle.State.PENDING.value());
        this.save();
        if (board instanceof AgreementClientBoardBean) {
            ((AgreementClientBoardBean)board).load(iRequest);
        }
        if (board instanceof AgreementProviderBoardBean) {
            ((AgreementProviderBoardBean)board).load(iRequest);
        }
    }

    public void setObserve(HttpServletRequest iRequest, Object board) throws LocalizedError {
        this.load(iRequest);
        ((AgreementLifeCycle)this.getAgreementBean().getAgreementTO()).setState(AgreementLifeCycle.State.OBSERVE);
        this.managedAgreementTO.setState(AgreementLifeCycle.State.OBSERVE.value());
        this.save();
        if (board instanceof AgreementClientBoardBean) {
            ((AgreementClientBoardBean)board).load(iRequest);
        }
        if (board instanceof AgreementProviderBoardBean) {
            ((AgreementProviderBoardBean)board).load(iRequest);
        }
    }

    public void setReject(HttpServletRequest iRequest, Object board) throws LocalizedError {
        this.load(iRequest);
        ((AgreementLifeCycle)this.getAgreementBean().getAgreementTO()).setState(AgreementLifeCycle.State.REJECTE);
        this.managedAgreementTO.setState(AgreementLifeCycle.State.REJECTE.value());
        this.save();
        if (board instanceof AgreementClientBoardBean) {
            ((AgreementClientBoardBean)board).load(iRequest);
        }
        if (board instanceof AgreementProviderBoardBean) {
            ((AgreementProviderBoardBean)board).load(iRequest);
        }
    }
}

