/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.ReferenceParametersType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.WSAddressing4AgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Variable;
import com.ebmwebsourcing.wsstar.qml.WSQMLFactory;
import java.net.URI;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.opensuit.core.error.LocalizedError;

public class MetricBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private Variable mTO;
    private ManagedAgreementBean mab;
    private String name;
    private String metric;
    private String address;
    private String mode;
    private String operation;
    private String mbeanname;
    private String semanticConcept;
    private String ontology;
    private String dimension;
    private String type;
    private static String OPERATION = "operation";
    private static String DIMENSION = "dimension";
    private static String MODE = "mode";
    private static String MBEAN_NAME = "mbeanName";
    private static String TYPE = "type";

    public MetricBean() {
    }

    public MetricBean(Variable mTO, ManagedAgreementBean mab) throws LocalizedError {
        this.mTO = mTO;
        this.mab = mab;
        this.reset();
    }

    public void init(String idMetrics, ManagedAgreementBean mab) throws LocalizedError {
        block4: {
            this.mab = mab;
            try {
                if (!idMetrics.equals("-1")) {
                    if (this.mab.getAgreementBean().getServicePropertiesBean() == null) break block4;
                    for (MetricBean v : this.mab.getAgreementBean().getServicePropertiesBean().getMetrics()) {
                        if (!v.getName().equals(idMetrics)) continue;
                        this.mTO = v.getMTO();
                        this.mab.getAgreementBean().getServicePropertiesBean().getMetrics().remove(v);
                        this.mab.getAgreementBean().getServicePropertiesBean().getMetrics().add(this);
                        break block4;
                    }
                    break block4;
                }
                this.mTO = null;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        this.reset();
    }

    public String save() throws LocalizedError {
        try {
            if (this.mTO != null) {
                this.mTO.setName(this.name);
                this.mTO.setMetric(new URI(this.metric));
                this.mTO.getLocation().getQOSDimension().setSemanticConcept(this.semanticConcept);
                this.mTO.getLocation().getQOSDimension().setOntology(this.ontology);
                this.mTO.getLocation().getAddress().setAddress(this.address);
                if (((ReferenceParametersType)this.mTO.getLocation().getAddress().getReferenceParameters()).getMonitoringPropertiesType() == null) {
                    ((ReferenceParametersType)this.mTO.getLocation().getAddress().getReferenceParameters()).setMonitoringPropertiesType(((ReferenceParametersType)this.mTO.getLocation().getAddress().getReferenceParameters()).newMonitoringPropertiesType());
                }
                Properties properties = new Properties();
                properties.setProperty(TYPE, this.type);
                properties.setProperty(MODE, this.mode);
                properties.setProperty(OPERATION, this.operation);
                properties.setProperty(MBEAN_NAME, this.mbeanname);
                properties.setProperty(DIMENSION, this.dimension);
                ((ReferenceParametersType)this.mTO.getLocation().getAddress().getReferenceParameters()).getMonitoringPropertiesType().setProperty(properties);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        return "success";
    }

    public String create(ManagedAgreementBean ag) throws LocalizedError {
        this.mab = ag;
        if (ag.getAgreementBean().getAgreementTO() != null) {
            try {
                this.mTO = ag.getAgreementBean().getAgreementTO().getServiceProperties().newVariable();
                ag.getAgreementBean().getAgreementTO().getServiceProperties().addVariable(this.mTO);
                this.mTO.setLocation(this.mTO.newLocation());
                this.mTO.getLocation().setAddress(WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType());
                this.mTO.getLocation().setQOSDimension(WSQMLFactory.newInstance().newQOSDimension());
                this.save();
                ag.getAgreementBean().getServicePropertiesBean().getMetrics().add(new MetricBean(this.mTO, ag));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        return "success";
    }

    public void reset() throws LocalizedError {
        try {
            if (this.mTO != null) {
                this.name = this.mTO.getName();
                this.metric = this.mTO.getMetric().toString();
                if (this.mTO.getLocation() != null) {
                    if (this.mTO.getLocation().getQOSDimension() != null) {
                        this.semanticConcept = this.mTO.getLocation().getQOSDimension().getSemanticConcept();
                        this.ontology = this.mTO.getLocation().getQOSDimension().getOntology();
                    }
                    if (this.mTO.getLocation().getAddress() != null) {
                        this.address = this.mTO.getLocation().getAddress().getAddress();
                        if (this.mTO.getLocation().getAddress().getReferenceParameters() != null) {
                            if (((ReferenceParametersType)this.mTO.getLocation().getAddress().getReferenceParameters()).getMonitoringPropertiesType() != null) {
                                // empty if block
                            }
                            Properties properties = ((ReferenceParametersType)this.mTO.getLocation().getAddress().getReferenceParameters()).getMonitoringPropertiesType().getProperties();
                            this.mbeanname = properties.getProperty(MBEAN_NAME);
                            this.operation = properties.getProperty(OPERATION);
                            this.mode = properties.getProperty(MODE);
                            this.type = properties.getProperty(TYPE);
                            this.dimension = properties.getProperty(DIMENSION);
                        }
                    }
                }
            } else {
                this.name = null;
                this.metric = null;
                this.semanticConcept = null;
                this.ontology = null;
                this.address = null;
                this.mbeanname = null;
                this.operation = null;
                this.mode = null;
                this.type = null;
                this.dimension = null;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void clear() throws LocalizedError {
        try {
            this.mTO = this.mab.getAgreementBean().getAgreementTO().getServiceProperties().newVariable();
            this.mab.getAgreementBean().getAgreementTO().getServiceProperties().addVariable(this.mTO);
            this.mTO.setLocation(this.mTO.newLocation());
            this.mTO.getLocation().setAddress(WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType());
            this.mTO.getLocation().setQOSDimension(WSQMLFactory.newInstance().newQOSDimension());
            this.reset();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void validate() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String location) {
        this.address = location;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Variable getVariable() {
        return this.mTO;
    }

    public String getSemanticConcept() {
        return this.semanticConcept;
    }

    public void setSemanticConcept(String semanticConcept) {
        this.semanticConcept = semanticConcept;
    }

    public String getOntology() {
        return this.ontology;
    }

    public void setOntology(String ontology) {
        this.ontology = ontology;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getMbeanname() {
        return this.mbeanname;
    }

    public void setMbeanname(String mbeanname) {
        this.mbeanname = mbeanname;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Variable getMTO() {
        return this.mTO;
    }

    public void setMTO(Variable mto) {
        this.mTO = mto;
    }

    public ManagedAgreementBean getMab() {
        return this.mab;
    }

    public void setMab(ManagedAgreementBean mab) {
        this.mab = mab;
    }
}

