/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.sla;

import com.ebmwebsourcing.agreement.definition.api.ServiceProperties;
import com.ebmwebsourcing.agreement.definition.api.Variable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.dragon.ui.uibeans.sla.ManagedAgreementBean;
import org.ow2.dragon.ui.uibeans.sla.MetricBean;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePropertiesBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private ServiceProperties spTO;
    private ManagedAgreementBean mab;
    private String name;
    private String serviceName;
    private List<MetricBean> metrics;

    public ServicePropertiesBean() {
    }

    public ServicePropertiesBean(ServiceProperties spTO, ManagedAgreementBean mab) throws LocalizedError {
        this.spTO = spTO;
        this.mab = mab;
        this.metrics = new ArrayList();
        if (this.spTO != null) {
            for (Variable metric : this.spTO.getVariables()) {
                this.metrics.add(new MetricBean(metric, mab));
            }
        }
        this.reset();
    }

    public String save() throws LocalizedError {
        this.spTO.setName(this.name);
        this.spTO.setServiceName(this.serviceName);
        if (this.metrics != null) {
            for (MetricBean metric : this.metrics) {
                this.spTO.getVariables().add(metric.getVariable());
            }
        }
        return "success";
    }

    public void reset() throws LocalizedError {
        if (this.spTO != null) {
            this.name = this.spTO.getName();
            this.serviceName = this.spTO.getServiceName();
            if (this.metrics != null) {
                for (MetricBean m : this.metrics) {
                    m.reset();
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public List<MetricBean> getMetrics() {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        return this.metrics;
    }

    public ServiceProperties getSpTO() {
        return this.spTO;
    }

    public void setSpTO(ServiceProperties spTO) {
        this.spTO = spTO;
    }

    public ManagedAgreementBean getMab() {
        return this.mab;
    }

    public void setMab(ManagedAgreementBean mab) {
        this.mab = mab;
    }
}

