/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.uibeans.technology;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.ui.utils.StringHelper;
import org.ow2.opensuit.core.error.LocalizedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfProcessorsBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private List<ProcessorTO> processors;
    private String searchCriteria;
    private List<String> searchedProperties;

    public void loadAll() throws LocalizedError {
        try {
            this.processors = DragonServiceFactory.getInstance().getTechnologyManager().getAllProcessors(this.createSortOption("name", true));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void search(HttpServletRequest request) throws LocalizedError {
        boolean all = Boolean.parseBoolean(request.getParameter("all"));
        if (all) {
            this.loadAll();
        } else {
            String searchCriteria = request.getParameter("searchCriteria");
            String searchedPropertiesParam = request.getParameter("searchedProperties");
            List searchedProperties = StringHelper.urlParameterToArray((String)searchedPropertiesParam);
            try {
                this.processors = DragonServiceFactory.getInstance().getTechnologyManager().searchProcessors(searchCriteria, searchedProperties, this.createSortOption("name", true));
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
            if (this.processors == null || this.processors.size() == 0) {
                LocalizedError error = new LocalizedError("search_processor_no_result");
                error.setType((short)0);
                throw error;
            }
        }
    }

    private RequestOptionsTO createSortOption(String sortOn, boolean ascendingly) {
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(ascendingly);
        requestOptionsTO.setSortCriteria(sortOn);
        return requestOptionsTO;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public List<String> getSearchedProperties() {
        return this.searchedProperties;
    }

    public void setSearchedProperties(List<String> searchedProperties) {
        this.searchedProperties = searchedProperties;
    }

    public List<ProcessorTO> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<ProcessorTO> processors) {
        this.processors = processors;
    }
}

